/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.requitur;

import de.dagere.requitur.ExistingRuleMarker;
import de.dagere.requitur.ReducedTraceElement;
import de.dagere.requitur.Rule;
import de.dagere.requitur.Sequitur;
import de.dagere.requitur.Symbol;
import de.dagere.requitur.content.Content;
import de.dagere.requitur.content.RuleContent;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunLengthEncodingSequitur {
    private static final Logger LOG = LogManager.getLogger(RunLengthEncodingSequitur.class);
    private final Sequitur sequitur;

    public RunLengthEncodingSequitur(Sequitur sequitur) {
        this.sequitur = sequitur;
    }

    public void reduce() {
        this.reduce(this.sequitur.getStartSymbol());
        this.removeSingleUsageRules(this.sequitur.getStartSymbol().getSuccessor());
        this.reduce(this.sequitur.getStartSymbol());
        this.markExistingRules();
        this.reduce(this.sequitur.getStartSymbol());
        this.removeSingleUsageRules(this.sequitur.getStartSymbol().getSuccessor());
    }

    private void markExistingRules() {
        ExistingRuleMarker marker = new ExistingRuleMarker(this.sequitur);
        marker.mark();
    }

    private void removeSingleUsageRules(Symbol iterator) {
        while (iterator != null && iterator.getValue() != null && iterator.getSuccessor() != null) {
            if (iterator.getValue() instanceof RuleContent) {
                RuleContent ruleName = (RuleContent)iterator.getValue();
                Rule rule = this.sequitur.getRules().get(ruleName.getValue());
                this.removeSingleUsageRules(rule.getAnchor().getSuccessor());
                if (iterator.getOccurences() == 1) {
                    this.removeSingleOccurenceRule(iterator, rule);
                }
                iterator = iterator.getSuccessor();
                continue;
            }
            iterator = iterator.getSuccessor();
        }
    }

    private void removeSingleOccurenceRule(Symbol iterator, Rule rule) {
        Symbol copied;
        Symbol currentPredecessor = iterator.getPredecessor();
        Symbol ruleIterator = rule.getAnchor().getSuccessor();
        while (ruleIterator.getSuccessor() != rule.getAnchor()) {
            currentPredecessor = copied = this.copySymbol(currentPredecessor, ruleIterator);
            ruleIterator = ruleIterator.getSuccessor();
        }
        copied = this.copySymbol(currentPredecessor, ruleIterator);
        copied.setSuccessor(iterator.getSuccessor());
        iterator.getSuccessor().setPredecessor(copied);
    }

    private Symbol copySymbol(Symbol currentPredecessor, Symbol ruleIterator) {
        Symbol copied = new Symbol(this.sequitur, ruleIterator.getValue(), ruleIterator.getRule());
        copied.setOccurences(ruleIterator.getOccurences());
        currentPredecessor.setSuccessor(copied);
        copied.setPredecessor(currentPredecessor);
        return copied;
    }

    private void reduce(Symbol start) {
        Symbol iterator = start.getSuccessor();
        this.reduceRule(iterator);
        while (iterator != null && iterator.getValue() != null && iterator.getSuccessor() != null && iterator.getSuccessor().getValue() != null) {
            Symbol successor = iterator.getSuccessor();
            this.reduceRule(successor);
            if (iterator.valueEqual(successor)) {
                this.mergeOccurences(iterator, successor);
                continue;
            }
            iterator = iterator.getSuccessor();
        }
    }

    private void mergeOccurences(Symbol iterator, Symbol successor) {
        if (successor.getSuccessor() != null) {
            iterator.setSuccessor(successor.getSuccessor());
            successor.getSuccessor().setPredecessor(iterator);
        } else {
            iterator.setSuccessor(null);
        }
        iterator.setOccurences(iterator.getOccurences() + successor.getOccurences());
    }

    private void reduceRule(Symbol containingSymbol) {
        if (containingSymbol.isRule()) {
            LOG.trace("Reduce: {}", (Object)containingSymbol);
            Rule rule = containingSymbol.getRule();
            Symbol ruleAnchor = rule.getAnchor();
            this.reduce(ruleAnchor);
            Symbol firstSymbolOfRule = ruleAnchor.getSuccessor();
            LOG.trace("Reduced: {}", (Object)rule.getName());
            LOG.trace("Rule-Length: {}", (Object)(rule.getElements().size() + " " + (firstSymbolOfRule.getSuccessor() == ruleAnchor)));
            if (firstSymbolOfRule.getSuccessor() == ruleAnchor) {
                this.removeRuleUsage(containingSymbol, rule, firstSymbolOfRule);
            }
        }
    }

    private void removeRuleUsage(Symbol containingSymbol, Rule rule, Symbol firstSymbolOfRule) {
        containingSymbol.setValue(firstSymbolOfRule.getValue());
        containingSymbol.setOccurences(containingSymbol.getOccurences() * firstSymbolOfRule.getOccurences());
        containingSymbol.decrementUsage(rule);
        if (firstSymbolOfRule.getRule() != null) {
            containingSymbol.setRule(firstSymbolOfRule.getRule());
        } else {
            firstSymbolOfRule.setRule(null);
        }
    }

    public List<ReducedTraceElement> getReadableRLETrace() {
        LinkedList<ReducedTraceElement> trace = new LinkedList<ReducedTraceElement>();
        for (Symbol iterator = this.sequitur.getStartSymbol().getSuccessor(); iterator != null; iterator = iterator.getSuccessor()) {
            this.addReadableElement(iterator, trace);
        }
        return trace;
    }

    public List<ReducedTraceElement> getTopLevelTrace() {
        LinkedList<ReducedTraceElement> trace = new LinkedList<ReducedTraceElement>();
        for (Symbol iterator = this.sequitur.getStartSymbol().getSuccessor(); iterator != null; iterator = iterator.getSuccessor()) {
            ReducedTraceElement newElement = new ReducedTraceElement(iterator.getValue(), iterator.getOccurences());
            trace.add(newElement);
        }
        return trace;
    }

    private int addReadableElement(Symbol iterator, List<ReducedTraceElement> trace) {
        Content content = iterator.getValue();
        LOG.trace("Add: {} {}", (Object)content, content.getClass());
        ReducedTraceElement newElement = new ReducedTraceElement(content, iterator.getOccurences());
        if (content instanceof RuleContent) {
            return this.addRuleContent(iterator, trace, content, newElement);
        }
        trace.add(newElement);
        return 1;
    }

    private int addRuleContent(Symbol iterator, List<ReducedTraceElement> trace, Content content, ReducedTraceElement newElement) {
        RuleContent currentContent = (RuleContent)content;
        trace.add(newElement);
        Rule rule = iterator.getRule();
        Symbol anchor = rule.getAnchor();
        int subElements = 1;
        for (Symbol ruleIterator = anchor.getSuccessor(); ruleIterator != anchor; ruleIterator = ruleIterator.getSuccessor()) {
            subElements += this.addReadableElement(ruleIterator, trace);
        }
        currentContent.setCount(subElements - 1);
        return subElements;
    }
}

