/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.requitur;

import de.dagere.requitur.Digram;
import de.dagere.requitur.Rule;
import de.dagere.requitur.Symbol;
import de.dagere.requitur.content.Content;
import de.dagere.requitur.content.StringContent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Sequitur {
    private static final Logger LOG = LogManager.getLogger(Sequitur.class);
    protected Map<Digram, Digram> digrams = new HashMap<Digram, Digram>();
    protected Map<String, Rule> rules = new HashMap<String, Rule>();
    protected List<Rule> ununsedRules = new LinkedList<Rule>();
    protected Symbol startSymbol;
    protected Symbol lastSymbol = this.startSymbol = new Symbol(this, (Content)null);
    protected int ruleindex = 0;
    protected List<Content> addingElements;

    Digram link(Symbol start, Symbol end) {
        start.setSuccessor(end);
        end.setPredecessor(start);
        if (start.getValue() != null && end.getValue() != null) {
            Digram newDigram = new Digram(start, end);
            this.handleDigram(newDigram);
            return newDigram;
        }
        return null;
    }

    public void addElement(Symbol symbol) {
        if (this.startSymbol == null) {
            this.startSymbol = symbol;
            this.lastSymbol = symbol;
        } else {
            this.lastSymbol.setSuccessor(symbol);
            symbol.setPredecessor(this.lastSymbol);
            this.lastSymbol = symbol;
            if (symbol.getPredecessor().getValue() != null) {
                Digram digram = new Digram(symbol.getPredecessor(), symbol);
                this.handleDigram(digram);
            }
        }
    }

    void handleDigram(Digram digram) {
        Digram existing = this.digrams.get(digram);
        if (existing != null) {
            if (digram.getStart() != existing.getEnd()) {
                if (existing.rule != null) {
                    existing.rule.use(digram);
                } else {
                    Rule rule;
                    if (this.ununsedRules.size() > 0) {
                        rule = this.ununsedRules.remove(0);
                        rule.setDigram(existing);
                    } else {
                        rule = new Rule(this, this.ruleindex, existing);
                        ++this.ruleindex;
                    }
                    this.rules.put(rule.getName(), rule);
                    rule.use(digram);
                }
            }
        } else {
            this.digrams.put(digram, digram);
        }
    }

    public List<Content> getTrace() {
        LinkedList<Content> trace = new LinkedList<Content>();
        for (Symbol iterator = this.startSymbol.getSuccessor(); iterator != null; iterator = iterator.getSuccessor()) {
            trace.add(iterator.getValue());
        }
        return trace;
    }

    public List<Content> getUncompressedTrace() {
        LinkedList<Content> trace = new LinkedList<Content>();
        for (Symbol iterator = this.startSymbol.getSuccessor(); iterator != null; iterator = iterator.getSuccessor()) {
            for (int i = 0; i < iterator.getOccurences(); ++i) {
                trace.add(iterator.getValue());
            }
        }
        return trace;
    }

    public Map<String, Rule> getRules() {
        return this.rules;
    }

    public String toString() {
        return this.getTrace().toString();
    }

    public void addElements(List<String> mytrace) {
        this.addingElements = new LinkedList<Content>();
        for (String element : mytrace) {
            this.addingElements.add(new StringContent(element));
            Symbol symbol = new Symbol(this, new StringContent(element));
            this.addElement(symbol);
        }
    }

    public Symbol getStartSymbol() {
        return this.startSymbol;
    }

    public static List<String> getExpandedTrace(File methodTraceFile) throws IOException, FileNotFoundException {
        LinkedList<String> trace1 = new LinkedList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(methodTraceFile));){
            String line;
            while ((line = br.readLine()) != null) {
                List<String> elements = Sequitur.getCurrentValues((String)line, (BufferedReader)br).elements;
                trace1.addAll(elements);
            }
        }
        return trace1;
    }

    public static Return getCurrentValues(String line, BufferedReader reader) throws IOException {
        Return current = new Return();
        String trimmedLine = line.trim();
        if (line.matches("[ ]*[0-9]+ x [#]?[0-9]* \\([0-9]+\\)")) {
            int i;
            Return lines;
            String[] parts = trimmedLine.split(" ");
            int count = Integer.parseInt(parts[0]);
            int length = Integer.parseInt(parts[3].replaceAll("[\\(\\)]", ""));
            LinkedList<String> subList = new LinkedList<String>();
            for (i = 0; i < length; i += lines.readLines) {
                line = reader.readLine();
                lines = Sequitur.getCurrentValues(line, reader);
                current.readLines += lines.readLines;
                subList.addAll(lines.elements);
            }
            for (i = 0; i < count; ++i) {
                current.elements.addAll(subList);
            }
        } else if (line.matches("[ ]*[0-9]+ x .*$")) {
            String method = trimmedLine.substring(trimmedLine.indexOf("x") + 2);
            String countString = trimmedLine.substring(0, trimmedLine.indexOf("x") - 1);
            int count = Integer.parseInt(countString);
            for (int i = 0; i < count; ++i) {
                current.elements.add(method);
            }
        } else if (!line.matches("[ ]*[#]?[0-9]* \\([0-9]+\\)")) {
            current.elements.add(trimmedLine);
        }
        return current;
    }

    public List<Content> getAddingElements() {
        return this.addingElements;
    }

    static class Return {
        int readLines = 1;
        List<String> elements = new LinkedList<String>();

        Return() {
        }
    }
}

