/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.requitur;

import de.dagere.requitur.Digram;
import de.dagere.requitur.Rule;
import de.dagere.requitur.Sequitur;
import de.dagere.requitur.content.Content;
import de.dagere.requitur.content.RuleContent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Symbol {
    private static final Logger LOG = LogManager.getLogger(Symbol.class);
    private final Sequitur sequitur;
    private Symbol predecessor;
    private Symbol successor;
    private Content value;
    private RuleContent name;
    private Rule rule;
    private int occurences = 1;

    public Symbol(Sequitur seguitur, Content value) {
        this.sequitur = seguitur;
        this.value = value;
        this.rule = null;
        this.name = null;
    }

    public Symbol(Sequitur seguitur, Symbol other) {
        this.sequitur = seguitur;
        this.value = other.value;
        this.name = other.name;
        this.occurences = other.getOccurences();
        if (other.rule != null) {
            this.rule = other.rule;
            ++this.rule.usage;
        } else {
            this.rule = null;
        }
    }

    public Symbol(Sequitur seguitur, Content value, Rule rule) {
        this.sequitur = seguitur;
        this.value = value;
        this.rule = rule;
        this.name = null;
    }

    public Symbol(Sequitur seguitur, Rule rule) {
        this.sequitur = seguitur;
        this.rule = rule;
        this.name = new RuleContent(rule.getName());
        this.value = null;
    }

    public Symbol getPredecessor() {
        return this.predecessor;
    }

    public void setPredecessor(Symbol predecessor) {
        this.predecessor = predecessor;
    }

    public Symbol getSuccessor() {
        return this.successor;
    }

    public void setSuccessor(Symbol successor) {
        this.successor = successor;
    }

    public int getOccurences() {
        return this.occurences;
    }

    public void setOccurences(int occurences) {
        this.occurences = occurences;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Content getValue() {
        return this.value != null ? this.value : this.name;
    }

    public boolean valueEqual(Symbol other) {
        return other.getValue().equals(this.getValue());
    }

    public String toString() {
        Content value = this.getValue();
        if (value == null) {
            return null;
        }
        return this.occurences == 1 ? value.toString() : this.occurences + " x " + value.toString();
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        if (this.name != null) {
            return this.name.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Symbol) {
            Symbol other = (Symbol)obj;
            Content otherContent = other.getValue();
            return otherContent.equals(this.getValue()) && other.getOccurences() == this.occurences;
        }
        return false;
    }

    public void decrementUsage(Rule usingRule) {
        if (this.rule != null) {
            this.rule.decrementUsage();
            if (this.rule.usage == 1) {
                this.removeSingleUsageRule(usingRule);
            }
        }
    }

    public void removeSingleUsageRule(Rule usingRule) {
        if (this.rule.getAnchor().successor.successor == this.rule.getAnchor().predecessor) {
            this.replaceTraceDigram();
        }
        Symbol firstElement = this.rule.getAnchor().successor;
        Symbol lastElement = this.rule.getAnchor().predecessor;
        this.sequitur.rules.remove(this.rule.getName());
        this.sequitur.ununsedRules.add(this.rule);
        if (usingRule.getAnchor().successor.equals(this)) {
            this.replaceStartRule(usingRule, firstElement, lastElement);
        } else if (usingRule.getAnchor().predecessor.equals(this)) {
            this.replaceEndRule(usingRule, firstElement, lastElement);
        } else {
            throw new RuntimeException("Unexpected: Rule-Symbol " + this.getValue() + " is deleted, but deleted symbol is neither start nor end of rule " + usingRule);
        }
        this.rule.usage = 0;
    }

    private void replaceEndRule(Rule usingRule, Symbol firstElement, Symbol lastElement) {
        Symbol temp = usingRule.getAnchor().predecessor.predecessor;
        this.sequitur.digrams.remove(new Digram(usingRule.getAnchor().predecessor, usingRule.getAnchor().predecessor.predecessor));
        this.sequitur.link(usingRule.getAnchor(), lastElement);
        this.sequitur.link(firstElement, temp);
    }

    private void replaceStartRule(Rule usingRule, Symbol firstElement, Symbol lastElement) {
        Symbol temp = usingRule.getAnchor().successor.successor;
        this.sequitur.digrams.remove(new Digram(usingRule.getAnchor().successor, usingRule.getAnchor().successor.successor));
        this.sequitur.link(usingRule.getAnchor(), firstElement);
        this.sequitur.link(lastElement, temp);
    }

    private void replaceTraceDigram() {
        Digram ruleDigram = new Digram(this.rule.getAnchor().successor, this.rule.getAnchor().successor.successor);
        Digram savedDigram = this.sequitur.digrams.get(ruleDigram);
        savedDigram.rule = null;
    }

    public void setValue(Content value) {
        this.value = value;
        this.name = null;
    }

    public boolean isRule() {
        return this.name != null;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }
}

