/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.crySL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BuiltinPredicates implements Enumerator
{
    NEVER_TYPE_OF(0, "NEVER_TYPE_OF", "neverTypeOf"),
    INSTANCE_OF(1, "INSTANCE_OF", "instanceOf"),
    NO_CALL_TO(2, "NO_CALL_TO", "noCallTo"),
    CALL_TO(3, "CALL_TO", "callTo"),
    NOT_HARD_CODED(4, "NOT_HARD_CODED", "notHardCoded"),
    LENGTH(5, "LENGTH", "length");

    public static final int NEVER_TYPE_OF_VALUE = 0;
    public static final int INSTANCE_OF_VALUE = 1;
    public static final int NO_CALL_TO_VALUE = 2;
    public static final int CALL_TO_VALUE = 3;
    public static final int NOT_HARD_CODED_VALUE = 4;
    public static final int LENGTH_VALUE = 5;
    private static final BuiltinPredicates[] VALUES_ARRAY;
    public static final List<BuiltinPredicates> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BuiltinPredicates[]{NEVER_TYPE_OF, INSTANCE_OF, NO_CALL_TO, CALL_TO, NOT_HARD_CODED, LENGTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BuiltinPredicates get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BuiltinPredicates result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BuiltinPredicates getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BuiltinPredicates result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BuiltinPredicates get(int value) {
        switch (value) {
            case 0: {
                return NEVER_TYPE_OF;
            }
            case 1: {
                return INSTANCE_OF;
            }
            case 2: {
                return NO_CALL_TO;
            }
            case 3: {
                return CALL_TO;
            }
            case 4: {
                return NOT_HARD_CODED;
            }
            case 5: {
                return LENGTH;
            }
        }
        return null;
    }

    private BuiltinPredicates(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

