/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.scoping;

import de.darmstadt.tu.crossing.crySL.AnyParameterType;
import de.darmstadt.tu.crossing.crySL.Domainmodel;
import de.darmstadt.tu.crossing.crySL.ForbiddenMethod;
import de.darmstadt.tu.crossing.crySL.Method;
import de.darmstadt.tu.crossing.crySL.Parameter;
import de.darmstadt.tu.crossing.scoping.AbstractCrySLScopeProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.impl.TypesFactoryImpl;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class CrySLScopeProvider
extends AbstractCrySLScopeProvider {
    public IScope getScope(EObject context, EReference reference) {
        IScope scope = this.polymorphicFindScopeForReferenceName(context, reference);
        if (scope == null) {
            scope = this.delegateGetScope(context, reference);
        }
        if (scope == null) {
            scope = IScope.NULLSCOPE;
        }
        return this.handleGenericTypes(context, reference, scope);
    }

    IScope handleGenericTypes(EObject context, EReference reference, IScope scope) {
        if (reference != TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE) {
            return scope;
        }
        if (context.eContainer() instanceof Domainmodel) {
            return scope;
        }
        Domainmodel model = (Domainmodel)EcoreUtil.getRootContainer((EObject)context);
        if (!(model.getJavaType().getType() instanceof JvmGenericType)) {
            return scope;
        }
        JvmGenericType clazz = (JvmGenericType)model.getJavaType().getType();
        ArrayList<IEObjectDescription> scopeElements = new ArrayList<IEObjectDescription>(clazz.getTypeParameters().size());
        for (JvmTypeParameter parameter : clazz.getTypeParameters()) {
            scopeElements.add(EObjectDescription.create((String)parameter.getName(), (EObject)parameter));
        }
        return new SimpleScope(scope, scopeElements);
    }

    IScope scope_ForbiddenMethod_method(ForbiddenMethod method, EReference reference) {
        try {
            Domainmodel model = (Domainmodel)EcoreUtil.getRootContainer((EObject)method);
            JvmGenericType jvmType = (JvmGenericType)model.getJavaType().getType();
            EList<JvmTypeReference> parameters = method.getParameters();
            return new SimpleScope(this.getDescriptionForMatchingMethods(jvmType, (List<JvmTypeReference>)parameters));
        }
        catch (ClassCastException e) {
            CrySLScopeProvider.debug(e);
        }
        catch (Exception e) {
            CrySLScopeProvider.debug(e);
        }
        return IScope.NULLSCOPE;
    }

    public IScope scope_Method_method(Method method, EReference reference) {
        try {
            Domainmodel model = (Domainmodel)EcoreUtil.getRootContainer((EObject)method);
            JvmGenericType jvmType = (JvmGenericType)model.getJavaType().getType();
            List<JvmTypeReference> parameters = this.resolveTypeFromObject((List<Parameter>)method.getParameters());
            return new SimpleScope(this.getDescriptionForMatchingMethods(jvmType, parameters));
        }
        catch (ClassCastException e) {
            CrySLScopeProvider.debug(e);
        }
        catch (Exception e) {
            CrySLScopeProvider.debug(e);
        }
        return IScope.NULLSCOPE;
    }

    public List<IEObjectDescription> getDescriptionForMatchingMethods(JvmGenericType type, List<JvmTypeReference> parameters) {
        ArrayList<IEObjectDescription> d = new ArrayList<IEObjectDescription>(2);
        for (JvmExecutable method : this.getMethods(type)) {
            if (!this.matchingParameters(method, parameters)) continue;
            d.add(EObjectDescription.create((String)method.getSimpleName(), (EObject)method));
        }
        for (JvmExecutable constructor : type.getDeclaredConstructors()) {
            if (!this.matchingParameters(constructor, parameters)) continue;
            d.add(EObjectDescription.create((String)constructor.getSimpleName(), (EObject)constructor));
        }
        return d;
    }

    protected List<JvmTypeReference> resolveTypeFromObject(List<Parameter> parameters) {
        ArrayList<JvmTypeReference> ret = new ArrayList<JvmTypeReference>(parameters.size());
        for (Parameter p : parameters) {
            if (p instanceof AnyParameterType) {
                ret.add((JvmTypeReference)TypesFactoryImpl.init().createJvmAnyTypeReference());
                continue;
            }
            ret.add(p.getValue().getType());
        }
        return ret;
    }

    protected boolean matchingParameters(JvmExecutable a, List<JvmTypeReference> b) {
        EList params = a.getParameters();
        if (params.size() != b.size()) {
            return false;
        }
        ArrayList<JvmTypeReference> _a = new ArrayList<JvmTypeReference>(params.size());
        for (JvmFormalParameter fp : params) {
            _a.add(fp.getParameterType());
        }
        return this.matchingParameters(_a, b);
    }

    protected boolean matchingParameters(List<JvmTypeReference> a, List<JvmTypeReference> b) {
        if (a.size() != b.size()) {
            return false;
        }
        int i = 0;
        while (i < a.size()) {
            if (!(a.get(i) instanceof JvmAnyTypeReference || b.get(i) instanceof JvmAnyTypeReference || a.get(i).getIdentifier().equals(b.get(i).getIdentifier()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected List<JvmExecutable> getMethods(JvmGenericType type) {
        ArrayList<JvmExecutable> methods = new ArrayList<JvmExecutable>();
        for (JvmExecutable e : type.getDeclaredOperations()) {
            methods.add(e);
        }
        if (type.getExtendedClass() != null) {
            methods.addAll(this.getMethods((JvmGenericType)type.getExtendedClass().getType()));
        }
        for (JvmTypeReference superType : type.getExtendedInterfaces()) {
            methods.addAll(this.getMethods((JvmGenericType)superType.getType()));
        }
        return methods;
    }

    private static void debug(Object o) {
    }
}

