/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.validation;

import de.darmstadt.tu.crossing.crySL.Aggregate;
import de.darmstadt.tu.crossing.crySL.Constraint;
import de.darmstadt.tu.crossing.crySL.CrySLPackage;
import de.darmstadt.tu.crossing.crySL.Domainmodel;
import de.darmstadt.tu.crossing.crySL.Event;
import de.darmstadt.tu.crossing.crySL.EventsBlock;
import de.darmstadt.tu.crossing.crySL.ExceptionAggregate;
import de.darmstadt.tu.crossing.crySL.ExceptionDeclaration;
import de.darmstadt.tu.crossing.crySL.ObjectOp;
import de.darmstadt.tu.crossing.crySL.ObjectOperation;
import de.darmstadt.tu.crossing.crySL.ObjectsBlock;
import de.darmstadt.tu.crossing.crySL.Operator;
import de.darmstadt.tu.crossing.validation.AbstractCrySLValidator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.validation.Check;

public class CrySLValidator
extends AbstractCrySLValidator {
    public static final String WRN_TYPE_PARAMETERS_NOT_SPECIFIED = "Type under specification is generic, type parameters should be specified: <%s>";
    public static final String ERR_EXCEPTION_NOT_THROWABLE = "%s does not implement java.lang.Throwable";
    public static final String ERR_TYPE_NOT_GENERIC = "Type under specification is not generic, but type parameters were specified";
    public static final String ERR_TYPE_PARAMETERS_MISMATCH = "Specfied parameters do not match expected parameters: <%s>";
    public static final String ERR_TYPE_PARAMETER_MISMATCH = "Specfied parameter does not match expected parameter: %s";
    public static final String ERR_ELEMENTS_OUTSIDE_IN = "elements(..) must only be used with an in-Expression";
    public static final String AGGREGATE_INFINITE_RECURSION = "Aggregate must not recursively include itself";
    public static final String ERR_DUPLICATE_EVENT = "Event already defined";
    public static final String ERR_DUPLICATE_OBJECT = "Object already defined";

    @Check
    public void checkExceptions(ExceptionDeclaration exc) {
        try {
            Class<?> e = Class.forName(exc.getException().getType().getIdentifier());
            if (!Throwable.class.isAssignableFrom(e)) {
                this.warning(String.format(ERR_EXCEPTION_NOT_THROWABLE, e.getName()), exc, (EStructuralFeature)CrySLPackage.Literals.EXCEPTION_DECLARATION__EXCEPTION);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    @Check
    public void checkExceptionAggregate(ExceptionAggregate a) {
        HashSet<ExceptionAggregate> visited = new HashSet<ExceptionAggregate>();
        LinkedList<ExceptionAggregate> toVisit = new LinkedList<ExceptionAggregate>();
        toVisit.add(a);
        while (!toVisit.isEmpty()) {
            ExceptionAggregate current = (ExceptionAggregate)toVisit.pop();
            if (visited.contains(current)) {
                this.error(AGGREGATE_INFINITE_RECURSION, a, (EStructuralFeature)CrySLPackage.Literals.EXCEPTION__NAME);
                return;
            }
            visited.add(current);
            current.getExceptions().stream().filter(exception -> exception instanceof ExceptionAggregate).map(exception -> (ExceptionAggregate)exception).forEach(toVisit::push);
        }
    }

    @Check
    public void checkGenericType(Domainmodel model) {
        if (!(model.getJavaType() instanceof JvmParameterizedTypeReference)) {
            return;
        }
        if (!(model.getJavaType().getType() instanceof JvmGenericType)) {
            return;
        }
        JvmGenericType clazz = (JvmGenericType)model.getJavaType().getType();
        JvmParameterizedTypeReference spec = (JvmParameterizedTypeReference)model.getJavaType();
        EList expected = clazz.getTypeParameters();
        EList actual = spec.getArguments();
        String suggestion = expected.stream().map(JvmTypeParameter::getName).collect(Collectors.joining(", "));
        if (actual.size() == 0 && expected.size() != 0) {
            this.warning(String.format(WRN_TYPE_PARAMETERS_NOT_SPECIFIED, suggestion), model, (EStructuralFeature)CrySLPackage.Literals.DOMAINMODEL__JAVA_TYPE);
        } else if (actual.size() != 0 && expected.size() == 0) {
            this.error(ERR_TYPE_NOT_GENERIC, model, (EStructuralFeature)CrySLPackage.Literals.DOMAINMODEL__JAVA_TYPE);
        } else if (actual.size() != expected.size()) {
            this.error(String.format(ERR_TYPE_PARAMETERS_MISMATCH, suggestion), model, (EStructuralFeature)CrySLPackage.Literals.DOMAINMODEL__JAVA_TYPE);
        } else {
            int i = 0;
            while (i < expected.size()) {
                if (!((JvmTypeParameter)expected.get(i)).equals(((JvmTypeReference)actual.get(i)).getType())) {
                    this.error(String.format(ERR_TYPE_PARAMETER_MISMATCH, ((JvmTypeParameter)expected.get(i)).getName()), (EObject)model.getJavaType(), (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__ARGUMENTS, i);
                }
                ++i;
            }
        }
    }

    @Check
    public void checkElements(ObjectOperation e) {
        if (e.getFn() != ObjectOp.ELEMENTS) {
            return;
        }
        Constraint parent = (Constraint)e.eContainer();
        if (parent.getOp() == Operator.IN) {
            return;
        }
        EReference side = CrySLPackage.Literals.CONSTRAINT__LEFT;
        this.error(ERR_ELEMENTS_OUTSIDE_IN, parent, (EStructuralFeature)side);
    }

    @Check
    public void checkAggregate(Aggregate a) {
        HashSet<Aggregate> visited = new HashSet<Aggregate>();
        LinkedList<Aggregate> toVisit = new LinkedList<Aggregate>();
        toVisit.add(a);
        while (!toVisit.isEmpty()) {
            Aggregate current = (Aggregate)toVisit.pop();
            if (visited.contains(current)) {
                this.error(AGGREGATE_INFINITE_RECURSION, a, (EStructuralFeature)CrySLPackage.Literals.EVENT__NAME);
                return;
            }
            visited.add(current);
            current.getEvents().stream().filter(event -> event instanceof Aggregate).map(event -> (Aggregate)event).forEach(toVisit::push);
        }
    }

    @Check
    public void checkDuplicateEventLabel(ObjectsBlock o) {
        EList<de.darmstadt.tu.crossing.crySL.Object> objects = o.getDeclarations();
        int i = 0;
        while (i < objects.size()) {
            int j = i + 1;
            while (j < objects.size()) {
                de.darmstadt.tu.crossing.crySL.Object a = (de.darmstadt.tu.crossing.crySL.Object)objects.get(i);
                de.darmstadt.tu.crossing.crySL.Object b = (de.darmstadt.tu.crossing.crySL.Object)objects.get(j);
                if (a.getName().equals(b.getName())) {
                    this.error(ERR_DUPLICATE_OBJECT, b, (EStructuralFeature)CrySLPackage.Literals.OBJECT__NAME);
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkDuplicateEventLabel(EventsBlock e) {
        EList<Event> events = e.getEvents();
        int i = 0;
        while (i < events.size()) {
            int j = i + 1;
            while (j < events.size()) {
                Event a = (Event)events.get(i);
                Event b = (Event)events.get(j);
                if (a.getName().equals(b.getName())) {
                    this.error(ERR_DUPLICATE_EVENT, b, (EStructuralFeature)CrySLPackage.Literals.EVENT__NAME);
                }
                ++j;
            }
            ++i;
        }
    }
}

