/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.crySL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ObjectOp implements Enumerator
{
    PART(0, "PART", "part"),
    ALG(1, "ALG", "alg"),
    MODE(2, "MODE", "mode"),
    PAD(3, "PAD", "pad"),
    ELEMENTS(4, "ELEMENTS", "elements");

    public static final int PART_VALUE = 0;
    public static final int ALG_VALUE = 1;
    public static final int MODE_VALUE = 2;
    public static final int PAD_VALUE = 3;
    public static final int ELEMENTS_VALUE = 4;
    private static final ObjectOp[] VALUES_ARRAY;
    public static final List<ObjectOp> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ObjectOp[]{PART, ALG, MODE, PAD, ELEMENTS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ObjectOp get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectOp result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectOp getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectOp result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectOp get(int value) {
        switch (value) {
            case 0: {
                return PART;
            }
            case 1: {
                return ALG;
            }
            case 2: {
                return MODE;
            }
            case 3: {
                return PAD;
            }
            case 4: {
                return ELEMENTS;
            }
        }
        return null;
    }

    private ObjectOp(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

