/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.crySL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Operator implements Enumerator
{
    IMPLY(0, "IMPLY", "=>"),
    OR(1, "OR", "||"),
    AND(2, "AND", "&&"),
    EQUAL(3, "EQUAL", "=="),
    UNEQUAL(4, "UNEQUAL", "!="),
    LESS(5, "LESS", "<"),
    LESS_OR_EQUAL(6, "LESS_OR_EQUAL", "<="),
    GREATER_OR_EQUAL(7, "GREATER_OR_EQUAL", ">="),
    GREATER(8, "GREATER", ">"),
    PLUS(9, "PLUS", "+"),
    MINUS(10, "MINUS", "-"),
    MODULO(11, "MODULO", "%"),
    TIMES(12, "TIMES", "*"),
    DIVIDE(13, "DIVIDE", "/"),
    NOT(14, "NOT", "!"),
    IN(15, "IN", "in");

    public static final int IMPLY_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int AND_VALUE = 2;
    public static final int EQUAL_VALUE = 3;
    public static final int UNEQUAL_VALUE = 4;
    public static final int LESS_VALUE = 5;
    public static final int LESS_OR_EQUAL_VALUE = 6;
    public static final int GREATER_OR_EQUAL_VALUE = 7;
    public static final int GREATER_VALUE = 8;
    public static final int PLUS_VALUE = 9;
    public static final int MINUS_VALUE = 10;
    public static final int MODULO_VALUE = 11;
    public static final int TIMES_VALUE = 12;
    public static final int DIVIDE_VALUE = 13;
    public static final int NOT_VALUE = 14;
    public static final int IN_VALUE = 15;
    private static final Operator[] VALUES_ARRAY;
    public static final List<Operator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Operator[]{IMPLY, OR, AND, EQUAL, UNEQUAL, LESS, LESS_OR_EQUAL, GREATER_OR_EQUAL, GREATER, PLUS, MINUS, MODULO, TIMES, DIVIDE, NOT, IN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Operator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator get(int value) {
        switch (value) {
            case 0: {
                return IMPLY;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return AND;
            }
            case 3: {
                return EQUAL;
            }
            case 4: {
                return UNEQUAL;
            }
            case 5: {
                return LESS;
            }
            case 6: {
                return LESS_OR_EQUAL;
            }
            case 7: {
                return GREATER_OR_EQUAL;
            }
            case 8: {
                return GREATER;
            }
            case 9: {
                return PLUS;
            }
            case 10: {
                return MINUS;
            }
            case 11: {
                return MODULO;
            }
            case 12: {
                return TIMES;
            }
            case 13: {
                return DIVIDE;
            }
            case 14: {
                return NOT;
            }
            case 15: {
                return IN;
            }
        }
        return null;
    }

    private Operator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

