/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.crypto.pem;

import de.dentrassi.crypto.pem.AbstractReadOnlyKeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractPemKeyStore
extends AbstractReadOnlyKeyStore {
    private Map<String, Entry> entries = Collections.emptyMap();

    protected abstract Map<String, Entry> load(InputStream var1) throws IOException, NoSuchAlgorithmException, CertificateException;

    protected Optional<Entry> getEntry(String alias) {
        return Optional.of(this.entries.get(alias));
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        return this.getEntry(alias).map(Entry::getKey).orElse(null);
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.getEntry(alias).map(Entry::isKey).orElse(false);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return this.getEntry(alias).map(Entry::getCertificateChain).orElse(null);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return this.getEntry(alias).map(Entry::getCertificate).orElse(null);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return this.getEntry(alias).map(Entry::getCertificate).map(cert -> cert instanceof X509Certificate ? (X509Certificate)cert : null).map(X509Certificate::getNotBefore).orElse(null);
    }

    @Override
    public Enumeration<String> engineAliases() {
        final Iterator<String> keys = this.entries.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public String nextElement() {
                return (String)keys.next();
            }

            @Override
            public boolean hasMoreElements() {
                return keys.hasNext();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.entries.containsKey(alias);
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.getEntry(alias).map(Entry::isCertificate).orElse(null);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof Certificate)) {
            return null;
        }
        for (Map.Entry<String, Entry> entry : this.entries.entrySet()) {
            if (cert != entry.getValue().getCertificate()) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            throw new IOException("KeyStore requires input stream");
        }
        this.entries = this.load(stream);
    }

    public static final class Entry {
        private final Key key;
        private final Certificate[] certificateChain;

        public Entry() {
            this(null, null);
        }

        public Entry(Key key, Certificate[] certificateChain) {
            this.key = key;
            this.certificateChain = certificateChain != null && certificateChain.length > 0 ? certificateChain : null;
        }

        public Key getKey() {
            return this.key;
        }

        public boolean isKey() {
            return this.key != null;
        }

        public Certificate[] getCertificateChain() {
            if (this.certificateChain == null) {
                return null;
            }
            return (Certificate[])this.certificateChain.clone();
        }

        public Certificate getCertificate() {
            if (this.certificateChain == null) {
                return null;
            }
            return this.certificateChain[0];
        }

        public boolean isCertificate() {
            return this.certificateChain != null;
        }

        public Entry merge(Entry other) {
            if (other == null) {
                return this;
            }
            Key key = other.key;
            Certificate[] certificateChain = other.certificateChain;
            if (key == null) {
                key = this.key;
            }
            if (certificateChain == null) {
                certificateChain = this.certificateChain;
            }
            return new Entry(key, certificateChain);
        }
    }
}

