/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.packagedrone.utils.rpm.deps.RpmDependencyFlags;

public class SimpleDependency {
    protected static final Map<String, RpmDependencyFlags[]> OP_MAP = new HashMap<String, RpmDependencyFlags[]>();
    protected String name;
    protected String version;
    protected Set<RpmDependencyFlags> flags = new HashSet<RpmDependencyFlags>();

    public void set(String string) {
        String[] toks = string.split("\\s+");
        if (toks.length == 1) {
            this.setAll(toks[0], null, new RpmDependencyFlags[0]);
        } else if (toks.length == 3) {
            RpmDependencyFlags[] flags = OP_MAP.get(toks[1]);
            if (flags == null) {
                throw new IllegalArgumentException(String.format("Operator '%s' is unknown", toks[1]));
            }
            this.setAll(toks[0], toks[2], flags);
        } else {
            throw new IllegalArgumentException(String.format("Invalid short format: '%s'", string));
        }
    }

    private void setAll(String name, String version, RpmDependencyFlags ... flags) {
        this.name = name;
        this.version = version;
        this.flags.clear();
        if (flags != null) {
            this.flags.addAll(Arrays.asList(flags));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<RpmDependencyFlags> getFlags() {
        return this.flags;
    }

    static {
        OP_MAP.put("=", new RpmDependencyFlags[]{RpmDependencyFlags.EQUAL});
        OP_MAP.put(">=", new RpmDependencyFlags[]{RpmDependencyFlags.EQUAL, RpmDependencyFlags.GREATER});
        OP_MAP.put("<=", new RpmDependencyFlags[]{RpmDependencyFlags.EQUAL, RpmDependencyFlags.LESS});
        OP_MAP.put(">", new RpmDependencyFlags[]{RpmDependencyFlags.GREATER});
        OP_MAP.put("<", new RpmDependencyFlags[]{RpmDependencyFlags.LESS});
        OP_MAP.put("eq", new RpmDependencyFlags[]{RpmDependencyFlags.EQUAL});
        OP_MAP.put("ge", new RpmDependencyFlags[]{RpmDependencyFlags.EQUAL, RpmDependencyFlags.GREATER});
        OP_MAP.put("le", new RpmDependencyFlags[]{RpmDependencyFlags.EQUAL, RpmDependencyFlags.LESS});
        OP_MAP.put("gt", new RpmDependencyFlags[]{RpmDependencyFlags.GREATER});
        OP_MAP.put("lt", new RpmDependencyFlags[]{RpmDependencyFlags.LESS});
    }
}

