/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import de.dentrassi.rpm.builder.PackageEntry;
import de.dentrassi.rpm.builder.RulesetEvaluator;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.packager.rpm.build.BuilderContext;
import org.eclipse.packager.rpm.build.FileInformation;
import org.eclipse.packager.rpm.build.FileInformationProvider;
import org.eclipse.packager.rpm.build.PayloadEntryType;

public class MojoFileInformationProvider
implements FileInformationProvider<Object> {
    private final RulesetEvaluator rulesetEval;
    private final Consumer<String> logger;
    private final String ruleId;
    private final PackageEntry entry;
    private final Instant timestamp;

    public MojoFileInformationProvider(RulesetEvaluator rulesetEval, String ruleId, PackageEntry entry, Consumer<String> logger, Instant timestamp) {
        this.rulesetEval = Objects.requireNonNull(rulesetEval);
        this.ruleId = ruleId;
        this.entry = entry;
        this.logger = logger != null ? logger : s -> {};
        this.timestamp = timestamp;
    }

    public FileInformation provide(String targetName, Object object, PayloadEntryType type) throws IOException {
        FileInformation result = this.provideByRule(targetName, object, type);
        if (result == null) {
            throw new IllegalStateException("Unable to provide file information");
        }
        if (this.entry != null && this.entry.apply(result)) {
            this.logger.accept(String.format("local override = %s", result));
        }
        if (this.timestamp != null) {
            result.setTimestamp(this.timestamp);
        }
        return result;
    }

    private FileInformation provideByRule(String targetName, Object object, PayloadEntryType type) throws IOException {
        FileInformation result = BuilderContext.defaultProvider().provide(targetName, object, type);
        if (this.ruleId != null && !this.ruleId.isEmpty()) {
            this.logger.accept(String.format("run ruleset: '%s'", this.ruleId));
            this.rulesetEval.eval(this.ruleId, object, type, targetName, result);
        }
        this.logger.accept(String.format("fileInformation = %s", result));
        return result;
    }
}

