/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import com.google.common.base.Strings;
import com.google.common.io.CharSource;
import de.dentrassi.rpm.builder.Dependency;
import de.dentrassi.rpm.builder.ListenableBuilderContext;
import de.dentrassi.rpm.builder.Logger;
import de.dentrassi.rpm.builder.MissingDirectoryTracker;
import de.dentrassi.rpm.builder.MojoFileInformationProvider;
import de.dentrassi.rpm.builder.Naming;
import de.dentrassi.rpm.builder.PackageEntry;
import de.dentrassi.rpm.builder.Ruleset;
import de.dentrassi.rpm.builder.RulesetEvaluator;
import de.dentrassi.rpm.builder.Script;
import de.dentrassi.rpm.builder.ScriptSetter;
import de.dentrassi.rpm.builder.Signature;
import de.dentrassi.rpm.builder.SigningHelper;
import de.dentrassi.rpm.builder.SimpleDependency;
import de.dentrassi.rpm.builder.signatures.SignatureConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.packager.rpm.Architecture;
import org.eclipse.packager.rpm.HashAlgorithm;
import org.eclipse.packager.rpm.OperatingSystem;
import org.eclipse.packager.rpm.RpmBaseTag;
import org.eclipse.packager.rpm.RpmLead;
import org.eclipse.packager.rpm.RpmTag;
import org.eclipse.packager.rpm.RpmVersion;
import org.eclipse.packager.rpm.build.BuilderContext;
import org.eclipse.packager.rpm.build.BuilderOptions;
import org.eclipse.packager.rpm.build.DigestAlgorithm;
import org.eclipse.packager.rpm.build.FileInformationProvider;
import org.eclipse.packager.rpm.build.RpmBuilder;
import org.eclipse.packager.rpm.build.RpmFileNameProvider;
import org.eclipse.packager.rpm.deps.RpmDependencyFlags;
import org.eclipse.packager.rpm.signature.RsaHeaderSignatureProcessor;
import org.eclipse.packager.rpm.signature.RsaSignatureProcessor;
import org.eclipse.packager.rpm.signature.SignatureProcessor;

@Mojo(name="rpm", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class RpmMojo
extends AbstractMojo {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.version}")
    String version;
    @Parameter(property="rpm.snapshotVersion")
    String snapshotVersion;
    @Parameter(defaultValue="${project.artifactId}", property="rpm.packageName")
    String packageName;
    @Parameter(defaultValue="noarch", property="rpm.architecture")
    String architecture = "noarch";
    @Parameter(property="rpm.leadOverride.architecture")
    Architecture leadOverrideArchitecture;
    @Parameter(property="rpm.operatingSystem")
    String operatingSystem = "linux";
    @Parameter(property="rpm.leadOverride.operatingSystem")
    OperatingSystem leadOverrideOperatingSystem;
    @Parameter(property="rpm.sourcePackage")
    String sourcePackage;
    @Parameter(property="rpm.generateDefaultSourcePackage", defaultValue="true")
    boolean generateDefaultSourcePackage = true;
    @Parameter(defaultValue="0.", property="rpm.snapshotReleasePrefix")
    String snapshotReleasePrefix = "0.";
    @Parameter(property="rpm.snapshotBuildId", required=false)
    String snapshotBuildId;
    @Parameter(property="rpm.release", defaultValue="1")
    String release = "1";
    @Parameter(property="rpm.forceRelease", defaultValue="false")
    boolean forceRelease = false;
    @Parameter(property="rpm.classifier", defaultValue="rpm")
    String classifier = "rpm";
    @Parameter(property="rpm.attach", defaultValue="true")
    boolean attach = true;
    @Parameter(property="rpm.epoch")
    Integer epoch;
    @Parameter(property="rpm.summary", defaultValue="${project.name}")
    String summary;
    @Parameter(property="rpm.description", defaultValue="${project.description}")
    String description;
    @Parameter(property="rpm.group", defaultValue="Unspecified")
    String group;
    @Parameter(property="rpm.distribution")
    String distribution;
    @Parameter(property="rpm.evalHostname", defaultValue="true")
    boolean evalHostname = true;
    @Parameter(property="rpm.license")
    String license;
    @Parameter(property="rpm.vendor")
    String vendor;
    @Parameter(property="rpm.packager")
    String packager;
    @Parameter(property="rpm.prefixes")
    List<String> prefixes;
    @Parameter(property="rpm.generateIntermediateDirectories")
    List<String> generateIntermediateDirectories;
    @Parameter
    List<PackageEntry> entries = new LinkedList<PackageEntry>();
    @Parameter
    List<Ruleset> rulesets = new LinkedList<Ruleset>();
    @Parameter
    String defaultRuleset;
    private Logger logger;
    private RulesetEvaluator eval;
    @Parameter
    Script beforeInstallation;
    @Parameter
    Script afterInstallation;
    @Parameter
    Script beforeRemoval;
    @Parameter
    Script afterRemoval;
    @Parameter
    Script beforeTransaction;
    @Parameter
    Script afterTransaction;
    @Parameter(property="rpm.defaultScriptInterpreter", defaultValue="/bin/sh")
    String defaultScriptInterpreter;
    @Parameter
    List<Dependency> requires = new LinkedList<Dependency>();
    @Parameter
    List<SimpleDependency> provides = new LinkedList<SimpleDependency>();
    @Parameter
    List<SimpleDependency> conflicts = new LinkedList<SimpleDependency>();
    @Parameter
    List<SimpleDependency> obsoletes = new LinkedList<SimpleDependency>();
    @Parameter
    List<SimpleDependency> prerequisites = new LinkedList<SimpleDependency>();
    @Parameter
    List<SimpleDependency> suggests = new LinkedList<SimpleDependency>();
    @Parameter
    List<SimpleDependency> enhances = new LinkedList<SimpleDependency>();
    @Parameter
    List<SimpleDependency> supplements = new LinkedList<SimpleDependency>();
    @Parameter
    List<SimpleDependency> recommends = new LinkedList<SimpleDependency>();
    @Parameter(property="rpm.signature")
    Signature signature;
    @Parameter(property="rpm.skip", defaultValue="false")
    boolean skip = false;
    @Parameter(property="rpm.skipSigning", defaultValue="false")
    boolean skipSigning = false;
    @Parameter(property="rpm.naming")
    Naming naming;
    @Parameter(property="rpm.targetDir", defaultValue="${project.build.directory}")
    File targetDir;
    @Parameter(property="rpm.outputFileName")
    String outputFileName;
    @Parameter(property="rpm.outputFileNameProperty", defaultValue="project.build.rpm.outputFileName")
    String outputFileNameProperty = "project.build.rpm.outputFileName";
    @Parameter(property="rpm.maximumSupportedRpmVersion")
    RpmBuilder.Version maximumSupportedRpmVersion;
    @Parameter
    String signatureConfiguration;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    String outputTimestamp;
    @Parameter(defaultValue="SHA-256", property="rpm.fileDigestAlgorithm")
    String fileDigestAlgorithm;
    private Instant outputTimestampInstant;
    @Component(role=SignatureConfiguration.class)
    protected Map<String, SignatureConfiguration> signatureConfigurationProviders;

    public void setLeadOverrideArchitecture(Architecture leadOverrideArchitecture) {
        this.leadOverrideArchitecture = leadOverrideArchitecture;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public void setLeadOverrideOperatingSystem(OperatingSystem leadOverrideOperatingSystem) {
        this.leadOverrideOperatingSystem = leadOverrideOperatingSystem;
    }

    public void setSourcePackage(String sourcePackage) {
        this.sourcePackage = sourcePackage;
    }

    public void setGenerateDefaultSourcePackage(boolean generateDefaultSourcePackage) {
        this.generateDefaultSourcePackage = generateDefaultSourcePackage;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setSkipSigning(boolean skipSigning) {
        this.skipSigning = skipSigning;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setOutputFileNameProperty(String outputFileNameProperty) {
        this.outputFileNameProperty = outputFileNameProperty;
    }

    public void setMaximumSupportedRpmVersion(RpmBuilder.Version maximumSupportedRpmVersion) {
        this.maximumSupportedRpmVersion = maximumSupportedRpmVersion;
    }

    public void setMaximumSupportedRpmVersion(String maximumSupportedRpmVersion) {
        this.maximumSupportedRpmVersion = (RpmBuilder.Version)RpmBuilder.Version.fromVersionString((String)maximumSupportedRpmVersion).orElseThrow(() -> new IllegalArgumentException(String.format("Version '%s' is unknown", maximumSupportedRpmVersion)));
    }

    public void setSignatureConfiguration(String signatureConfiguration) {
        this.signatureConfiguration = signatureConfiguration;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        SignatureConfiguration provider;
        this.logger = new Logger(this.getLog());
        if (this.skip) {
            this.logger.debug("Skipping execution", new Object[0]);
            return;
        }
        this.eval = new RulesetEvaluator(this.rulesets);
        Path targetDir = this.targetDir != null ? this.targetDir.toPath() : Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        if (!Files.exists(targetDir, new LinkOption[0])) {
            try {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException ioe) {
                this.logger.debug("Unable to create target directory {}", targetDir);
                throw new MojoExecutionException("RPM build failed.", (Exception)ioe);
            }
        }
        this.outputTimestampInstant = MavenArchiver.parseBuildOutputTimestamp((String)this.outputTimestamp).orElse(null);
        if (this.outputTimestampInstant != null) {
            this.logger.info("Creating reproducible RPM at timestamp: %s", this.outputTimestampInstant);
        }
        String outputFileName = this.makeTargetFilename();
        this.project.getProperties().setProperty(this.outputFileNameProperty, outputFileName);
        Path targetFile = this.makeTargetFile(targetDir, outputFileName);
        this.logger.debug("Max supported RPM version: %s", this.maximumSupportedRpmVersion);
        this.logger.info("Writing to target to: %s", targetFile);
        this.logger.debug("Default script interpreter: %s", this.defaultScriptInterpreter);
        this.logger.debug("Default ruleset: %s", this.defaultRuleset);
        String packageName = this.makePackageName();
        RpmVersion version = this.makeVersion();
        this.logger.info("RPM base information - name: %s, version: %s, arch: %s", packageName, version, this.architecture);
        this.testLeadFlags();
        BuilderOptions options = new BuilderOptions();
        DigestAlgorithm fileDigestAlgorithm = this.evalDigestAlgorithm(this.fileDigestAlgorithm);
        this.logger.info("File Digest Algorithm: %s", fileDigestAlgorithm.getAlgorithm());
        options.setFileDigestAlgorithm(fileDigestAlgorithm);
        if (this.signatureConfiguration != null) {
            this.logger.info("Initialize with custom signature configuration: %s (%s)", this.signatureConfiguration, this.signatureConfiguration.getClass());
            provider = this.signatureConfigurationProviders.get(this.signatureConfiguration);
            if (provider == null) {
                throw new MojoExecutionException(String.format("Unable to find requested signature configuration provider '%s', have: %s", this.signatureConfiguration, this.signatureConfigurationProviders.keySet()));
            }
            provider.applyOptions(options);
        } else {
            provider = null;
        }
        try (RpmBuilder builder = new RpmBuilder(packageName, version, this.architecture, targetFile, options);){
            SignatureProcessor[] signers;
            this.logger.info("Writing target file: %s", builder.getTargetFile());
            if (this.leadOverrideArchitecture != null) {
                this.logger.info("Override RPM lead architecture: %s", this.leadOverrideArchitecture);
                builder.setLeadOverrideArchitecture(this.leadOverrideArchitecture);
            }
            if (this.leadOverrideOperatingSystem != null) {
                this.logger.info("Override RPM lead operating system: %s", this.leadOverrideOperatingSystem);
                builder.setLeadOverrideOperatingSystem(this.leadOverrideOperatingSystem);
            }
            this.fillPackageInformation(builder);
            this.fillScripts(builder);
            this.fillDependencies(builder);
            this.fillPayload(builder);
            this.customizeHeader(builder);
            if (provider != null) {
                provider.applyBuilder(builder);
            }
            if (!this.skipSigning && this.signature != null && (signers = this.makeRsaSigners(this.signature)) != null) {
                for (SignatureProcessor signer : signers) {
                    builder.addSignatureProcessor(signer);
                }
            }
            builder.build();
            this.checkVersion(builder);
            if (this.attach) {
                this.logger.info("attaching %s", this.classifier);
                if ("rpm".equals(this.project.getPackaging())) {
                    this.project.getArtifact().setFile(builder.getTargetFile().toFile());
                } else {
                    this.projectHelper.attachArtifact(this.project, "rpm", this.classifier, builder.getTargetFile().toFile());
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write RPM", (Exception)e);
        }
    }

    private DigestAlgorithm evalDigestAlgorithm(String algorithm) throws MojoFailureException {
        try {
            return DigestAlgorithm.valueOf((String)algorithm);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (DigestAlgorithm a : DigestAlgorithm.values()) {
                if (!a.getAlgorithm().equalsIgnoreCase(algorithm)) continue;
                return a;
            }
            throw new MojoFailureException(String.format("Unknown file digest algorithm: %s", algorithm));
        }
    }

    private String makeTargetFilename() {
        String outputFileName = this.outputFileName;
        if (outputFileName == null || outputFileName.isEmpty()) {
            outputFileName = this.naming.getDefaultFormat() == Naming.DefaultFormat.LEGACY ? RpmFileNameProvider.LEGACY_FILENAME_PROVIDER.getRpmFileName(this.makePackageName(), this.makeVersion(), this.architecture) : RpmFileNameProvider.DEFAULT_FILENAME_PROVIDER.getRpmFileName(this.makePackageName(), this.makeVersion(), this.architecture);
            this.logger.debug("Using generated file name - %s", outputFileName, outputFileName);
        }
        return outputFileName;
    }

    private Path makeTargetFile(Path targetDir, String outputFileName) {
        Path targetFile = targetDir.resolve(outputFileName);
        this.logger.debug("Resolved output file name - fileName: %s, fullName: %s", this.outputFileName, targetFile);
        return targetFile;
    }

    protected void checkVersion(RpmBuilder builder) throws MojoFailureException {
        RpmBuilder.Version version = builder.getRequiredRpmVersion();
        this.logger.info("Required RPM version: %s", version);
        if (this.maximumSupportedRpmVersion == null) {
            return;
        }
        if (version.compareTo((Enum)this.maximumSupportedRpmVersion) > 0) {
            throw new MojoFailureException((Object)builder.getTargetFile(), "Generated RPM file not compatible with version " + this.maximumSupportedRpmVersion, String.format("The generated RPM package would require at least version %1$s, however the build limits the supported RPM version to %2$s. Either raise the support RPM version or remove features requiring a more recent version of RPM.", version, this.maximumSupportedRpmVersion));
        }
    }

    private void testLeadFlags() {
        Optional os;
        Optional arch;
        if (this.leadOverrideArchitecture == null && !(arch = Architecture.fromAlias((String)this.architecture)).isPresent()) {
            this.logger.warn("Architecture '%s' cannot be mapped to lead information. Consider using setting 'leadOverrideArchitecture'.", this.architecture);
        }
        if (this.leadOverrideOperatingSystem == null && !(os = OperatingSystem.fromAlias((String)this.operatingSystem)).isPresent()) {
            this.logger.warn("OperatingSystem '%s' cannot be mapped to lead information. Consider using setting 'leadOverrideOperatingSystem'.", this.operatingSystem);
        }
    }

    private SignatureProcessor[] makeRsaSigners(Signature signature) throws MojoExecutionException, MojoFailureException {
        PGPPrivateKey privateKey = SigningHelper.loadKey(signature, this.logger);
        if (privateKey == null) {
            return null;
        }
        return new SignatureProcessor[]{new RsaHeaderSignatureProcessor(privateKey, HashAlgorithm.from((String)signature.getHashAlgorithm())), new RsaSignatureProcessor(privateKey, HashAlgorithm.from((String)signature.getHashAlgorithm()))};
    }

    private void fillDependencies(RpmBuilder builder) {
        this.addAllDependencies("require", this.requires, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addRequirement(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("prerequire", this.prerequisites, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addRequirement(arg_0, arg_1, arg_2), RpmMojo::validateName, flags -> flags.add(RpmDependencyFlags.PREREQ));
        this.addAllDependencies("provide", this.provides, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addProvides(arg_0, arg_1, arg_2), ((Consumer<SimpleDependency>)RpmMojo::validateName).andThen(this::validateNoVersion), null);
        this.addAllDependencies("conflict", this.conflicts, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addConflicts(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("obsolete", this.obsoletes, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addObsoletes(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("suggest", this.suggests, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addSuggests(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("enhance", this.enhances, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addEnhances(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("supplement", this.supplements, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addSupplements(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
        this.addAllDependencies("recommends", this.recommends, (arg_0, arg_1, arg_2) -> ((RpmBuilder)builder).addRecommends(arg_0, arg_1, arg_2), RpmMojo::validateName, null);
    }

    private static void validateName(SimpleDependency dep) {
        if (Strings.isNullOrEmpty((String)dep.getName())) {
            throw new IllegalStateException("'name' of dependency must be set");
        }
    }

    private void validateNoVersion(SimpleDependency dep) {
        if (!Strings.isNullOrEmpty((String)dep.getVersion())) {
            this.getLog().warn((CharSequence)String.format("Provides should not have a version: %s : %s. Use at your own risk!", dep.getName(), dep.getVersion()));
        }
    }

    private <T extends SimpleDependency> void addAllDependencies(String depName, List<T> deps, DependencyAdder adder, Consumer<T> validator, Consumer<Set<RpmDependencyFlags>> flagsCustomizer) {
        if (deps == null) {
            return;
        }
        for (SimpleDependency dep : deps) {
            validator.accept(dep);
            String name = dep.getName();
            String version = dep.getVersion();
            Set<RpmDependencyFlags> flags = dep.getFlags();
            if (flagsCustomizer != null) {
                flagsCustomizer.accept(flags);
            }
            this.logger.info("Adding dependency [%s]: name = %s, version = %s, flags = %s", depName, name, version, flags);
            adder.add(name, version, flags.toArray(new RpmDependencyFlags[0]));
        }
    }

    private void fillScripts(RpmBuilder builder) throws IOException {
        this.setScript("prein", this.beforeInstallation, (arg_0, arg_1) -> ((RpmBuilder)builder).setPreInstallationScript(arg_0, arg_1));
        this.setScript("postin", this.afterInstallation, (arg_0, arg_1) -> ((RpmBuilder)builder).setPostInstallationScript(arg_0, arg_1));
        this.setScript("prerm", this.beforeRemoval, (arg_0, arg_1) -> ((RpmBuilder)builder).setPreRemoveScript(arg_0, arg_1));
        this.setScript("postrm", this.afterRemoval, (arg_0, arg_1) -> ((RpmBuilder)builder).setPostRemoveScript(arg_0, arg_1));
        this.setScript("pretrans", this.beforeTransaction, (arg_0, arg_1) -> ((RpmBuilder)builder).setPreTransactionScript(arg_0, arg_1));
        this.setScript("posttrans", this.afterTransaction, (arg_0, arg_1) -> ((RpmBuilder)builder).setPostTransactionScript(arg_0, arg_1));
    }

    private void setScript(String scriptName, Script script, ScriptSetter setter) throws IOException {
        if (script == null) {
            return;
        }
        String scriptContent = script.makeScriptContent();
        if (Strings.isNullOrEmpty((String)scriptContent)) {
            return;
        }
        String interpreter = script.getInterpreter();
        this.logger.debug("[script %s:]: explicit interpreter: %s", scriptName, interpreter);
        if (Strings.isNullOrEmpty((String)interpreter)) {
            interpreter = this.detectInterpreter(scriptContent);
            this.logger.debug("[script %s:]: detected interpreter: %s", scriptName, interpreter);
        }
        if (Strings.isNullOrEmpty((String)interpreter)) {
            interpreter = this.defaultScriptInterpreter;
            this.logger.debug("[script %s:]: default interpreter: %s", scriptName, interpreter);
        }
        this.logger.info("[script %s]: Using script interpreter: %s", scriptName, interpreter);
        this.logger.debug("[script %s]: %s", scriptName, scriptContent);
        setter.accept(interpreter, scriptContent);
    }

    private String detectInterpreter(String scriptContent) throws IOException {
        String firstLine = CharSource.wrap((CharSequence)scriptContent).readFirstLine();
        if (Strings.isNullOrEmpty((String)firstLine)) {
            return null;
        }
        if (firstLine.startsWith("#!") && firstLine.length() > 2) {
            return firstLine.substring(2);
        }
        return null;
    }

    protected void fillPayload(RpmBuilder builder) throws MojoFailureException, IOException {
        if (this.entries == null) {
            return;
        }
        ListenableBuilderContext ctx = new ListenableBuilderContext(builder.newContext());
        MissingDirectoryTracker missingDirectoryTracker = new MissingDirectoryTracker(this.generateIntermediateDirectories);
        ctx.registerListener(missingDirectoryTracker);
        this.logger.debug("Building payload:", new Object[0]);
        for (PackageEntry entry : this.entries) {
            if (entry.getSkip().booleanValue()) continue;
            try {
                entry.validate();
            }
            catch (IllegalStateException e) {
                throw new MojoFailureException(e.getMessage());
            }
            this.fillFromEntry(ctx, entry);
        }
        ctx.removeListener(missingDirectoryTracker);
        if (!this.generateIntermediateDirectories.isEmpty()) {
            missingDirectoryTracker.addMissingIntermediateDirectoriesToContext(ctx);
        }
    }

    private void customizeHeader(RpmBuilder builder) {
        builder.setHeaderCustomizer(rpmTagHeader -> {
            if (this.prefixes != null && !this.prefixes.isEmpty()) {
                this.logger.debug("Building relocatable package: {}", this.prefixes);
                rpmTagHeader.putStringArray((RpmBaseTag)RpmTag.PREFIXES, this.prefixes.toArray(new String[0]));
            }
            if (this.outputTimestampInstant != null) {
                this.logger.debug("Overriding build time: {}", this.outputTimestampInstant);
                rpmTagHeader.putInt((RpmBaseTag)RpmTag.BUILDTIME, new int[]{(int)(this.outputTimestampInstant.toEpochMilli() / 1000L)});
            }
        });
    }

    private void fillFromEntry(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("  %s:", entry.getName());
        if (entry.getDirectory() != null && entry.getDirectory().booleanValue()) {
            this.fillFromEntryDirectory(ctx, entry);
        } else if (entry.getFile() != null) {
            this.fillFromEntryFile(ctx, entry);
        } else if (entry.getLinkTo() != null) {
            this.fillFromEntryLinkTo(ctx, entry);
        } else if (entry.getCollect() != null) {
            this.fillFromEntryCollect(ctx, entry);
        } else if (Boolean.TRUE.equals(entry.getGhost())) {
            this.fillFromEntryGhost(ctx, entry);
        }
    }

    private void fillFromEntryDirectory(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("    as directory:", new Object[0]);
        ctx.addDirectory(entry.getName(), (FileInformationProvider)this.makeProvider(entry, "      - "));
    }

    private void fillFromEntryFile(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("    as file:", new Object[0]);
        Path source = entry.getFile().toPath().toAbsolutePath();
        this.logger.debug("      - source: %s", source);
        ctx.addFile(entry.getName(), source, (FileInformationProvider)this.makeProvider(entry, "      - "));
    }

    private void fillFromEntryGhost(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("    as ghost:", new Object[0]);
        ctx.addFile(entry.getName(), ByteBuffer.allocate(0), (FileInformationProvider)this.makeProvider(entry, "      - "));
    }

    private void fillFromEntryLinkTo(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("    as symbolic link:", new Object[0]);
        this.logger.debug("      - linkTo: %s", entry.getLinkTo());
        ctx.addSymbolicLink(entry.getName(), entry.getLinkTo(), (FileInformationProvider)this.makeProvider(entry, "      - "));
    }

    private void fillFromEntryCollect(BuilderContext ctx, PackageEntry entry) throws IOException {
        this.logger.debug("    as collector:", new Object[0]);
        PackageEntry.Collector collector = entry.getCollect();
        this.logger.debug("      - configuration: %s", collector);
        String padding = "          ";
        Path from = collector.getFrom().toPath();
        String targetPrefix = entry.getName().endsWith("/") ? entry.getName() : entry.getName() + "/";
        this.logger.debug("      - files:", new Object[0]);
        MojoFileInformationProvider provider = this.makeProvider(entry, "            - ");
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(from.toFile());
        scanner.setCaseSensitive(true);
        scanner.setFollowSymlinks(true);
        scanner.setIncludes(collector.getIncludes());
        scanner.setExcludes(collector.getExcludes());
        scanner.scan();
        if (collector.isDirectories()) {
            Object[] includedDirectories = scanner.getIncludedDirectories();
            Arrays.sort(includedDirectories);
            for (Object directory : includedDirectories) {
                Path dir = from.resolve((String)directory);
                if (dir.equals(from)) continue;
                this.logger.debug("%s%s (dir)", "          ", dir);
                Path relative = from.relativize(dir);
                String targetName = this.makeUnix(targetPrefix + relative);
                this.logger.debug("%s  - target: %s", "          ", targetName);
                ctx.addDirectory(targetName, (FileInformationProvider)provider);
            }
        }
        Object[] includedFiles = scanner.getIncludedFiles();
        Arrays.sort(includedFiles);
        for (Object relative : includedFiles) {
            Path file = from.resolve((String)relative);
            String targetName = this.makeUnix(targetPrefix + (String)relative);
            if (Files.isSymbolicLink(file)) {
                this.logger.debug("%s%s (symlink)", "          ", file);
                if (collector.isSymbolicLinks()) {
                    Path sym = Files.readSymbolicLink(file);
                    this.logger.debug("%s%s (symlink)", "          ", file);
                    this.logger.debug("%s  - target: %s", "          ", targetName);
                    this.logger.debug("%s  - linkTo: %s", "          ", sym.toString());
                    ctx.addSymbolicLink(targetName, sym.toString(), (FileInformationProvider)provider);
                    continue;
                }
                this.logger.debug("%s%s (symlink) - ignoring symbolic links", "          ", file);
                continue;
            }
            this.logger.debug("%s%s (file)", "          ", file);
            this.logger.debug("%s  - target: %s", "          ", targetName);
            ctx.addFile(targetName, file, (FileInformationProvider)provider);
        }
    }

    protected String makeUnix(String path) {
        return path.replace("\\", "/");
    }

    private MojoFileInformationProvider makeProvider(PackageEntry entry, String padding) {
        String ruleset = this.defaultRuleset;
        if (entry.getRuleset() != null && !entry.getRuleset().isEmpty()) {
            this.logger.debug("Using specified ruleset: '%s'", entry.getRuleset());
            ruleset = entry.getRuleset();
        } else if (this.defaultRuleset != null && !this.defaultRuleset.isEmpty()) {
            this.logger.debug("Using default ruleset: '%s'", this.defaultRuleset);
        }
        return new MojoFileInformationProvider(this.eval, ruleset, entry, l -> this.logger.debug("%s%s", padding, l), this.outputTimestampInstant);
    }

    private String makePackageName() {
        Naming.Case nameCase;
        if (this.naming == null) {
            nameCase = Naming.Case.UNMODIFIED;
            if (!this.packageName.toLowerCase().equals(this.packageName)) {
                this.getLog().warn((CharSequence)"Since version 0.9.0 of the RPM builder mojo the default behavior of forcing a lower case package name was removed. This package name seems to contain non-lowercase characters. It is possible to restore the previous behavior by setting the 'case' value in the 'naming' element.");
            }
        } else {
            nameCase = this.naming.getCase();
        }
        switch (nameCase) {
            case LOWERCASE: {
                return this.packageName.trim().toLowerCase();
            }
        }
        return this.packageName.trim();
    }

    private RpmVersion makeVersion() {
        if (!this.forceRelease && this.isSnapshotVersion()) {
            if (this.snapshotVersion != null && !this.snapshotVersion.isEmpty()) {
                this.logger.info("Building with SNAPSHOT version from <snapshotVersion> parameter: %s", this.snapshotVersion);
                return new RpmVersion(this.epoch, this.snapshotVersion, this.makeSnapshotReleaseString());
            }
            String baseVersion = this.project.getVersion().substring(0, this.project.getVersion().length() - SNAPSHOT_SUFFIX.length());
            this.logger.info("Building with SNAPSHOT version from project: %s", baseVersion);
            return new RpmVersion(this.epoch, baseVersion, this.makeSnapshotReleaseString());
        }
        return new RpmVersion(this.epoch, this.version, this.release);
    }

    private boolean isSnapshotVersion() {
        return this.project.getVersion().endsWith(SNAPSHOT_SUFFIX);
    }

    private String makeSnapshotReleaseString() {
        if (this.snapshotBuildId == null || this.snapshotBuildId.isEmpty()) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm", Locale.ROOT);
            return this.snapshotReleasePrefix + formatter.format(Optional.ofNullable(this.outputTimestampInstant).orElse(Instant.now()).atOffset(ZoneOffset.UTC));
        }
        return this.snapshotReleasePrefix + this.snapshotBuildId;
    }

    protected void fillPackageInformation(RpmBuilder builder) {
        RpmBuilder.PackageInformation pinfo = builder.getInformation();
        if ((this.sourcePackage == null || this.sourcePackage.isEmpty()) && this.generateDefaultSourcePackage) {
            String sourcePackage = this.generateDefaultSourcePackageName();
            this.logger.debug("Using generated source package name of '%s'. You can disable this by setting 'generateDefaultSourcePackage' to false.", sourcePackage);
            this.sourcePackage = sourcePackage;
        }
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setDescription(arg_0), this.description, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setSummary(arg_0), this.summary, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setGroup(arg_0), this.group, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setDistribution(arg_0), this.distribution, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setOperatingSystem(arg_0), this.operatingSystem, new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setSourcePackage(arg_0), this.sourcePackage, new StringSupplier[0]);
        if (this.evalHostname) {
            RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setBuildHost(arg_0), this.makeHostname(), new StringSupplier[0]);
        }
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setUrl(arg_0), this.project.getUrl(), new StringSupplier[0]);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setVendor(arg_0), this.vendor, this::makeVendor);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setPackager(arg_0), this.packager, this::makePackager);
        RpmMojo.ifSet(arg_0 -> ((RpmBuilder.PackageInformation)pinfo).setLicense(arg_0), this.license, this::makeLicense);
    }

    private String generateDefaultSourcePackageName() {
        return RpmLead.toLeadName((String)this.makePackageName(), (RpmVersion)this.makeVersion()) + ".src.rpm";
    }

    private String makeVendor() {
        if (this.project.getOrganization() != null) {
            return this.project.getOrganization().getName();
        }
        return null;
    }

    private String makePackager() {
        if (this.project.getOrganization() == null) {
            return null;
        }
        String org = this.project.getOrganization().getName();
        String url = this.project.getOrganization().getUrl();
        if (org == null || url == null || org.isEmpty() || url.isEmpty()) {
            return null;
        }
        return String.format("%s <%s>", org, url);
    }

    private String makeLicense() {
        return this.project.getLicenses().stream().map(License::getName).collect(Collectors.joining(", "));
    }

    private String makeHostname() {
        String hostname;
        try {
            hostname = Files.readAllLines(Paths.get("/etc/hostname", new String[0]), StandardCharsets.US_ASCII).stream().findFirst().orElse(null);
            if (hostname != null && !hostname.isEmpty()) {
                this.logger.debug("Hostname: from /etc/hostname -> '%s'", hostname);
                return hostname;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        hostname = System.getenv("COMPUTERNAME");
        if (hostname != null && !hostname.isEmpty()) {
            this.logger.debug("Hostname: from COMPUTERNAME -> '%s'", hostname);
            return hostname.toLowerCase();
        }
        hostname = System.getenv("hostname");
        if (hostname != null && !hostname.isEmpty()) {
            this.logger.debug("Hostname: from hostname -> '%s'", hostname);
            return hostname;
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            this.logger.debug("Hostname: from lookup -> '%s'", hostname);
            return hostname;
        }
        catch (UnknownHostException e) {
            this.logger.debug("Hostname: Falling back to 'localhost'", new Object[0]);
            return "localhost";
        }
    }

    private static void ifSet(Consumer<String> setter, String value, StringSupplier ... suppliers) {
        if (value != null && !value.isEmpty()) {
            setter.accept(value);
            return;
        }
        for (StringSupplier sup : suppliers) {
            String v = (String)sup.get();
            if (v == null || v.isEmpty()) continue;
            setter.accept(v);
            return;
        }
    }

    @FunctionalInterface
    private static interface DependencyAdder {
        public void add(String var1, String var2, RpmDependencyFlags[] var3);
    }

    private static interface StringSupplier
    extends Supplier<String> {
    }
}

