/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import de.dentrassi.rpm.builder.MojoFileInformationProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.packager.rpm.build.BuilderContext;
import org.eclipse.packager.rpm.build.FileInformationProvider;

public class MissingDirectoryGeneratorInterceptor
implements BuilderContext {
    private final BuilderContext builderContext;
    private final List<String> baseDirectories;
    private final Set<String> explicitAddedDirectories;
    private final Set<String> generatedDirectories;

    public MissingDirectoryGeneratorInterceptor(BuilderContext builderContext, List<String> baseDirectories) {
        this.builderContext = builderContext;
        this.baseDirectories = baseDirectories;
        this.explicitAddedDirectories = new HashSet<String>();
        this.generatedDirectories = new HashSet<String>();
    }

    public void setDefaultInformationProvider(FileInformationProvider<Object> provider) {
        this.builderContext.setDefaultInformationProvider(provider);
    }

    public FileInformationProvider<Object> getDefaultInformationProvider() {
        return this.builderContext.getDefaultInformationProvider();
    }

    public void addFile(String targetName, Path source, FileInformationProvider<? super Path> provider) throws IOException {
        this.addMissingDirectoriesFromPath(targetName, provider);
        this.builderContext.addFile(targetName, source, provider);
    }

    public void addFile(String targetName, InputStream source, FileInformationProvider<Object> provider) throws IOException {
        this.addMissingDirectoriesFromPath(targetName, provider);
        this.builderContext.addFile(targetName, source, provider);
    }

    public void addFile(String targetName, ByteBuffer source, FileInformationProvider<Object> provider) throws IOException {
        this.addMissingDirectoriesFromPath(targetName, provider);
        this.builderContext.addFile(targetName, source, provider);
    }

    public void addDirectory(String targetName, FileInformationProvider<? super BuilderContext.Directory> provider) throws IOException {
        this.addMissingDirectoriesFromPath(targetName, provider);
        this.builderContext.addDirectory(targetName, provider);
        this.explicitAddedDirectories.add(targetName);
    }

    public void addSymbolicLink(String targetName, String linkTo, FileInformationProvider<? super BuilderContext.SymbolicLink> provider) throws IOException {
        this.addMissingDirectoriesFromPath(targetName, provider);
        this.builderContext.addSymbolicLink(targetName, linkTo, provider);
    }

    private void addMissingDirectoriesFromPath(String targetName, FileInformationProvider<?> provider) throws IOException {
        if (provider instanceof MojoFileInformationProvider) {
            List<String> intermediateDirectories;
            MojoFileInformationProvider mojoProvider = (MojoFileInformationProvider)provider;
            if (this.containsCollectEntry(mojoProvider)) {
                targetName = mojoProvider.getEntry().getName();
                intermediateDirectories = this.getIntermediateDirectoriesIncludingTarget(targetName);
            } else {
                intermediateDirectories = this.getIntermediateDirectories(targetName);
            }
            for (String intermediateDirectory : intermediateDirectories) {
                this.addIfIsMissingDirectory(intermediateDirectory, mojoProvider);
            }
        }
    }

    private void addIfIsMissingDirectory(String intermediateDirectory, MojoFileInformationProvider mojoProvider) throws IOException {
        if (this.startsPathWithPrefix(intermediateDirectory) && !this.explicitAddedDirectories.contains(intermediateDirectory) && !this.generatedDirectories.contains(intermediateDirectory)) {
            this.builderContext.addDirectory(intermediateDirectory, (FileInformationProvider)new MojoFileInformationProvider(mojoProvider.getRulesetEval(), mojoProvider.getRuleId(), null, mojoProvider.getLogger(), mojoProvider.getTimestamp()));
            this.generatedDirectories.add(intermediateDirectory);
        }
    }

    private boolean containsCollectEntry(MojoFileInformationProvider mojoProvider) {
        return mojoProvider.getEntry().getCollect() != null;
    }

    private boolean startsPathWithPrefix(String directory) {
        return this.baseDirectories.stream().anyMatch(directory::startsWith);
    }

    private List<String> getIntermediateDirectories(String targetName) {
        ArrayList<String> intermediateDirectories = new ArrayList<String>();
        Path path = Paths.get(targetName, new String[0]);
        for (int i = 1; i < path.getNameCount(); ++i) {
            Path subPath = path.subpath(0, i);
            intermediateDirectories.add("/" + subPath.toString().replace(File.separatorChar, '/'));
        }
        return intermediateDirectories;
    }

    private List<String> getIntermediateDirectoriesIncludingTarget(String targetName) {
        List<String> intermediateDirectories = this.getIntermediateDirectories(targetName);
        intermediateDirectories.add(targetName);
        return intermediateDirectories;
    }
}

