/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import de.dentrassi.rpm.builder.Rule;
import de.dentrassi.rpm.builder.Ruleset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.packager.rpm.build.FileInformation;
import org.eclipse.packager.rpm.build.PayloadEntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesetEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(RulesetEvaluator.class);
    private final Map<String, RulesetInstance> rulesets = new LinkedHashMap<String, RulesetInstance>();

    public RulesetEvaluator(Collection<Ruleset> rulesets) {
        this(null, rulesets);
    }

    public RulesetEvaluator(RulesetEvaluator parent, Collection<Ruleset> rulesets) {
        for (Ruleset set : rulesets) {
            this.rulesets.put(set.getId(), this.convert(set));
        }
    }

    private RulesetInstance convert(Ruleset set) {
        set.validate();
        return new RulesetInstance(set.getId(), set.getRules(), set.getDefaultRuleset());
    }

    public void eval(String ruleId, Object object, PayloadEntryType type, String targetName, FileInformation info) {
        RulesetInstance ruleset = this.rulesets.get(ruleId);
        if (ruleset == null) {
            throw new IllegalStateException(String.format("Unknown rule: '%s'", ruleId));
        }
        ruleset.eval(object, type, targetName, info);
    }

    private class RulesetInstance {
        private final String id;
        private final List<Rule> rules;
        private final String parentRuleset;

        public RulesetInstance(String id, List<Rule> rules, String parentRuleset) {
            this.id = id;
            this.rules = rules;
            this.parentRuleset = parentRuleset;
        }

        private void eval(Object object, PayloadEntryType type, String targetName, FileInformation info, Set<String> knownSets) {
            if (knownSets.contains(this.id)) {
                throw new IllegalStateException(String.format("Recursive calling of rulesets is not allowed- current: %s, previous: %s", this.id, String.join((CharSequence)", ", knownSets)));
            }
            knownSets.add(this.id);
            for (Rule rule : this.rules) {
                logger.debug("Testing rule {}", (Object)rule);
                if (!rule.matches(object, type, targetName)) continue;
                logger.debug("  Rule matches. Applying information ...");
                if (rule.apply(info)) {
                    logger.debug("    Information: {}", (Object)info);
                }
                if (!rule.isLast()) continue;
                logger.debug("  Last rule");
                return;
            }
            if (this.parentRuleset != null && !this.parentRuleset.isEmpty()) {
                logger.debug("Running parent ruleset: '{}'", (Object)this.parentRuleset);
                RulesetEvaluator.this.eval(this.parentRuleset, object, type, targetName, info);
            }
        }

        public void eval(Object object, PayloadEntryType type, String targetName, FileInformation info) {
            this.eval(object, type, targetName, info, new LinkedHashSet<String>());
        }
    }
}

