/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import de.dentrassi.rpm.builder.Logger;
import de.dentrassi.rpm.builder.Signature;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.eclipse.packager.security.pgp.PgpHelper;

public final class SigningHelper {
    private SigningHelper() {
    }

    public static PGPPrivateKey loadKey(Signature signature, Logger logger) throws MojoFailureException, MojoExecutionException {
        PGPPrivateKey pGPPrivateKey;
        block14: {
            if (signature == null) {
                return null;
            }
            if (signature.isSkip()) {
                return null;
            }
            if (signature.getKeyId() == null || signature.getKeyId().isEmpty()) {
                throw new MojoFailureException((Object)signature, "'keyId' parameter not set", "Signing requires the 'keyId' to the user id of the GPG key to use.");
            }
            if (signature.getKeyringFile() == null) {
                throw new MojoFailureException((Object)signature, "'keyringFile' parameter not set", "Signing requires the 'keyringFile' to be set to a valid GPG keyring file, containing the secret keys.");
            }
            if (signature.getPassphrase() == null) {
                throw new MojoFailureException((Object)signature, "'passphrase' parameter not set", "Signing requires the 'passphrase' parameter to be set.");
            }
            InputStream input = Files.newInputStream(signature.getKeyringFile().toPath(), new OpenOption[0]);
            try {
                PGPPrivateKey privateKey = PgpHelper.loadPrivateKey((InputStream)input, (String)signature.getKeyId(), (String)signature.getPassphrase());
                if (privateKey == null) {
                    throw new MojoFailureException(String.format("Unable to load GPG key '%s' from '%s'", signature.getKeyId(), signature.getKeyringFile()));
                }
                logger.info("Signing RPM - keyId: %016x", privateKey.getKeyID());
                pGPPrivateKey = privateKey;
                if (input == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | PGPException e) {
                    throw new MojoExecutionException("Failed to load private key for signing", (Exception)e);
                }
            }
            input.close();
        }
        return pGPPrivateKey;
    }
}

