/*
 * Decompiled with CFR 0.152.
 */
package org.dummycreator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionCache {
    private final Map<Class<?>, List<Method>> methodCache = new HashMap();
    private final Map<Class<?>, List<Constructor<?>>> constructorCache = new HashMap();
    private final Map<Class<?>, Constructor<?>> preferedConstructors = new HashMap();

    public List<Constructor<?>> getConstructorCache(Class<?> clazz) {
        return this.constructorCache.containsKey(clazz) ? this.constructorCache.get(clazz) : null;
    }

    public List<Method> getMethodCache(Class<?> clazz) {
        return this.methodCache.containsKey(clazz) ? this.methodCache.get(clazz) : null;
    }

    public void add(Class<?> clazz, Method ... setter) {
        List<Method> setters = this.methodCache.get(clazz);
        if (setters == null) {
            setters = new ArrayList<Method>();
        }
        this.methodCache.put(clazz, setters);
        setters.addAll(Arrays.asList(setter));
    }

    public void add(Class<?> clazz, Constructor<?> ... cons) {
        List<Constructor<?>> cs = this.constructorCache.get(clazz);
        if (cs == null) {
            cs = new ArrayList();
        }
        this.constructorCache.put(clazz, cs);
        cs.addAll(Arrays.asList(cons));
    }

    public Constructor<?> getPreferedConstructor(Class<?> clazz) {
        return this.preferedConstructors.get(clazz);
    }

    public void setPreferedConstructor(Class<?> clazz, Constructor<?> cons) {
        this.preferedConstructors.put(clazz, cons);
    }
}

