/*
 * Decompiled with CFR 0.152.
 */
package org.dummycreator.dummyfactories;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codemonkey.javareflection.FieldUtils;
import org.codemonkey.javareflection.FieldWrapper;
import org.dummycreator.ClassBindings;
import org.dummycreator.ClassUsageInfo;
import org.dummycreator.RandomCreator;
import org.dummycreator.ReflectionCache;
import org.dummycreator.dummyfactories.ConstructorBasedFactory;
import org.dummycreator.dummyfactories.DummyFactory;
import org.dummycreator.dummyfactories.RandomArrayFactory;
import org.dummycreator.dummyfactories.RandomEnumFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBasedFactory<T>
extends DummyFactory<T> {
    private static final Logger logger = Logger.getLogger(ClassBasedFactory.class);
    private final Class<T> clazz;
    private static final ReflectionCache constructorCache = new ReflectionCache();

    public ClassBasedFactory(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public T createDummy(Type[] nextGenericsMetaData, Map<String, ClassUsageInfo<?>> knownInstances, ClassBindings classBindings, List<Exception> exceptions) {
        String typeMarker = ClassBasedFactory.createTypeMarker(this.clazz, nextGenericsMetaData);
        if (knownInstances.get(typeMarker) == null || !knownInstances.get(typeMarker).isPopulated()) {
            T ret = this.create(nextGenericsMetaData, knownInstances, classBindings, exceptions);
            if (ret != null) {
                return ret;
            }
            logger.error((Object)"tried but failed to produce dummy object...");
            if (!exceptions.isEmpty()) {
                logger.error((Object)"errors logged:");
                for (Exception e : exceptions) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw new IllegalArgumentException(String.format("Could not instantiate object for type [%s], is it abstract and missing a binding?", this.clazz));
        }
        return (T)knownInstances.get(typeMarker).getInstance();
    }

    private T create(Type[] genericMetaData, Map<String, ClassUsageInfo<?>> knownInstances, ClassBindings classBindings, List<Exception> exceptions) {
        T ret = null;
        DummyFactory<T> factory = classBindings.find(this.clazz);
        if (factory != null) {
            ret = factory.createDummy(genericMetaData, knownInstances, classBindings, exceptions);
        }
        if (ret == null && this.clazz.isArray()) {
            ret = new RandomArrayFactory<T>(this.clazz).createDummy(genericMetaData, knownInstances, classBindings, exceptions);
        }
        if (ret == null) {
            Constructor<?> preferedConstructor;
            ClassUsageInfo usedInfo = new ClassUsageInfo();
            usedInfo.setInstance(ret);
            if (!this.isKnownLoopSafeType(this.clazz)) {
                knownInstances.put(ClassBasedFactory.createTypeMarker(this.clazz, genericMetaData), usedInfo);
            }
            if (this.clazz.isEnum()) {
                return (T)new RandomEnumFactory<T>(this.clazz).createDummy(genericMetaData, (Map)knownInstances, classBindings, (List)exceptions);
            }
            List<Constructor<?>> cachedConstructors = constructorCache.getConstructorCache(this.clazz);
            if (cachedConstructors == null) {
                cachedConstructors = new ArrayList();
                Constructor<?>[] foundConstructors = this.clazz.getConstructors();
                Arrays.sort(foundConstructors, new Comparator<Constructor<?>>(){

                    @Override
                    public int compare(Constructor<?> o1, Constructor<?> o2) {
                        int num_o2;
                        int num_o1 = o1.getParameterTypes().length;
                        return num_o1 < (num_o2 = o2.getParameterTypes().length) ? -1 : (num_o1 == num_o2 ? 0 : 1);
                    }
                });
                cachedConstructors.addAll(Arrays.asList(foundConstructors));
                constructorCache.add(this.clazz, cachedConstructors.toArray(new Constructor[0]));
            }
            if ((preferedConstructor = constructorCache.getPreferedConstructor(this.clazz)) != null) {
                ret = (T)new ConstructorBasedFactory(preferedConstructor).createDummy(genericMetaData, knownInstances, classBindings, exceptions);
            }
            if (ret == null) {
                for (Constructor<?> co : cachedConstructors) {
                    ret = (T)new ConstructorBasedFactory(co).createDummy(genericMetaData, knownInstances, classBindings, exceptions);
                    if (ret == null) continue;
                    constructorCache.setPreferedConstructor(this.clazz, co);
                    break;
                }
            }
            if (ret != null) {
                usedInfo.setInstance(ret);
                usedInfo.setPopulated(true);
                this.populateObject(ret, genericMetaData, knownInstances, classBindings, exceptions);
            }
        }
        return ret;
    }

    protected static String createTypeMarker(Class<?> clazz, Type[] genericMetaData) {
        return "|" + clazz.getName() + "|" + ClassBasedFactory.createTypeMarker(genericMetaData);
    }

    private static String createTypeMarker(Type[] genericMetaData) {
        String typeMarker = "";
        if (genericMetaData != null) {
            if (genericMetaData.length == 1) {
                Type nextGenericMetaData = genericMetaData[0];
                if (nextGenericMetaData instanceof Class) {
                    typeMarker = typeMarker + ((Class)nextGenericMetaData).getName() + "|";
                } else {
                    typeMarker = typeMarker + ((Class)((ParameterizedType)nextGenericMetaData).getRawType()).getName() + "|";
                    typeMarker = typeMarker + ClassBasedFactory.createTypeMarker(((ParameterizedType)nextGenericMetaData).getActualTypeArguments());
                }
            } else {
                for (Type type : genericMetaData) {
                    typeMarker = typeMarker + ClassBasedFactory.createTypeMarker(new Type[]{type});
                }
            }
        }
        return typeMarker;
    }

    private boolean isKnownLoopSafeType(Class<T> clazz) {
        ArrayList<Class<String>> safeClasses = new ArrayList<Class<String>>();
        safeClasses.add(Integer.class);
        safeClasses.add(Long.class);
        safeClasses.add(Float.class);
        safeClasses.add(Boolean.class);
        safeClasses.add(Character.class);
        safeClasses.add(Byte.class);
        safeClasses.add(Short.class);
        safeClasses.add(Double.class);
        safeClasses.add(String.class);
        return safeClasses.contains(clazz);
    }

    private void populateObject(T subject, Type[] genericMetaData, Map<String, ClassUsageInfo<?>> knownInstances, ClassBindings classBindings, List<Exception> exceptions) {
        if (subject instanceof Collection) {
            this.populateCollection((Collection)subject, genericMetaData, knownInstances, classBindings, exceptions);
        } else if (subject instanceof Map) {
            this.populateMap((Map)subject, genericMetaData, knownInstances, classBindings, exceptions);
        } else {
            for (Method setter : this.discoverSetters(subject.getClass())) {
                ClassBasedFactory factory = new ClassBasedFactory(setter.getParameterTypes()[0]);
                Type genericParameterType = setter.getGenericParameterTypes()[0];
                boolean isRawClassItself = genericParameterType instanceof Class;
                Type[] nextGenericsMetaData = isRawClassItself ? null : ((ParameterizedType)genericParameterType).getActualTypeArguments();
                Object parameter = factory.createDummy(nextGenericsMetaData, knownInstances, classBindings, exceptions);
                try {
                    setter.invoke(subject, parameter);
                }
                catch (Exception e) {
                    logger.error((Object)("error calling setter method [" + setter.getName() + "]"), (Throwable)e);
                }
            }
        }
    }

    private void populateCollection(Collection<Object> subject, Type[] genericMetaData, Map<String, ClassUsageInfo<?>> knownInstances, ClassBindings classBindings, List<Exception> exceptions) {
        for (int i = 0; i < RandomCreator.getInstance().getRandomInt(2) + 2; ++i) {
            ClassAndGenericMetaData<?> classInfo = this.extractClassInfo(subject.getClass(), genericMetaData, 0);
            ClassBasedFactory factory = new ClassBasedFactory(classInfo.getClazz());
            Object dummyObject = factory.createDummy(classInfo.getGenericMetaData(), knownInstances, classBindings, exceptions);
            subject.add(dummyObject);
        }
    }

    private void populateMap(Map<Object, Object> subject, Type[] genericMetaData, Map<String, ClassUsageInfo<?>> knownInstances, ClassBindings classBindings, List<Exception> exceptions) {
        for (int i = 0; i < RandomCreator.getInstance().getRandomInt(2) + 2; ++i) {
            ClassAndGenericMetaData<?> keyClassInfo = this.extractClassInfo(subject.getClass(), genericMetaData, 0);
            ClassAndGenericMetaData<?> valueClassInfo = this.extractClassInfo(subject.getClass(), genericMetaData, 1);
            ClassBasedFactory dummyKeyFactory = new ClassBasedFactory(keyClassInfo.getClazz());
            ClassBasedFactory dummyValueFactory = new ClassBasedFactory(valueClassInfo.getClazz());
            Object dummyKey = dummyKeyFactory.createDummy(keyClassInfo.getGenericMetaData(), knownInstances, classBindings, exceptions);
            Object dummyValue = dummyValueFactory.createDummy(valueClassInfo.getGenericMetaData(), knownInstances, classBindings, exceptions);
            subject.put(dummyKey, dummyValue);
        }
    }

    private ClassAndGenericMetaData<?> extractClassInfo(Class<?> clazz, Type[] genericMetaData, int index) {
        ClassAndGenericMetaData<String> keyClassInfo = new ClassAndGenericMetaData<String>();
        Type[] genericTypes = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        if (genericTypes.length > index && genericTypes[index] instanceof Class) {
            keyClassInfo.setClazz((Class)genericTypes[index]);
        } else if (genericMetaData != null) {
            Class keyClassFromGenerics;
            if (genericMetaData[index] instanceof Class) {
                keyClassFromGenerics = (Class)genericMetaData[index];
            } else {
                keyClassFromGenerics = (Class)((ParameterizedType)genericMetaData[index]).getRawType();
                keyClassInfo.setGenericMetaData(((ParameterizedType)genericMetaData[index]).getActualTypeArguments());
            }
            keyClassInfo.setClazz(keyClassFromGenerics);
        } else {
            keyClassInfo.setClazz(String.class);
        }
        return keyClassInfo;
    }

    private List<Method> discoverSetters(Class<?> clazz) {
        List<Method> setters = constructorCache.getMethodCache(clazz);
        if (setters == null) {
            setters = new ArrayList<Method>();
            Map fields = FieldUtils.collectFields(clazz, Object.class, EnumSet.allOf(FieldUtils.Visibility.class), EnumSet.of(FieldUtils.BeanRestriction.YES_SETTER));
            for (List fieldWrappers : fields.values()) {
                for (FieldWrapper fieldWrapper : fieldWrappers) {
                    setters.add(fieldWrapper.getSetter());
                }
            }
            constructorCache.add(clazz, setters.toArray(new Method[0]));
        }
        return setters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassAndGenericMetaData<T> {
        private Class<T> clazz;
        private Type[] genericMetaData;

        private ClassAndGenericMetaData() {
        }

        public Class<T> getClazz() {
            return this.clazz;
        }

        public void setClazz(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Type[] getGenericMetaData() {
            return this.genericMetaData;
        }

        public void setGenericMetaData(Type[] genericMetaData) {
            this.genericMetaData = genericMetaData;
        }
    }
}

