/*
 * Decompiled with CFR 0.152.
 */
package org.dummycreator.dummyfactories;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dummycreator.ClassBindings;
import org.dummycreator.ClassUsageInfo;
import org.dummycreator.dummyfactories.ClassBasedFactory;
import org.dummycreator.dummyfactories.DummyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodBasedFactory<T>
extends DummyFactory<T> {
    private static final Logger logger = Logger.getLogger(MethodBasedFactory.class);
    private final Method method;

    public MethodBasedFactory(Method method) {
        this.method = method;
    }

    @Override
    public boolean isValidForType(Class<? super T> clazz) {
        if (Modifier.isStatic(this.method.getModifiers()) && this.method.getReturnType().equals(clazz)) {
            return true;
        }
        throw new IllegalArgumentException("The method has to be static and return an object of the given class!");
    }

    @Override
    public T createDummy(Type[] genericMetaData, Map<String, ClassUsageInfo<?>> knownInstances, ClassBindings classBindings, List<Exception> exceptions) {
        Method m = this.method;
        Class<?>[] parameters = m.getParameterTypes();
        Object[] params = new Object[parameters.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = new ClassBasedFactory(parameters[i]).createDummy(genericMetaData, knownInstances, classBindings, exceptions);
        }
        try {
            return (T)m.invoke(null, params);
        }
        catch (InvocationTargetException e) {
            logger.debug((Object)String.format("failed to invoke Method [%s] to product an object of type [%s]", m.getName(), this.method.getReturnType()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.debug((Object)String.format("failed to invoke Method [%s] to product an object of type [%s]", m.getName(), this.method.getReturnType()), (Throwable)e);
        }
        return null;
    }
}

