/*
 * Decompiled with CFR 0.152.
 */
package org.dummycreator.dummyfactories;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dummycreator.ClassBindings;
import org.dummycreator.ClassUsageInfo;
import org.dummycreator.RandomCreator;
import org.dummycreator.dummyfactories.DummyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomPrimitiveFactory<T>
extends DummyFactory<T> {
    private static final List<Class<?>> SUPPORTED_PRIMITIVE_CLASSES = new ArrayList();
    private final Class<T> clazz;

    public RandomPrimitiveFactory(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean isValidForType(Class<? super T> clazz) {
        return SUPPORTED_PRIMITIVE_CLASSES.contains(clazz);
    }

    @Override
    public T createDummy(Type[] genericMetaData, Map<String, ClassUsageInfo<?>> knownInstances, ClassBindings classBindings, List<Exception> exceptions) {
        if (this.clazz == Integer.TYPE) {
            return (T)Integer.valueOf(RandomCreator.getInstance().getRandomInt());
        }
        if (this.clazz == Long.TYPE) {
            return (T)Long.valueOf(RandomCreator.getInstance().getRandomLong());
        }
        if (this.clazz == Float.TYPE) {
            return (T)Float.valueOf(RandomCreator.getInstance().getRandomFloat());
        }
        if (this.clazz == Boolean.TYPE) {
            return (T)Boolean.valueOf(RandomCreator.getInstance().getRandomBoolean());
        }
        if (this.clazz == Character.TYPE) {
            return (T)Character.valueOf(RandomCreator.getInstance().getRandomChar());
        }
        if (this.clazz == Byte.TYPE) {
            return (T)Byte.valueOf(RandomCreator.getInstance().getRandomByte());
        }
        if (this.clazz == Short.TYPE) {
            return (T)Short.valueOf(RandomCreator.getInstance().getRandomShort());
        }
        if (this.clazz == Double.TYPE) {
            return (T)Double.valueOf(RandomCreator.getInstance().getRandomDouble());
        }
        return null;
    }

    static {
        SUPPORTED_PRIMITIVE_CLASSES.add(Integer.TYPE);
        SUPPORTED_PRIMITIVE_CLASSES.add(Long.TYPE);
        SUPPORTED_PRIMITIVE_CLASSES.add(Float.TYPE);
        SUPPORTED_PRIMITIVE_CLASSES.add(Boolean.TYPE);
        SUPPORTED_PRIMITIVE_CLASSES.add(Character.TYPE);
        SUPPORTED_PRIMITIVE_CLASSES.add(Byte.TYPE);
        SUPPORTED_PRIMITIVE_CLASSES.add(Short.TYPE);
        SUPPORTED_PRIMITIVE_CLASSES.add(Double.TYPE);
    }
}

