/*
 * Decompiled with CFR 0.152.
 */
package marytts.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import marytts.client.http.MaryHttpClient;

public class BatchSynth {
    public static void main(String[] args) throws Exception {
        File globalOutputDir = new File(args[0]);
        MaryHttpClient mary = new MaryHttpClient();
        String voice = System.getProperty("voice", "us1");
        boolean haveBasename = "true".equals(System.getProperty("lines-contain-basename", "true"));
        String inputFormat = "TEXT";
        String locale = System.getProperty("locale", "en_US");
        String outputFormat = System.getProperty("output.type", "AUDIO");
        String extension = outputFormat.equals("AUDIO") ? ".wav" : "." + outputFormat.toLowerCase();
        long globalStartTime = System.currentTimeMillis();
        int globalCounter = 0;
        int i = 1;
        while (i < args.length) {
            String line;
            long genreStartTime = System.currentTimeMillis();
            int genreCounter = 0;
            File texts = new File(args[i]);
            String genre = texts.getName().substring(0, texts.getName().lastIndexOf(46));
            File outputDir = new File(String.valueOf(globalOutputDir.getPath()) + "/" + genre);
            outputDir.mkdir();
            BufferedReader textReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(texts), "utf-8"));
            while ((line = textReader.readLine()) != null) {
                String sentence;
                String basename;
                if ((line = line.trim()).length() == 0) continue;
                long startTime = System.currentTimeMillis();
                if (line.trim().startsWith("(")) {
                    line = line.substring(line.indexOf("(") + 1, line.lastIndexOf(")"));
                }
                StringTokenizer st = new StringTokenizer(line);
                if (haveBasename) {
                    basename = st.nextToken();
                    sentence = line.substring(line.indexOf(basename) + basename.length() + 1).trim();
                } else {
                    basename = String.valueOf(genre) + genreCounter;
                    sentence = line.trim();
                }
                sentence = sentence.replaceAll("\\\\", "");
                FileOutputStream audio = new FileOutputStream(outputDir + "/" + basename + extension);
                mary.process(sentence, inputFormat, outputFormat, locale, "WAVE", voice, audio);
                audio.close();
                long endTime = System.currentTimeMillis();
                System.out.println(String.valueOf(basename) + " synthesized in " + (double)(endTime - startTime) / 1000.0 + " s");
                ++globalCounter;
                ++genreCounter;
            }
            long genreEndTime = System.currentTimeMillis();
            System.out.println("Genre '" + genre + "' (" + genreCounter + " sentences) synthesized in " + (double)(genreEndTime - genreStartTime) / 1000.0 + " s");
            ++i;
        }
        long globalEndTime = System.currentTimeMillis();
        System.out.println("Total: " + globalCounter + " sentences synthesized in " + (double)(globalEndTime - globalStartTime) / 1000.0 + " s");
    }
}

