/*
 * Decompiled with CFR 0.152.
 */
package marytts.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import marytts.client.AudioEffectsBoxData;
import marytts.client.MaryClient;
import marytts.util.MaryUtils;
import marytts.util.data.audio.MaryAudioUtils;
import marytts.util.http.Address;
import marytts.util.math.MathUtils;
import marytts.util.string.StringUtils;

public class MaryFormData {
    private final String DEFAULT_HOST = "localhost";
    private final int DEFAULT_PORT = 59125;
    public Address hostAddress = null;
    public String serverVersionInfo = null;
    public String serverVersionNo = "unknown";
    public boolean serverCanStream = false;
    public Vector<MaryClient.Voice> allVoices;
    public Map<Locale, Vector<MaryClient.Voice>> voicesByLocaleMap;
    public Map<String, Vector<String>> limitedDomainVoices;
    public Set<Locale> locales;
    public Vector<MaryClient.DataType> allDataTypes;
    public Vector<MaryClient.DataType> inputDataTypes;
    public Vector<MaryClient.DataType> outputDataTypes;
    public Map<String, String> serverExampleTexts;
    public String currentExampleText;
    public Map<String, Vector<String>> voiceExampleTextsLimitedDomain;
    public Map<String, String> voiceExampleTextsGeneralDomain;
    public Map<String, String> audioEffectHelpTextsMap;
    public Vector<String> audioFileFormatTypes;
    public Vector<String> audioOutTypes;
    public String inputText;
    public String outputText;
    public String errorMessage;
    public boolean isOutputText;
    public int voiceSelected;
    public int inputTypeSelected;
    public int outputTypeSelected;
    public int audioFormatSelected;
    public int audioOutSelected;
    public int limitedDomainExampleTextSelected;
    public String audioEffects;
    public String audioEffectsHelpTextLineBreak;
    public AudioEffectsBoxData effectsBoxData;
    public Vector<String> limitedDomainExampleTexts;
    public Map<String, String> keyValuePairs;
    public String outputAudioResponseID;
    public String mimeType;

    public MaryFormData() {
        String serverHost = System.getProperty("server.host", "localhost");
        int serverPort = 0;
        String helperString = System.getProperty("server.port");
        serverPort = helperString != null ? Integer.decode(helperString) : 59125;
        Address serverAddress = new Address(serverHost, serverPort);
        this.init(serverAddress, null, null, null, null, null, null, null, null);
    }

    public MaryFormData(Address serverAddress) {
        this.init(serverAddress, null, null, null, null, null, null, null, null);
    }

    public MaryFormData(Address serverAddress, String versionIn, String voicesIn, String dataTypesIn, String audioFileFormatTypesIn, String audioEffectHelpTextLineBreakIn, String defaultAudioEffects, Vector<String> defaultVoiceExampleTexts) {
        this(serverAddress, null, versionIn, voicesIn, dataTypesIn, audioFileFormatTypesIn, audioEffectHelpTextLineBreakIn, defaultAudioEffects, defaultVoiceExampleTexts);
    }

    public MaryFormData(Address serverAddress, Map<String, String> keyValuePairsIn, String versionIn, String voicesIn, String dataTypesIn, String audioFileFormatTypesIn, String audioEffectHelpTextLineBreakIn, String defaultAudioEffects, Vector<String> defaultVoiceExampleTexts) {
        this.init(serverAddress, keyValuePairsIn, versionIn, voicesIn, dataTypesIn, audioFileFormatTypesIn, audioEffectHelpTextLineBreakIn, defaultAudioEffects, defaultVoiceExampleTexts);
    }

    public void init(Address serverAddress, Map<String, String> keyValuePairsIn, String versionIn, String voicesIn, String dataTypesIn, String audioFileFormatTypesIn, String audioEffectHelpTextLineBreakIn, String defaultAudioEffects, Vector<String> defaultVoiceExampleTexts) {
        this.outputAudioResponseID = "";
        this.mimeType = "";
        this.hostAddress = null;
        this.serverVersionInfo = null;
        this.serverVersionNo = "unknown";
        this.serverCanStream = false;
        this.allVoices = null;
        this.voicesByLocaleMap = null;
        this.limitedDomainVoices = new HashMap<String, Vector<String>>();
        this.allDataTypes = null;
        this.inputDataTypes = null;
        this.outputDataTypes = null;
        this.serverExampleTexts = new HashMap<String, String>();
        this.currentExampleText = "";
        this.voiceExampleTextsLimitedDomain = new HashMap<String, Vector<String>>();
        this.voiceExampleTextsGeneralDomain = new HashMap<String, String>();
        this.audioEffectHelpTextsMap = new HashMap<String, String>();
        this.audioFileFormatTypes = null;
        this.audioOutTypes = null;
        this.inputText = "";
        this.outputText = "";
        this.isOutputText = false;
        this.voiceSelected = 0;
        this.inputTypeSelected = 0;
        this.outputTypeSelected = 0;
        this.audioFormatSelected = 0;
        this.audioOutSelected = 0;
        this.limitedDomainExampleTextSelected = 0;
        this.audioEffects = "";
        this.audioEffectsHelpTextLineBreak = "";
        this.effectsBoxData = null;
        this.keyValuePairs = new HashMap<String, String>();
        this.limitedDomainExampleTexts = null;
        this.hostAddress = serverAddress;
        this.toServerVersionInfo(versionIn);
        this.toVoices(voicesIn);
        this.toDataTypes(dataTypesIn);
        this.toAudioFileFormatAndOutTypes(audioFileFormatTypesIn);
        this.toAudioEffectsHelpTextLineBreak(audioEffectHelpTextLineBreakIn);
        this.toAudioEffects(defaultAudioEffects);
        if (keyValuePairsIn != null) {
            this.toSelections(keyValuePairsIn, defaultVoiceExampleTexts);
        }
    }

    public void toServerVersionInfo(String info) {
        String[] parts;
        this.serverVersionInfo = info;
        this.serverVersionNo = "unknown";
        if (this.serverVersionInfo != null && (parts = this.serverVersionInfo.split(" "))[0].equals("Mary") && parts[1].equals("TTS") && parts[2].equals("server") && parts.length >= 4) {
            this.serverVersionNo = parts[3];
        }
        this.serverCanStream = !this.serverVersionNo.equals("unknown") && this.serverVersionNo.compareTo("3.0.1") >= 0;
    }

    public void toVoices(String info) {
        this.allVoices = null;
        this.voicesByLocaleMap = null;
        this.limitedDomainVoices = null;
        if (info != null && info.length() > 0) {
            this.allVoices = new Vector();
            this.voicesByLocaleMap = new HashMap<Locale, Vector<MaryClient.Voice>>();
            this.limitedDomainVoices = new HashMap<String, Vector<String>>();
            String[] voiceStrings = info.split("\n");
            int i = 0;
            while (i < voiceStrings.length) {
                StringTokenizer st = new StringTokenizer(voiceStrings[i]);
                if (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    if (st.hasMoreTokens()) {
                        String localeString = st.nextToken();
                        Locale locale = MaryFormData.string2locale(localeString);
                        assert (locale != null);
                        if (st.hasMoreTokens()) {
                            String gender = st.nextToken();
                            MaryClient.Voice voice = null;
                            if (this.isServerVersionAtLeast("3.5.0")) {
                                String synthesizerType = !st.hasMoreTokens() ? "non-specified" : st.nextToken();
                                if (!st.hasMoreTokens()) {
                                    voice = new MaryClient.Voice(name, locale, gender, "general");
                                } else {
                                    String domain = st.nextToken();
                                    voice = new MaryClient.Voice(name, locale, gender, domain);
                                }
                                voice.setSynthesizerType(synthesizerType);
                            } else if (!st.hasMoreTokens()) {
                                voice = new MaryClient.Voice(name, locale, gender, "general");
                            } else {
                                String domain = st.nextToken();
                                voice = new MaryClient.Voice(name, locale, gender, domain);
                            }
                            this.allVoices.add(voice);
                            Vector<Object> localeVoices = null;
                            if (this.voicesByLocaleMap.containsKey(locale)) {
                                localeVoices = this.voicesByLocaleMap.get(locale);
                            } else {
                                localeVoices = new Vector();
                                this.voicesByLocaleMap.put(locale, localeVoices);
                            }
                            localeVoices.add(voice);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void toDataTypes(String info) {
        this.allDataTypes = null;
        this.inputDataTypes = null;
        this.outputDataTypes = null;
        if (info != null && info.length() > 0) {
            this.allDataTypes = new Vector();
            this.inputDataTypes = new Vector();
            this.outputDataTypes = new Vector();
            String[] typeStrings = info.split("\n");
            int i = 0;
            while (i < typeStrings.length) {
                StringTokenizer st = new StringTokenizer(typeStrings[i]);
                if (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    boolean isInputType = false;
                    boolean isOutputType = false;
                    while (st.hasMoreTokens()) {
                        String t = st.nextToken();
                        if (t.equals("INPUT")) {
                            isInputType = true;
                            continue;
                        }
                        if (!t.equals("OUTPUT")) continue;
                        isOutputType = true;
                    }
                    MaryClient.DataType dt = new MaryClient.DataType(name, isInputType, isOutputType);
                    this.allDataTypes.add(dt);
                    if (dt.isInputType()) {
                        this.inputDataTypes.add(dt);
                    }
                    if (dt.isOutputType()) {
                        this.outputDataTypes.add(dt);
                    }
                }
                ++i;
            }
        }
    }

    public void toLocales(String info) {
        this.locales = new HashSet<Locale>();
        String[] stringArray = StringUtils.toStringArray((String)info);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String localeName = stringArray[n2];
            this.locales.add(MaryUtils.string2locale((String)localeName));
            ++n2;
        }
    }

    public void toAudioFileFormatAndOutTypes(String info) {
        this.audioFileFormatTypes = null;
        this.audioOutTypes = null;
        String[] allTypes = null;
        if (info != null && info.length() > 0) {
            allTypes = StringUtils.toStringArray((String)info);
        }
        if (allTypes != null) {
            int i = 0;
            while (i < allTypes.length) {
                int spaceInd = allTypes[i].indexOf(32);
                String typeName = allTypes[i].substring(spaceInd + 1);
                AudioFileFormat.Type audioType = null;
                boolean isSupported = true;
                if (typeName.equals("MP3")) {
                    isSupported = false;
                } else if (typeName.equals("Vorbis")) {
                    isSupported = false;
                }
                try {
                    audioType = MaryAudioUtils.getAudioFileFormatType((String)typeName);
                }
                catch (Exception exception) {
                    isSupported = false;
                }
                if (isSupported && audioType != null && AudioSystem.isFileTypeSupported(audioType)) {
                    if (this.audioFileFormatTypes == null) {
                        this.audioFileFormatTypes = new Vector();
                    }
                    this.audioFileFormatTypes.add(allTypes[i]);
                    if (this.audioOutTypes == null) {
                        this.audioOutTypes = new Vector();
                    }
                    this.audioOutTypes.add(String.valueOf(typeName) + "_FILE");
                    if (typeName.compareTo("MP3") == 0) {
                        this.audioOutTypes.add(String.valueOf(typeName) + "_STREAM");
                    }
                }
                ++i;
            }
        }
    }

    public void toAudioEffectsHelpTextLineBreak(String strLineBreak) {
        this.audioEffectsHelpTextLineBreak = strLineBreak != null && strLineBreak.length() > 0 ? strLineBreak : null;
    }

    public void toAudioEffects(String availableAudioEffects) {
        this.audioEffects = availableAudioEffects != null && availableAudioEffects.length() > 0 ? availableAudioEffects : null;
        this.effectsBoxData = this.audioEffects != null && this.audioEffects.length() > 0 ? new AudioEffectsBoxData(this.audioEffects) : null;
    }

    private void toSelections(Map<String, String> keyValuePairsIn, Vector<String> defaultVoiceExampleTexts) {
        int i;
        String selected;
        assert (keyValuePairsIn != null);
        this.keyValuePairs = keyValuePairsIn;
        this.inputTypeSelected = 0;
        this.inputText = "";
        this.outputTypeSelected = this.outputDataTypes != null && this.outputDataTypes.size() > 0 ? this.outputDataTypes.size() - 1 : 0;
        this.isOutputText = false;
        this.outputText = "";
        this.audioFormatSelected = 0;
        this.voiceSelected = 0;
        this.limitedDomainExampleTextSelected = 0;
        if (this.effectsBoxData == null) {
            this.effectsBoxData = new AudioEffectsBoxData(this.audioEffects);
        }
        if ((selected = this.keyValuePairs.get("INPUT_TYPE")) != null) {
            i = 0;
            while (i < this.inputDataTypes.size()) {
                if (this.inputDataTypes.get(i).name().compareTo(selected) == 0) {
                    this.inputTypeSelected = i;
                    break;
                }
                ++i;
            }
        }
        if ((selected = this.keyValuePairs.get("OUTPUT_TYPE")) != null) {
            i = 0;
            while (i < this.outputDataTypes.size()) {
                if (this.outputDataTypes.get(i).name().compareTo(selected) == 0) {
                    this.outputTypeSelected = i;
                    break;
                }
                ++i;
            }
            this.isOutputText = !this.outputDataTypes.get(this.outputTypeSelected).name().contains("AUDIO");
        }
        if ((selected = this.keyValuePairs.get("VOICE")) != null) {
            i = 0;
            while (i < this.allVoices.size()) {
                if (this.allVoices.get(i).name().compareTo(selected) == 0) {
                    this.voiceSelected = i;
                    break;
                }
                ++i;
            }
        }
        if (this.allVoices != null && this.allVoices.size() > 0 && this.allVoices.elementAt(this.voiceSelected).isLimitedDomain()) {
            this.limitedDomainExampleTexts = defaultVoiceExampleTexts;
            selected = this.keyValuePairs.get("exampletext");
            if (this.limitedDomainExampleTexts != null && selected != null) {
                i = 0;
                while (i < this.limitedDomainExampleTexts.size()) {
                    if (this.limitedDomainExampleTexts.get(i).compareTo(selected) == 0) {
                        this.limitedDomainExampleTextSelected = i;
                        break;
                    }
                    ++i;
                }
            } else {
                this.limitedDomainExampleTextSelected = 0;
            }
        }
        if ((selected = this.keyValuePairs.get("INPUT_TEXT")) != null) {
            this.inputText = selected;
        } else if (this.allVoices != null && this.allVoices.size() > 0 && this.inputDataTypes != null && this.inputDataTypes.size() > 0) {
            if (this.allVoices.elementAt(this.voiceSelected).isLimitedDomain() && this.limitedDomainExampleTexts != null) {
                this.inputText = this.limitedDomainExampleTexts.get(this.limitedDomainExampleTextSelected);
            } else if (this.serverExampleTexts != null) {
                this.inputText = this.serverExampleTexts.get(String.valueOf(this.inputDataTypes.get(this.inputTypeSelected).name()) + " " + this.allVoices.elementAt(this.voiceSelected).getLocale().toString());
            }
        }
        if (this.isOutputText && (selected = this.keyValuePairs.get("OUTPUT_TEXT")) != null) {
            this.outputText = selected;
        }
        if ((selected = this.keyValuePairs.get("AUDIO_OUT")) != null) {
            String typeName;
            int scoreInd = selected.indexOf(95);
            selected.substring(scoreInd + 1);
            i = 0;
            while (i < this.audioFileFormatTypes.size()) {
                int spaceInd = this.audioFileFormatTypes.get(i).indexOf(32);
                typeName = this.audioFileFormatTypes.get(i).substring(spaceInd + 1);
                if (typeName.compareTo(selected) == 0) {
                    this.audioFormatSelected = i;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this.audioOutTypes.size()) {
                typeName = this.audioOutTypes.get(i);
                if (typeName.compareTo(selected) == 0) {
                    this.audioOutSelected = i;
                    break;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.effectsBoxData.getTotalEffects()) {
            String currentEffectName = this.effectsBoxData.getControlData(i).getEffectName();
            selected = this.keyValuePairs.get("effect_" + currentEffectName + "_selected");
            if (selected != null && selected.compareTo("on") == 0) {
                this.effectsBoxData.getControlData(i).setSelected(true);
            } else {
                this.effectsBoxData.getControlData(i).setSelected(false);
            }
            selected = this.keyValuePairs.get("effect_" + currentEffectName + "_parameters");
            if (selected != null) {
                this.effectsBoxData.getControlData(i).setParams(selected);
            } else {
                this.effectsBoxData.getControlData(i).setEffectParamsToExample();
            }
            ++i;
        }
    }

    public boolean isServerVersionAtLeast(String serverVersionToCompare) {
        if (this.serverVersionNo.equals("unknown")) {
            return false;
        }
        int tmp = this.serverVersionNo.compareToIgnoreCase(serverVersionToCompare);
        return tmp >= 0;
    }

    public void checkAndCorrectSelections() {
        this.audioFormatSelected = MathUtils.CheckLimits((int)this.audioFormatSelected, (int)0, (int)(this.audioFileFormatTypes.size() - 1));
        this.audioOutSelected = MathUtils.CheckLimits((int)this.audioOutSelected, (int)0, (int)(this.audioOutTypes.size() - 1));
        this.inputTypeSelected = MathUtils.CheckLimits((int)this.inputTypeSelected, (int)0, (int)(this.inputDataTypes.size() - 1));
        this.outputTypeSelected = MathUtils.CheckLimits((int)this.outputTypeSelected, (int)0, (int)(this.outputDataTypes.size() - 1));
        this.voiceSelected = MathUtils.CheckLimits((int)this.voiceSelected, (int)0, (int)(this.allVoices.size() - 1));
    }

    public static Locale string2locale(String localeString) {
        Locale locale = null;
        StringTokenizer localeST = new StringTokenizer(localeString, "_");
        String language = localeST.nextToken();
        String country = "";
        String variant = "";
        if (localeST.hasMoreTokens()) {
            country = localeST.nextToken();
            if (localeST.hasMoreTokens()) {
                variant = localeST.nextToken();
            }
        }
        locale = new Locale(language, country, variant);
        return locale;
    }
}

