/*
 * Decompiled with CFR 0.152.
 */
package marytts.client;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.client.MaryClient;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.http.Address;
import marytts.util.string.StringUtils;

public class MarySocketClient
extends MaryClient {
    public MarySocketClient() throws IOException {
    }

    public MarySocketClient(Address serverAddress) throws IOException {
        super(serverAddress);
    }

    public MarySocketClient(Address serverAddress, boolean profile, boolean quiet) throws IOException {
        super(serverAddress, profile, quiet);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void _process(String input, String inputType, String outputType, String locale, String audioType, String defaultVoiceName, String defaultStyle, String defaultEffects, Object output, long timeout, boolean streamingAudio, String outputTypeParams, MaryClient.AudioPlayerListener playerListener) throws IOException {
        block26: {
            isMaryAudioPlayer = false;
            if (output instanceof AudioPlayer) {
                isMaryAudioPlayer = true;
            } else if (!(output instanceof OutputStream)) {
                throw new IllegalArgumentException("Expected OutputStream or AudioPlayer, got " + output.getClass().getName());
            }
            startTime = System.currentTimeMillis();
            try {
                maryInfoSocket = new Socket(this.data.hostAddress.getHost(), this.data.hostAddress.getPort());
            }
            catch (SocketException se) {
                throw new RuntimeException("Cannot connect to " + this.data.hostAddress.getFullAddress(), se);
            }
            toServerInfo = new PrintWriter((Writer)new OutputStreamWriter(maryInfoSocket.getOutputStream(), "UTF-8"), true);
            fromServerInfo = new BufferedReader(new InputStreamReader(maryInfoSocket.getInputStream(), "UTF-8"));
            toServerInfo.print("MARY IN=" + inputType + " OUT=" + outputType + " LOCALE=" + locale);
            if (audioType != null) {
                if (streamingAudio && this.data.serverCanStream) {
                    toServerInfo.print(" AUDIO=STREAMING_" + audioType);
                } else {
                    toServerInfo.print(" AUDIO=" + audioType);
                }
            }
            if (defaultVoiceName != null && !defaultVoiceName.equals("")) {
                toServerInfo.print(" VOICE=" + defaultVoiceName);
            }
            if (defaultStyle != null && !defaultStyle.equals("")) {
                toServerInfo.print(" STYLE=" + defaultStyle);
            }
            if (defaultEffects != null && !defaultEffects.equals("")) {
                toServerInfo.print(" EFFECTS=" + defaultEffects);
            }
            toServerInfo.println();
            helper = fromServerInfo.readLine();
            id = -1;
            try {
                id = Integer.parseInt(helper);
                break block26;
            }
            catch (NumberFormatException v0) {
                message = new StringBuilder("Server replied:\n");
                message.append(helper);
                message.append("\n");
                ** while ((helper = fromServerInfo.readLine()) != null)
            }
lbl-1000:
            // 1 sources

            {
                message.append(helper);
                message.append("\n");
                continue;
            }
lbl45:
            // 1 sources

            throw new IOException(message.toString());
        }
        maryDataSocket = new Socket(this.data.hostAddress.getHost(), this.data.hostAddress.getPort());
        toServerData = new PrintWriter((Writer)new OutputStreamWriter(maryDataSocket.getOutputStream(), "UTF-8"), true);
        toServerData.println(id);
        toServerData.println(input.trim());
        maryDataSocket.shutdownOutput();
        warningReader = new MaryClient.WarningReader(fromServerInfo);
        warningReader.start();
        fromServerStream = maryDataSocket.getInputStream();
        if (timeout <= 0L) {
            timer = null;
        } else {
            timer = new Timer();
            timerTask = new TimerTask(){

                @Override
                public void run() {
                    System.err.println("Timer closes socket");
                    try {
                        maryDataSocket.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            };
            timer.schedule(timerTask, timeout);
        }
        if (isMaryAudioPlayer) {
            player = (AudioPlayer)output;
            listener = playerListener;
            t = new Thread(){

                @Override
                public void run() {
                    try {
                        AudioFormat audioFormat;
                        InputStream in = fromServerStream;
                        if (MarySocketClient.this.doProfile) {
                            System.err.println("After " + (System.currentTimeMillis() - startTime) + " ms: Trying to read data from server");
                        }
                        in = new BufferedInputStream(in);
                        in.mark(1000);
                        AudioInputStream fromServerAudio = AudioSystem.getAudioInputStream(in);
                        if (fromServerAudio.getFrameLength() == 0L) {
                            fromServerAudio = new AudioInputStream(in, fromServerAudio.getFormat(), -1L);
                        }
                        if (MarySocketClient.this.doProfile) {
                            System.err.println("After " + (System.currentTimeMillis() - startTime) + " ms: Audio available: " + in.available());
                        }
                        if (!(audioFormat = fromServerAudio.getFormat()).getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                            audioFormat = new AudioFormat(fromServerAudio.getFormat().getSampleRate(), 16, 1, true, false);
                            fromServerAudio = AudioSystem.getAudioInputStream(audioFormat, fromServerAudio);
                        }
                        player.setAudio(fromServerAudio);
                        player.run();
                        if (timer != null) {
                            timer.cancel();
                        }
                        if (listener != null) {
                            listener.playerFinished();
                        }
                        toServerInfo.close();
                        fromServerInfo.close();
                        maryInfoSocket.close();
                        toServerData.close();
                        maryDataSocket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        warningReader.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    if (warningReader.getWarnings().length() > 0) {
                        String warnings = warningReader.getWarnings();
                        System.err.println(warnings);
                        if (listener != null) {
                            listener.playerException(new IOException(warnings));
                        }
                    }
                    if (MarySocketClient.this.doProfile) {
                        long endTime = System.currentTimeMillis();
                        long processingTime = endTime - startTime;
                        System.err.println("Processed request in " + processingTime + " ms.");
                    }
                }
            };
            if (streamingAudio) {
                t.start();
            } else {
                t.run();
            }
        } else {
            os = (OutputStream)output;
            bis = new BufferedInputStream(fromServerStream);
            bbuf = new byte[1024];
            while ((nr = bis.read(bbuf, 0, bbuf.length)) != -1) {
                os.write(bbuf, 0, nr);
            }
            os.flush();
            if (timeout > 0L) {
                timer.cancel();
            }
            toServerInfo.close();
            fromServerInfo.close();
            maryInfoSocket.close();
            toServerData.close();
            maryDataSocket.close();
            try {
                warningReader.join();
            }
            catch (InterruptedException v1) {}
            if (warningReader.getWarnings().length() > 0) {
                throw new IOException(warningReader.getWarnings());
            }
            if (this.doProfile) {
                endTime = System.currentTimeMillis();
                processingTime = endTime - startTime;
                System.err.println("Processed request in " + processingTime + " ms.");
            }
        }
    }

    private String getServerInfo(String infoCommand) throws IOException {
        Socket marySocket = new Socket(this.data.hostAddress.getHost(), this.data.hostAddress.getPort());
        PrintWriter toServerInfo = new PrintWriter((Writer)new OutputStreamWriter(marySocket.getOutputStream(), "UTF-8"), true);
        BufferedReader fromServerInfo = new BufferedReader(new InputStreamReader(marySocket.getInputStream(), "UTF-8"));
        toServerInfo.println(infoCommand);
        StringBuilder result = new StringBuilder();
        String line = null;
        while ((line = fromServerInfo.readLine()) != null && !line.equals("")) {
            result.append(line);
            result.append("\n");
        }
        marySocket.close();
        return result.toString();
    }

    @Override
    protected void fillServerVersion() throws IOException, UnknownHostException {
        String info = this.getServerInfo("MARY VERSION");
        if (info.length() == 0) {
            throw new IOException("Could not get version info from Mary server");
        }
        info = info.replace('\n', ' ');
        this.data.toServerVersionInfo(info);
    }

    @Override
    protected void fillDataTypes() throws UnknownHostException, IOException {
        String info = this.getServerInfo("MARY LIST DATATYPES");
        if (info.length() == 0) {
            throw new IOException("Could not get list of data types from Mary server");
        }
        this.data.toDataTypes(info);
    }

    @Override
    protected void fillVoices() throws IOException, UnknownHostException {
        String info = this.getServerInfo("MARY LIST VOICES");
        if (info.length() == 0) {
            throw new IOException("Could not get voice list from Mary server");
        }
        this.data.toVoices(info);
    }

    @Override
    protected void fillLocales() throws IOException, UnknownHostException {
        String info = this.getServerInfo("MARY LIST LOCALES");
        if (info.length() == 0) {
            throw new IOException("Could not get locales list from Mary server");
        }
        this.data.toLocales(info);
    }

    @Override
    protected void fillVoiceExampleTexts(String voicename) throws IOException {
        String info = this.getServerInfo("MARY VOICE EXAMPLETEXT " + voicename);
        if (info.length() == 0) {
            throw new IOException("Could not get example text from Mary server");
        }
        StringTokenizer st = new StringTokenizer(info, "\n");
        Vector<String> sentences = new Vector<String>();
        while (st.hasMoreTokens()) {
            sentences.add(st.nextToken());
        }
        this.data.voiceExampleTextsLimitedDomain.put(voicename, sentences);
    }

    @Override
    protected void fillServerExampleText(String dataType, String locale) throws IOException {
        String info = this.getServerInfo("MARY EXAMPLETEXT " + dataType + " " + locale);
        if (info.length() == 0) {
            throw new IOException("Could not get example text from Mary server");
        }
        this.data.serverExampleTexts.put(String.valueOf(dataType) + " " + locale, info.replaceAll("\n", System.getProperty("line.separator")));
    }

    @Override
    protected String getDefaultAudioEffects() throws IOException {
        return this.getServerInfo("MARY VOICE GETDEFAULTAUDIOEFFECTS");
    }

    @Override
    public String requestDefaultEffectParameters(String effectName) throws IOException, UnknownHostException {
        String info = this.getServerInfo("MARY VOICE GETAUDIOEFFECTDEFAULTPARAM " + effectName);
        return info.replaceAll("\n", System.getProperty("line.separator"));
    }

    @Override
    public String requestFullEffect(String effectName, String currentEffectParams) throws IOException, UnknownHostException {
        String info = this.getServerInfo("MARY VOICE GETFULLAUDIOEFFECT " + effectName + " " + currentEffectParams);
        return info.replaceAll("\n", System.getProperty("line.separator"));
    }

    @Override
    protected void fillEffectHelpText(String effectName) throws IOException {
        String info = this.getServerInfo("MARY VOICE GETAUDIOEFFECTHELPTEXT " + effectName);
        this.data.audioEffectHelpTextsMap.put(effectName, info.replaceAll("\n", System.getProperty("line.separator")));
    }

    @Override
    public boolean isHMMEffect(String effectName) throws IOException, UnknownHostException {
        String info = this.getServerInfo("MARY VOICE ISHMMAUDIOEFFECT " + effectName);
        if (info.length() == 0) {
            return false;
        }
        boolean bRet = false;
        if ((info = info.toLowerCase()).indexOf("yes") > -1) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public String getFeatures(String locale) throws IOException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getFeaturesForVoice(String voice) throws IOException {
        throw new RuntimeException("not implemented");
    }

    @Override
    protected void fillAudioFileFormatAndOutTypes() throws IOException {
        String audioFormatInfo = this.getServerInfo("MARY LIST AUDIOFILEFORMATTYPES");
        this.data.audioOutTypes = new Vector<String>(Arrays.asList(StringUtils.toStringArray((String)audioFormatInfo)));
        this.data.audioFileFormatTypes = new Vector();
        for (String af : this.data.audioOutTypes) {
            if (!af.endsWith("_FILE")) continue;
            String typeName = af.substring(0, af.indexOf("_"));
            try {
                AudioFileFormat.Type type = MaryClient.getAudioFileFormatType(typeName);
                this.data.audioFileFormatTypes.add(String.valueOf(typeName) + " " + type.getExtension());
            }
            catch (Exception exception) {}
        }
    }
}

