/*
 * Decompiled with CFR 0.152.
 */
package marytts.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.MaryInterface;
import marytts.client.MaryClient;
import marytts.exceptions.SynthesisException;
import marytts.util.dom.DomUtils;
import marytts.util.http.Address;
import org.w3c.dom.Document;

public class RemoteMaryInterface
implements MaryInterface {
    private MaryClient client;
    private MaryClient.DataType inputType;
    private MaryClient.DataType outputType;
    private Locale locale;
    private String voiceName;
    private String effects;
    private String style;
    private String outputTypeParams;
    private boolean isStreaming;
    private Vector<MaryClient.Voice> availableVoices;
    private Set<Locale> availableLocales;
    private Map<String, MaryClient.DataType> availableDataTypes;
    private static final Set<String> KNOWN_TEXT_TYPES = new HashSet<String>(Arrays.asList("HALFPHONE_TARGETFEATURES", "HTSCONTEXT", "MBROLA", "PRAAT_TEXTGRID", "REALISED_DURATIONS", "SIMPLEPHONEMES", "TARGETFEATURES", "TEXT"));
    private static final Set<String> KNOWN_XML_TYPES = new HashSet<String>(Arrays.asList("ACOUSTPARAMS", "ALLOPHONES", "APML", "DURATIONS", "INTONATION", "PARTSOFSPEECH", "PHONEMES", "RAWMARYXML", "REALISED_ACOUSTPARAMS", "SABLE", "SSML", "TOKENS", "WORDS"));
    private static final Set<String> KNOWN_AUDIO_TYPES = new HashSet<String>(Arrays.asList("AUDIO"));

    public RemoteMaryInterface() throws IOException {
        this.client = MaryClient.getMaryClient();
        this.init();
    }

    public RemoteMaryInterface(String serverHost, int serverPort) throws IOException {
        this.client = MaryClient.getMaryClient(new Address(serverHost, serverPort));
        this.init();
    }

    private void init() throws IOException {
        this.setReasonableDefaults();
    }

    private void setReasonableDefaults() throws IOException {
        this.availableDataTypes = new HashMap<String, MaryClient.DataType>();
        for (MaryClient.DataType d : this.client.getAllDataTypes()) {
            this.availableDataTypes.put(d.name(), d);
        }
        this.availableLocales = this.client.getLocales();
        this.availableVoices = this.client.getVoices();
        this.inputType = this.availableDataTypes.get("TEXT");
        this.outputType = this.availableDataTypes.get("AUDIO");
        this.locale = this.availableLocales.contains(Locale.US) ? Locale.US : this.availableLocales.iterator().next();
        this.voiceName = this.getDefaultVoice(this.locale);
        this.effects = null;
        this.style = null;
        this.outputTypeParams = null;
        this.isStreaming = false;
    }

    public void setInputType(String newInputType) throws IllegalArgumentException {
        MaryClient.DataType inType = this.availableDataTypes.get(newInputType);
        if (inType == null) {
            throw new IllegalArgumentException("No such data type: " + newInputType);
        }
        if (!inType.isInputType()) {
            throw new IllegalArgumentException("Not an input type: " + newInputType);
        }
        this.inputType = inType;
    }

    public String getInputType() {
        return this.inputType.name();
    }

    public void setOutputType(String newOutputType) throws IllegalArgumentException {
        MaryClient.DataType outType = this.availableDataTypes.get(newOutputType);
        if (outType == null) {
            throw new IllegalArgumentException("No such data type: " + newOutputType);
        }
        if (!outType.isOutputType()) {
            throw new IllegalArgumentException("Not an output type: " + newOutputType);
        }
        this.outputType = outType;
    }

    public String getOutputType() {
        return this.outputType.name();
    }

    public void setLocale(Locale newLocale) throws IllegalArgumentException {
        if (!this.availableLocales.contains(newLocale)) {
            throw new IllegalArgumentException("Unsupported locale: " + newLocale);
        }
        this.locale = newLocale;
        this.voiceName = this.getDefaultVoice(this.locale);
    }

    private String getDefaultVoice(Locale loc) {
        for (MaryClient.Voice v : this.availableVoices) {
            if (!v.getLocale().equals(loc)) continue;
            return v.name();
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setVoice(String newVoiceName) throws IllegalArgumentException {
        for (MaryClient.Voice v : this.availableVoices) {
            if (!v.name().equals(newVoiceName)) continue;
            this.voiceName = newVoiceName;
            this.locale = v.getLocale();
            return;
        }
        throw new IllegalArgumentException("Not a valid voice name: " + newVoiceName);
    }

    public String getVoice() {
        return this.voiceName;
    }

    public void setAudioEffects(String audioEffects) {
        this.effects = audioEffects;
    }

    public String getAudioEffects() {
        return this.effects;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyle() {
        return this.style;
    }

    public void setOutputTypeParams(String params) {
        this.outputTypeParams = params;
    }

    public String getOutputTypeParams() {
        return this.outputTypeParams;
    }

    public void setStreamingAudio(boolean newIsStreaming) {
        this.isStreaming = newIsStreaming;
        if (this.isStreaming) {
            throw new RuntimeException("Streaming audio not yet implemented in this interface");
        }
    }

    public boolean isStreamingAudio() {
        return this.isStreaming;
    }

    public String generateText(String text) throws SynthesisException {
        this.verifyInputTypeIsText();
        this.verifyOutputTypeIsText();
        try {
            byte[] result = this.processStringToBytes(text);
            return new String(result, "UTF-8");
        }
        catch (Exception ioe) {
            throw new SynthesisException((Throwable)ioe);
        }
    }

    public String generateText(Document doc) throws SynthesisException {
        this.verifyInputTypeIsXML();
        this.verifyOutputTypeIsText();
        try {
            String xmlAsString = DomUtils.document2String((Document)doc);
            byte[] result = this.processStringToBytes(xmlAsString);
            return new String(result, "UTF-8");
        }
        catch (Exception ioe) {
            throw new SynthesisException((Throwable)ioe);
        }
    }

    public Document generateXML(String text) throws SynthesisException {
        this.verifyInputTypeIsText();
        this.verifyOutputTypeIsXML();
        try {
            byte[] result = this.processStringToBytes(text);
            return DomUtils.parseDocument((InputStream)new ByteArrayInputStream(result));
        }
        catch (Exception ioe) {
            throw new SynthesisException((Throwable)ioe);
        }
    }

    public Document generateXML(Document doc) throws SynthesisException {
        this.verifyInputTypeIsXML();
        this.verifyOutputTypeIsXML();
        try {
            String xmlAsString = DomUtils.document2String((Document)doc);
            byte[] result = this.processStringToBytes(xmlAsString);
            return DomUtils.parseDocument((InputStream)new ByteArrayInputStream(result));
        }
        catch (Exception ioe) {
            throw new SynthesisException((Throwable)ioe);
        }
    }

    public AudioInputStream generateAudio(String text) throws SynthesisException {
        this.verifyInputTypeIsText();
        this.verifyOutputTypeIsAudio();
        try {
            byte[] result = this.processStringToBytes(text);
            return AudioSystem.getAudioInputStream(new ByteArrayInputStream(result));
        }
        catch (Exception ioe) {
            throw new SynthesisException((Throwable)ioe);
        }
    }

    public AudioInputStream generateAudio(Document doc) throws SynthesisException {
        this.verifyInputTypeIsXML();
        this.verifyOutputTypeIsAudio();
        try {
            String xmlAsString = DomUtils.document2String((Document)doc);
            byte[] result = this.processStringToBytes(xmlAsString);
            return AudioSystem.getAudioInputStream(new ByteArrayInputStream(result));
        }
        catch (Exception ioe) {
            throw new SynthesisException((Throwable)ioe);
        }
    }

    private byte[] processStringToBytes(String input) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.client.process(input, this.inputType.name(), this.outputType.name(), this.locale.toString(), "WAVE", this.voiceName, this.style, this.effects, this.outputTypeParams, baos, 0L);
        return baos.toByteArray();
    }

    private void verifyOutputTypeIsXML() {
        if (KNOWN_TEXT_TYPES.contains(this.outputType.name()) || KNOWN_AUDIO_TYPES.contains(this.outputType.name())) {
            throw new IllegalArgumentException("Cannot provide XML output for non-XML-based output type " + this.outputType);
        }
    }

    private void verifyInputTypeIsXML() {
        if (KNOWN_TEXT_TYPES.contains(this.inputType.name()) || KNOWN_AUDIO_TYPES.contains(this.inputType.name())) {
            throw new IllegalArgumentException("Cannot provide XML input for non-XML-based input type " + this.inputType);
        }
    }

    private void verifyInputTypeIsText() {
        if (KNOWN_XML_TYPES.contains(this.inputType.name()) || KNOWN_AUDIO_TYPES.contains(this.inputType.name())) {
            throw new IllegalArgumentException("Cannot provide plain-text input for XML-based input type " + this.inputType);
        }
    }

    private void verifyOutputTypeIsAudio() {
        if (!this.outputType.name().equals("AUDIO")) {
            throw new IllegalArgumentException("Cannot provide audio output for non-audio output type " + this.outputType);
        }
    }

    private void verifyOutputTypeIsText() {
        if (KNOWN_XML_TYPES.contains(this.outputType.name()) || KNOWN_AUDIO_TYPES.contains(this.outputType.name())) {
            throw new IllegalArgumentException("Cannot provide text output for non-text output type " + this.outputType);
        }
    }

    public Set<String> getAvailableVoices() {
        HashSet<String> voices = new HashSet<String>();
        for (MaryClient.Voice v : this.availableVoices) {
            voices.add(v.name());
        }
        return voices;
    }

    public Set<String> getAvailableVoices(Locale aLocale) {
        HashSet<String> voices = new HashSet<String>();
        for (MaryClient.Voice v : this.availableVoices) {
            if (!v.getLocale().equals(aLocale)) continue;
            voices.add(v.name());
        }
        return voices;
    }

    public Set<Locale> getAvailableLocales() {
        return Collections.unmodifiableSet(this.availableLocales);
    }

    public Set<String> getAvailableInputTypes() {
        HashSet<String> inputTypes = new HashSet<String>();
        for (MaryClient.DataType d : this.availableDataTypes.values()) {
            if (!d.isInputType()) continue;
            inputTypes.add(d.name());
        }
        return inputTypes;
    }

    public Set<String> getAvailableOutputTypes() {
        HashSet<String> outputTypes = new HashSet<String>();
        for (MaryClient.DataType d : this.availableDataTypes.values()) {
            if (!d.isOutputType()) continue;
            outputTypes.add(d.name());
        }
        return outputTypes;
    }

    public boolean isTextType(String dataType) {
        return KNOWN_TEXT_TYPES.contains(dataType);
    }

    public boolean isXMLType(String dataType) {
        return KNOWN_XML_TYPES.contains(dataType);
    }

    public boolean isAudioType(String dataType) {
        return KNOWN_AUDIO_TYPES.contains(dataType);
    }
}

