/*
 * Decompiled with CFR 0.152.
 */
package marytts.util;

public class ConversionUtils {
    public static byte[] toByteArray(byte byteArray) {
        return new byte[]{byteArray};
    }

    public static byte[] toByteArray(byte[] byteArray) {
        return byteArray;
    }

    public static byte[] toByteArray(short data) {
        return new byte[]{(byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] toByteArray(short[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 2];
        int i = 0;
        while (i < data.length) {
            System.arraycopy(ConversionUtils.toByteArray(data[i]), 0, byts, i * 2, 2);
            ++i;
        }
        return byts;
    }

    public static byte[] toByteArray(char data) {
        return new byte[]{(byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] toByteArray(char[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 2];
        int i = 0;
        while (i < data.length) {
            System.arraycopy(ConversionUtils.toByteArray(data[i]), 0, byts, i * 2, 2);
            ++i;
        }
        return byts;
    }

    public static byte[] toByteArray(int data) {
        return new byte[]{(byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] toByteArray(int[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 4];
        int i = 0;
        while (i < data.length) {
            System.arraycopy(ConversionUtils.toByteArray(data[i]), 0, byts, i * 4, 4);
            ++i;
        }
        return byts;
    }

    public static byte[] toByteArray(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    public static byte[] toByteArray(long[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 8];
        int i = 0;
        while (i < data.length) {
            System.arraycopy(ConversionUtils.toByteArray(data[i]), 0, byts, i * 8, 8);
            ++i;
        }
        return byts;
    }

    public static byte[] toByteArray(float data) {
        return ConversionUtils.toByteArray(Float.floatToRawIntBits(data));
    }

    public static byte[] toByteArray(float[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 4];
        int i = 0;
        while (i < data.length) {
            System.arraycopy(ConversionUtils.toByteArray(data[i]), 0, byts, i * 4, 4);
            ++i;
        }
        return byts;
    }

    public static byte[] toByteArray(double data) {
        return ConversionUtils.toByteArray(Double.doubleToRawLongBits(data));
    }

    public static byte[] toByteArray(double[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 8];
        int i = 0;
        while (i < data.length) {
            System.arraycopy(ConversionUtils.toByteArray(data[i]), 0, byts, i * 8, 8);
            ++i;
        }
        return byts;
    }

    public static byte[] toByteArray(boolean data) {
        return new byte[]{(byte)(data ? 1 : 0)};
    }

    public static byte[] toByteArray(boolean[] data) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        byte[] lena = ConversionUtils.toByteArray(len);
        byte[] byts = new byte[lena.length + len / 8 + (len % 8 != 0 ? 1 : 0)];
        System.arraycopy(lena, 0, byts, 0, lena.length);
        int i = 0;
        int j = lena.length;
        int k = 7;
        while (i < data.length) {
            int n = j;
            byts[n] = (byte)(byts[n] | (data[i] ? 1 : 0) << k--);
            if (k < 0) {
                ++j;
                k = 7;
            }
            ++i;
        }
        return byts;
    }

    public static byte[] toByteArray(String data) {
        return data == null ? null : data.getBytes();
    }

    public static byte[] toByteArray(String[] data) {
        if (data == null) {
            return null;
        }
        int totalLength = 0;
        int bytesPos = 0;
        byte[] dLen = ConversionUtils.toByteArray(data.length);
        totalLength += dLen.length;
        int[] sLens = new int[data.length];
        totalLength += sLens.length * 4;
        byte[][] strs = new byte[data.length][];
        int i = 0;
        while (i < data.length) {
            if (data[i] != null) {
                strs[i] = ConversionUtils.toByteArray(data[i]);
                sLens[i] = strs[i].length;
                totalLength += strs[i].length;
            } else {
                sLens[i] = 0;
                strs[i] = new byte[0];
            }
            ++i;
        }
        byte[] bytes = new byte[totalLength];
        System.arraycopy(dLen, 0, bytes, 0, 4);
        byte[] bsLens = ConversionUtils.toByteArray(sLens);
        System.arraycopy(bsLens, 0, bytes, 4, bsLens.length);
        bytesPos += 4 + bsLens.length;
        byte[][] byArrayArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] sba = byArrayArray[n2];
            System.arraycopy(sba, 0, bytes, bytesPos, sba.length);
            bytesPos += sba.length;
            ++n2;
        }
        return bytes;
    }

    public static byte toByte(byte[] byteArray) {
        return byteArray == null || byteArray.length == 0 ? (byte)0 : byteArray[0];
    }

    public static short toShort(byte[] byteArray) {
        if (byteArray == null || byteArray.length != 2) {
            return 0;
        }
        return (short)((0xFF & byteArray[0]) << 8 | (0xFF & byteArray[1]) << 0);
    }

    public static short[] toShortArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length % 2 != 0) {
            return null;
        }
        short[] shts = new short[byteArray.length / 2];
        int i = 0;
        while (i < shts.length) {
            shts[i] = ConversionUtils.toShort(new byte[]{byteArray[i * 2], byteArray[i * 2 + 1]});
            ++i;
        }
        return shts;
    }

    public static char toChar(byte[] byteArray) {
        if (byteArray == null || byteArray.length != 2) {
            return '\u0000';
        }
        return (char)((0xFF & byteArray[0]) << 8 | (0xFF & byteArray[1]) << 0);
    }

    public static char[] toCharArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length % 2 != 0) {
            return null;
        }
        char[] chrs = new char[byteArray.length / 2];
        int i = 0;
        while (i < chrs.length) {
            chrs[i] = ConversionUtils.toChar(new byte[]{byteArray[i * 2], byteArray[i * 2 + 1]});
            ++i;
        }
        return chrs;
    }

    public static int toInt(byte[] byteArray) {
        if (byteArray == null || byteArray.length != 4) {
            return 0;
        }
        return (0xFF & byteArray[0]) << 24 | (0xFF & byteArray[1]) << 16 | (0xFF & byteArray[2]) << 8 | (0xFF & byteArray[3]) << 0;
    }

    public static int[] toIntArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length % 4 != 0) {
            return null;
        }
        int[] ints = new int[byteArray.length / 4];
        int i = 0;
        while (i < ints.length) {
            ints[i] = ConversionUtils.toInt(new byte[]{byteArray[i * 4], byteArray[i * 4 + 1], byteArray[i * 4 + 2], byteArray[i * 4 + 3]});
            ++i;
        }
        return ints;
    }

    public static long toLong(byte[] byteArray) {
        if (byteArray == null || byteArray.length != 8) {
            return 0L;
        }
        return (long)(0xFF & byteArray[0]) << 56 | (long)(0xFF & byteArray[1]) << 48 | (long)(0xFF & byteArray[2]) << 40 | (long)(0xFF & byteArray[3]) << 32 | (long)(0xFF & byteArray[4]) << 24 | (long)(0xFF & byteArray[5]) << 16 | (long)(0xFF & byteArray[6]) << 8 | (long)(0xFF & byteArray[7]) << 0;
    }

    public static long[] toLongArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length % 8 != 0) {
            return null;
        }
        long[] lngs = new long[byteArray.length / 8];
        int i = 0;
        while (i < lngs.length) {
            lngs[i] = ConversionUtils.toLong(new byte[]{byteArray[i * 8], byteArray[i * 8 + 1], byteArray[i * 8 + 2], byteArray[i * 8 + 3], byteArray[i * 8 + 4], byteArray[i * 8 + 5], byteArray[i * 8 + 6], byteArray[i * 8 + 7]});
            ++i;
        }
        return lngs;
    }

    public static float toFloat(byte[] byteArray) {
        if (byteArray == null || byteArray.length != 4) {
            return 0.0f;
        }
        return Float.intBitsToFloat(ConversionUtils.toInt(byteArray));
    }

    public static float[] toFloatArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length % 4 != 0) {
            return null;
        }
        float[] flts = new float[byteArray.length / 4];
        int i = 0;
        while (i < flts.length) {
            flts[i] = ConversionUtils.toFloat(new byte[]{byteArray[i * 4], byteArray[i * 4 + 1], byteArray[i * 4 + 2], byteArray[i * 4 + 3]});
            ++i;
        }
        return flts;
    }

    public static double toDouble(byte[] byteArray) {
        if (byteArray == null || byteArray.length != 8) {
            return 0.0;
        }
        return Double.longBitsToDouble(ConversionUtils.toLong(byteArray));
    }

    public static double[] toDoubleArray(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length % 8 != 0) {
            return null;
        }
        double[] dbls = new double[byteArray.length / 8];
        int i = 0;
        while (i < dbls.length) {
            dbls[i] = ConversionUtils.toDouble(new byte[]{byteArray[i * 8], byteArray[i * 8 + 1], byteArray[i * 8 + 2], byteArray[i * 8 + 3], byteArray[i * 8 + 4], byteArray[i * 8 + 5], byteArray[i * 8 + 6], byteArray[i * 8 + 7]});
            ++i;
        }
        return dbls;
    }

    public static boolean toBoolean(byte[] byteArray) {
        return byteArray == null || byteArray.length == 0 ? false : byteArray[0] != 0;
    }

    public static boolean[] toBooleanArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 4) {
            return null;
        }
        int len = ConversionUtils.toInt(new byte[]{byteArray[0], byteArray[1], byteArray[2], byteArray[3]});
        boolean[] bools = new boolean[len];
        int i = 0;
        int j = 4;
        int k = 7;
        while (i < bools.length) {
            boolean bl = bools[i] = (byteArray[j] >> k-- & 1) == 1;
            if (k < 0) {
                ++j;
                k = 7;
            }
            ++i;
        }
        return bools;
    }

    public static String toString(byte[] byteArray) {
        return byteArray == null ? null : new String(byteArray);
    }

    public static String[] toStringArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 4) {
            return null;
        }
        byte[] bBuff = new byte[4];
        System.arraycopy(byteArray, 0, bBuff, 0, 4);
        int saLen = ConversionUtils.toInt(bBuff);
        if (byteArray.length < 4 + saLen * 4) {
            return null;
        }
        bBuff = new byte[saLen * 4];
        System.arraycopy(byteArray, 4, bBuff, 0, bBuff.length);
        int[] sLens = ConversionUtils.toIntArray(bBuff);
        if (sLens == null) {
            return null;
        }
        String[] strs = new String[saLen];
        int i = 0;
        int dataPos = 4 + saLen * 4;
        while (i < saLen) {
            if (sLens[i] > 0) {
                if (byteArray.length >= dataPos + sLens[i]) {
                    bBuff = new byte[sLens[i]];
                    System.arraycopy(byteArray, dataPos, bBuff, 0, sLens[i]);
                    dataPos += sLens[i];
                    strs[i] = ConversionUtils.toString(bBuff);
                } else {
                    return null;
                }
            }
            ++i;
        }
        return strs;
    }
}

