/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.Socket;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import marytts.util.MaryUtils;
import marytts.util.io.FileFilter;
import marytts.util.string.StringUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class FileUtils {
    public static void close(Socket socket, Closeable ... closeables) {
        Closeable[] closeableArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            Closeable c = closeableArray[n2];
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception ex) {
                    MaryUtils.getLogger(FileUtils.class.getName()).log((Priority)Level.WARN, (Object)"Couldn't close Closeable.", (Throwable)ex);
                }
            }
            ++n2;
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception ex) {
                MaryUtils.getLogger(FileUtils.class.getName()).log((Priority)Level.WARN, (Object)"Couldn't close Socket.", (Throwable)ex);
            }
        }
    }

    public static void close(PreparedStatement ps, ResultSet ... rs) {
        ResultSet[] resultSetArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            ResultSet c = resultSetArray[n2];
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception ex) {
                    MaryUtils.getLogger(FileUtils.class.getName()).log((Priority)Level.WARN, (Object)"Couldn't close ResultSet.", (Throwable)ex);
                }
            }
            ++n2;
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception ex) {
                MaryUtils.getLogger(FileUtils.class.getName()).log((Priority)Level.WARN, (Object)"Couldn't close PreparedStatement.", (Throwable)ex);
            }
        }
    }

    public static void close(Closeable ... closeables) {
        Closeable[] closeableArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            Closeable c = closeableArray[n2];
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception ex) {
                    MaryUtils.getLogger(FileUtils.class.getName()).log((Priority)Level.WARN, (Object)"Couldn't close Closeable.", (Throwable)ex);
                }
            }
            ++n2;
        }
    }

    public static String[] listBasenames(File directory, String suffix) {
        final String theSuffix = suffix;
        Object[] filenames = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(theSuffix);
            }
        });
        Arrays.sort(filenames);
        int i = 0;
        while (i < filenames.length) {
            filenames[i] = ((String)filenames[i]).substring(0, ((String)filenames[i]).length() - suffix.length());
            ++i;
        }
        return filenames;
    }

    @Deprecated
    public static String getFileAsString(File file, String encoding) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            String string = FileUtils.getStreamAsString(fis, encoding);
            return string;
        }
    }

    @Deprecated
    public static String getStreamAsString(InputStream inputStream, String encoding) throws IOException {
        return FileUtils.getReaderAsString(new InputStreamReader(inputStream, encoding));
    }

    public static String getReaderAsString(Reader reader) throws IOException {
        int n;
        StringWriter sw = new StringWriter();
        BufferedReader in = new BufferedReader(reader);
        char[] buf = new char[8192];
        while ((n = in.read(buf)) > 0) {
            sw.write(buf, 0, n);
        }
        return sw.toString();
    }

    public static byte[] getFileAsBytes(String filename) throws IOException {
        return FileUtils.getFileAsBytes(new File(filename));
    }

    public static byte[] getFileAsBytes(File file) throws IOException {
        byte[] byArray;
        long length;
        FileInputStream is;
        block5: {
            is = null;
            is = new FileInputStream(file);
            length = file.length();
            if (length <= Integer.MAX_VALUE) break block5;
            FileUtils.close(is);
            return null;
        }
        try {
            byte[] bytes = new byte[(int)length];
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < bytes.length) {
                throw new IOException("Could not read file " + file.getName());
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            FileUtils.close(is);
            throw throwable;
        }
        FileUtils.close(is);
        return byArray;
    }

    public static void writeToTextFile(double[] array, String textFile) {
        block6: {
            FileWriter outFile = null;
            PrintWriter out = null;
            try {
                try {
                    outFile = new FileWriter(textFile);
                    out = new PrintWriter(outFile);
                    int i = 0;
                    while (i < array.length) {
                        out.println(String.valueOf(array[i]));
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Error! Cannot create file: " + textFile);
                    FileUtils.close(outFile, out);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(outFile, out);
                throw throwable;
            }
            FileUtils.close(outFile, out);
        }
    }

    public static void writeBinaryFile(short[] x, String filename) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(filename)));
        d.writeInt(x.length);
        FileUtils.writeBinaryFile(x, d);
    }

    public static void writeBinaryFile(short[] x, DataOutputStream d) throws IOException {
        int i = 0;
        while (i < x.length) {
            d.writeShort(x[i]);
            ++i;
        }
    }

    public static void writeBinaryFile(float[] x, String filename) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(filename)));
        d.writeInt(x.length);
        FileUtils.writeBinaryFile(x, d);
    }

    public static void writeBinaryFile(float[] x, DataOutputStream d) throws IOException {
        int i = 0;
        while (i < x.length) {
            d.writeFloat(x[i]);
            ++i;
        }
    }

    public static void writeBinaryFile(double[] x, String filename) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(filename)));
        d.writeInt(x.length);
        FileUtils.writeBinaryFile(x, d);
    }

    public static void writeBinaryFile(double[] x, DataOutputStream d) throws IOException {
        int i = 0;
        while (i < x.length) {
            d.writeDouble(x[i]);
            ++i;
        }
    }

    public static void writeBinaryFile(int[] x, String filename) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(filename)));
        d.writeInt(x.length);
        FileUtils.writeBinaryFile(x, d);
    }

    public static void writeBinaryFile(int[] x, DataOutputStream d) throws IOException {
        int i = 0;
        while (i < x.length) {
            d.writeInt(x[i]);
            ++i;
        }
    }

    public static int[] readFromBinaryFile(String filename) throws IOException {
        int[] nArray;
        DataInputStream d = null;
        try {
            d = new DataInputStream(new FileInputStream(new File(filename)));
            int[] x = null;
            int len = d.readInt();
            if (len > 0) {
                x = new int[len];
                int i = 0;
                while (i < len) {
                    x[i] = d.readInt();
                    ++i;
                }
            }
            nArray = x;
        }
        catch (Throwable throwable) {
            FileUtils.close(d);
            throw throwable;
        }
        FileUtils.close(d);
        return nArray;
    }

    public static boolean exists(String file) {
        File f;
        boolean bRet = false;
        if (file != null && (f = new File(file)).exists()) {
            bRet = true;
        }
        return bRet;
    }

    public static void delete(String file, boolean bDisplayInfo) {
        boolean bRet = false;
        File f = new File(file);
        if (f.exists()) {
            bRet = f.delete();
        }
        if (!bRet) {
            System.out.println("Unable to delete file: " + file);
        } else if (bDisplayInfo) {
            System.out.println("Deleted: " + file);
        }
    }

    public static void delete(String file) {
        if (FileUtils.exists(file)) {
            FileUtils.delete(file, false);
        }
    }

    public static void delete(String[] files, boolean bDisplayInfo) {
        int i = 0;
        while (i < files.length) {
            FileUtils.delete(files[i], bDisplayInfo);
            ++i;
        }
    }

    public static void delete(String[] files) {
        FileUtils.delete(files, false);
    }

    public static void copy(String sourceFile, String destinationFile) throws IOException {
        File dir;
        File fromFile = new File(sourceFile);
        File toFile = new File(destinationFile);
        if (!fromFile.exists()) {
            throw new IOException("FileCopy: no such source file: " + sourceFile);
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + sourceFile);
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + sourceFile);
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        if (toFile.exists() && !toFile.canWrite()) {
            throw new IOException("FileCopy: destination file cannot be written: " + destinationFile);
        }
        String parent = toFile.getParent();
        if (parent == null) {
            parent = System.getProperty("user.dir");
        }
        if (!(dir = new File(parent)).exists()) {
            throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
        }
        if (dir.isFile()) {
            throw new IOException("FileCopy: destination is not a directory: " + parent);
        }
        if (!dir.canWrite()) {
            throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(from, to);
            throw throwable;
        }
        FileUtils.close(from, to);
    }

    public static void copy(File source, File dest) throws IOException {
        FileChannel in = null;
        FileChannel out = null;
        try {
            try {
                System.out.println("copying: " + source + "\n    --> " + dest);
                in = new FileInputStream(source).getChannel();
                out = new FileOutputStream(dest).getChannel();
                MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, in.size());
                out.write(buf);
            }
            catch (Exception e) {
                System.out.println("Error copying file " + source.getAbsolutePath() + " to " + dest.getAbsolutePath() + " : " + e.getMessage());
                throw new IOException();
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in, out);
            throw throwable;
        }
        FileUtils.close(in, out);
    }

    public static void copyFolder(String sourceFolder, String targetFolder) throws IOException {
        FileUtils.copyFolder(sourceFolder, targetFolder, false);
    }

    public static void copyFolder(String sourceFolder, String targetFolder, boolean bForceDeleteTarget) throws IOException {
        if (FileUtils.exists(sourceFolder)) {
            if (FileUtils.exists(targetFolder) && bForceDeleteTarget) {
                FileUtils.delete(targetFolder);
            }
            FileUtils.createDirectory(targetFolder);
            if (FileUtils.exists(targetFolder)) {
                String[] fileList = FileUtils.getFileList(sourceFolder, "*.*");
                if (fileList != null) {
                    int i = 0;
                    while (i < fileList.length) {
                        String targetFile = String.valueOf(StringUtils.checkLastSlash(targetFolder)) + StringUtils.getFileName(fileList[i], false);
                        FileUtils.copy(fileList[i], targetFile);
                        ++i;
                    }
                }
            } else {
                System.out.println("Could not create target folder!");
            }
        } else {
            System.out.println("Source folder does not exist!");
        }
    }

    public static void copyFolderRecursive(String sourceFolder, String targetFolder, boolean bForceDeleteTarget) throws IOException {
        System.getProperty("file.separator");
        if (FileUtils.exists(sourceFolder)) {
            if (FileUtils.exists(targetFolder) && bForceDeleteTarget) {
                FileUtils.delete(targetFolder);
            }
            FileUtils.createDirectory(targetFolder);
            if (FileUtils.exists(targetFolder)) {
                String[] fileList = new File(sourceFolder).list();
                if (fileList != null) {
                    int i = 0;
                    while (i < fileList.length) {
                        if (!fileList[i].startsWith(".")) {
                            String source = String.valueOf(StringUtils.checkLastSlash(sourceFolder)) + fileList[i];
                            if (new File(source).isDirectory()) {
                                String newTargetFolder = String.valueOf(StringUtils.checkLastSlash(targetFolder)) + fileList[i];
                                FileUtils.copyFolderRecursive(source, newTargetFolder, bForceDeleteTarget);
                            } else {
                                String targetFile = String.valueOf(StringUtils.checkLastSlash(targetFolder)) + fileList[i];
                                FileUtils.copy(source, targetFile);
                            }
                        }
                        ++i;
                    }
                }
            } else {
                System.out.println("Could not create target folder!");
            }
        } else {
            System.out.println("Source folder does not exist!");
        }
    }

    public static void createDirectory(String trainingBaseFolder) {
        File f = new File(trainingBaseFolder);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static boolean isDirectory(String dirName) {
        File f = new File(dirName);
        return f.isDirectory();
    }

    public static void rename(String existingFile, String newFilename) {
        if (FileUtils.exists(existingFile)) {
            File oldFile = new File(existingFile);
            oldFile.renameTo(new File(newFilename));
        }
    }

    public static void changeFileExtensions(String folder, String oldExt, String newExt) {
        String[] files = FileUtils.getFileNameList(folder, oldExt);
        folder = StringUtils.checkLastSlash(folder);
        newExt = StringUtils.checkFirstDot(newExt);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                int ind = files[i].lastIndexOf(oldExt);
                String newFile = String.valueOf(folder) + files[i].substring(0, ind) + newExt;
                FileUtils.rename(files[i], newFile);
                System.out.println("Changed extension " + String.valueOf(i + 1) + " of " + String.valueOf(files.length));
                ++i;
            }
        }
    }

    public static String getFileName(String fileNameWithPath) {
        int i = fileNameWithPath.lastIndexOf("/");
        String str = fileNameWithPath.substring(i + 1);
        return str;
    }

    public static String[] getFileNameList(String directory, String extension) {
        return FileUtils.getFileNameList(directory, extension, true);
    }

    public static String[] getFileNameList(String directory, String extension, boolean recurse) {
        File[] files = FileUtils.listFilesAsArray(new File(directory), new FileFilter(extension), recurse);
        String[] fileList = null;
        if (files != null && files.length > 0) {
            fileList = new String[files.length];
            int i = 0;
            while (i < files.length) {
                fileList[i] = files[i].getName();
                ++i;
            }
        }
        return fileList;
    }

    public static String[] getFileList(String directory, String extension) {
        return FileUtils.getFileList(directory, extension, true);
    }

    public static String[] getFileList(String directory, String extension, boolean recurse) {
        File[] files = FileUtils.listFilesAsArray(new File(directory), new FileFilter(extension), recurse);
        String[] fileList = null;
        if (files != null && files.length > 0) {
            fileList = new String[files.length];
            int i = 0;
            while (i < files.length) {
                fileList[i] = files[i].getAbsolutePath();
                ++i;
            }
        }
        return fileList;
    }

    public static File[] listFilesAsArray(File directory, FilenameFilter filter, boolean recurse) {
        Collection<File> files = FileUtils.listFiles(directory, filter, recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    public static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        Vector<File> files = new Vector<File>();
        File[] fileArray = entries = directory.listFiles();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (recurse && entry.isDirectory()) {
                files.addAll(FileUtils.listFiles(entry, filter, recurse));
            }
            ++n2;
        }
        return files;
    }

    public static void writeTextFile(String[][] textInRows, String textFile) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(textFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            int n = 0;
            while (n < textInRows.length) {
                String line = "";
                int i = 0;
                while (i < textInRows[n].length) {
                    line = String.valueOf(line) + textInRows[n][i] + " ";
                    ++i;
                }
                out.println(line);
                ++n;
            }
            out.close();
        } else {
            System.out.println("Error! Cannot create file: " + textFile);
        }
    }

    public static void writeTextFile(String[] textInRows, String textFile) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(textFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            int i = 0;
            while (i < textInRows.length) {
                out.println(textInRows[i]);
                ++i;
            }
            out.close();
        } else {
            System.out.println("Error! Cannot create file: " + textFile);
        }
    }

    public static void writeTextFile(Vector<String> textInRows, String textFile) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(textFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            int i = 0;
            while (i < textInRows.size()) {
                out.println(textInRows.get(i));
                ++i;
            }
            out.close();
        } else {
            System.out.println("Error! Cannot create file: " + textFile);
        }
    }

    public static void writeTextFile(float[] x, String filename) {
        FileUtils.writeTextFile(StringUtils.toStringLines(x), filename);
    }

    public static void writeTextFile(double[] x, String filename) {
        FileUtils.writeTextFile(StringUtils.toStringLines(x), filename);
    }

    public static void writeTextFile(double[][] x, String filename) {
        String[][] lines = new String[x.length][];
        int i = 0;
        while (i < x.length) {
            lines[i] = StringUtils.toStringLines(x[i]);
            ++i;
        }
        FileUtils.writeTextFile(lines, filename);
    }

    public static void writeTextFile(int[] x, String filename) {
        FileUtils.writeTextFile(StringUtils.toStringLines(x), filename);
    }

    public static void unzipArchive(File archive, File outputDir) throws IOException {
        ZipFile zipfile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            FileUtils.unzipEntry(zipfile, entry, outputDir);
        }
    }

    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            FileUtils.createDir(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            FileUtils.createDir(outputFile.getParentFile());
        }
        BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    private static void createDir(File dir) throws IOException {
        if (!dir.mkdirs()) {
            throw new IOException("Can not create dir " + dir);
        }
    }
}

