/**
 * Copyright 2009 DFKI GmbH.
 * All Rights Reserved.  Use is subject to license terms.
 *
 * This file is part of MARY TTS.
 *
 * MARY TTS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 * LicensePanel.java
 *
 * Created on 17. November 2009, 12:21
 */

package marytts.tools.install;

import java.io.IOException;
import java.net.URL;
import java.util.SortedSet;

/**
 *
 * @author marc
 */
public class LicensePanel extends javax.swing.JPanel {

	/**
	 * Creates new form LicensePanel
	 * 
	 * @param licenseURL
	 *            licenseURL
	 * @param comps
	 *            comps
	 */
	public LicensePanel(URL licenseURL, SortedSet<ComponentDescription> comps) {
		initComponents();
		StringBuilder sb = new StringBuilder();
		boolean isSingle = (comps.size() == 1);
		sb.append("The component");
		if (isSingle) {
			sb.append("s");
		}
		sb.append(":\n");
		boolean isFirst = true;
		for (ComponentDescription cd : comps) {
			if (!isFirst) {
				sb.append(", ");
			}
			sb.append(cd.getName());
			isFirst = false;
		}
		sb.append("\n");
		sb.append(isSingle ? "is" : "are");
		sb.append(" governed by the following license.");
		questionText.setText(sb.toString());

		try {
			licenseTextPane.setPage(licenseURL);
		} catch (IOException ioe) {
			licenseTextPane
					.setText("Unknown license -- only proceed if you are certain you have the right to install these components!");
			ioe.printStackTrace();
		}

	}

	/**
	 * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of
	 * this method is always regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
	private void initComponents() {
		questionText = new javax.swing.JLabel();
		jScrollPane1 = new javax.swing.JScrollPane();
		licenseTextPane = new javax.swing.JTextPane();

		jScrollPane1.setViewportView(licenseTextPane);

		org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
		this.setLayout(layout);
		layout.setHorizontalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
				org.jdesktop.layout.GroupLayout.TRAILING,
				layout.createSequentialGroup()
						.addContainerGap()
						.add(layout
								.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
								.add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1,
										org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 462, Short.MAX_VALUE)
								.add(org.jdesktop.layout.GroupLayout.LEADING, questionText,
										org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 462, Short.MAX_VALUE)).addContainerGap()));
		layout.setVerticalGroup(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
				layout.createSequentialGroup()
						.addContainerGap()
						.add(questionText, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 58,
								org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
						.addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
						.add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 460, Short.MAX_VALUE).addContainerGap()));
	}// </editor-fold>//GEN-END:initComponents

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JTextPane licenseTextPane;
	private javax.swing.JLabel questionText;
	// End of variables declaration//GEN-END:variables

}
