/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart;

import java.util.ArrayList;
import java.util.List;
import marytts.cart.Node;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;

public abstract class LeafNode
extends Node {
    protected int uniqueLeafId;

    public LeafNode() {
        this.isRoot = false;
    }

    @Override
    public boolean isLeafNode() {
        return true;
    }

    @Override
    public int getNumberOfNodes() {
        return 1;
    }

    public void setUniqueLeafId(int id) {
        this.uniqueLeafId = id;
    }

    public int getUniqueLeafId() {
        return this.uniqueLeafId;
    }

    public String toString() {
        return "id" + this.uniqueLeafId;
    }

    public abstract boolean isEmpty();

    @Override
    public abstract int getNumberOfData();

    @Override
    public abstract Object getAllData();

    @Override
    protected abstract void fillData(Object var1, int var2, int var3);

    public abstract LeafType getLeafNodeType();

    public static class FeatureVectorLeafNode
    extends LeafNode {
        private FeatureVector[] featureVectors;
        private List<FeatureVector> featureVectorList;
        private boolean growable;

        public FeatureVectorLeafNode(FeatureVector[] featureVectors) {
            this.featureVectors = featureVectors;
            this.growable = false;
        }

        public FeatureVectorLeafNode() {
            this.featureVectorList = new ArrayList<FeatureVector>();
            this.featureVectors = null;
            this.growable = true;
        }

        public void addFeatureVector(FeatureVector fv) {
            this.featureVectorList.add(fv);
        }

        public FeatureVector[] getFeatureVectors() {
            if (this.growable && (this.featureVectors == null || this.featureVectors.length == 0)) {
                this.featureVectors = this.featureVectorList.toArray(new FeatureVector[this.featureVectorList.size()]);
            }
            return this.featureVectors;
        }

        public void setFeatureVectors(FeatureVector[] fv) {
            this.featureVectors = fv;
        }

        @Override
        public Object getAllData() {
            if (this.growable && (this.featureVectors == null || this.featureVectors.length == 0)) {
                this.featureVectors = this.featureVectorList.toArray(new FeatureVector[this.featureVectorList.size()]);
            }
            return this.featureVectors;
        }

        @Override
        protected void fillData(Object target, int pos, int len) {
            if (!(target instanceof FeatureVector[])) {
                throw new IllegalArgumentException("Expected target object of type FeatureVector[], got " + target.getClass());
            }
            FeatureVector[] array = (FeatureVector[])target;
            assert (len <= this.featureVectors.length);
            System.arraycopy(this.featureVectors, 0, array, pos, len);
        }

        @Override
        public int getNumberOfData() {
            if (this.growable) {
                return this.featureVectorList.size();
            }
            if (this.featureVectors != null) {
                return this.featureVectors.length;
            }
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return this.featureVectors == null || this.featureVectors.length == 0;
        }

        @Override
        public LeafType getLeafNodeType() {
            return LeafType.FeatureVectorLeafNode;
        }

        @Override
        public String toString() {
            if (this.growable) {
                return "fv[" + this.featureVectorList.size() + "]";
            }
            if (this.featureVectors == null) {
                return String.valueOf(super.toString()) + "(fv[null])";
            }
            return String.valueOf(super.toString()) + "(fv[" + this.featureVectors.length + "])";
        }
    }

    public static class FloatLeafNode
    extends LeafNode {
        private float[] data;

        public FloatLeafNode(float[] data) {
            if (data.length != 2) {
                throw new IllegalArgumentException("data must have length 2, found " + data.length);
            }
            this.data = data;
        }

        @Override
        public Object getAllData() {
            return this.data;
        }

        public int getDataLength() {
            return this.data.length;
        }

        public float getMean() {
            return this.data[1];
        }

        public float getStDeviation() {
            return this.data[0];
        }

        @Override
        protected void fillData(Object target, int pos, int len) {
            throw new IllegalStateException("This method should not be called for FloatLeafNodes");
        }

        @Override
        public int getNumberOfData() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public LeafType getLeafNodeType() {
            return LeafType.FloatLeafNode;
        }

        @Override
        public String toString() {
            if (this.data == null) {
                return String.valueOf(super.toString()) + "(mean=null, stddev=null)";
            }
            return String.valueOf(super.toString()) + "(mean=" + this.data[1] + ", stddev=" + this.data[0] + ")";
        }
    }

    public static class IntAndFloatArrayLeafNode
    extends IntArrayLeafNode {
        protected float[] floats;

        public IntAndFloatArrayLeafNode(int[] data, float[] floats) {
            super(data);
            this.floats = floats;
        }

        public float[] getFloatData() {
            return this.floats;
        }

        public int mostProbableInt() {
            int bestInd = 0;
            float maxProb = 0.0f;
            int i = 0;
            while (i < this.data.length) {
                if (this.floats[i] > maxProb) {
                    maxProb = this.floats[i];
                    bestInd = this.data[i];
                }
                ++i;
            }
            return bestInd;
        }

        public void eraseData(int target) {
            int[] newData = new int[this.data.length - 1];
            float[] newFloats = new float[this.floats.length - 1];
            int index = 0;
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] != target) {
                    newData[index] = this.data[i];
                    newFloats[index] = this.floats[i];
                    ++index;
                }
                ++i;
            }
            this.data = newData;
            this.floats = newFloats;
        }

        @Override
        public LeafType getLeafNodeType() {
            return LeafType.IntAndFloatArrayLeafNode;
        }

        @Override
        public String toString() {
            if (this.data == null) {
                return String.valueOf(super.toString()) + "(int and floats[null])";
            }
            return String.valueOf(super.toString()) + "(int and floats[" + this.data.length + "])";
        }
    }

    public static class IntArrayLeafNode
    extends LeafNode {
        protected int[] data;

        public IntArrayLeafNode(int[] data) {
            this.data = data;
        }

        @Override
        public Object getAllData() {
            return this.data;
        }

        public int[] getIntData() {
            return this.data;
        }

        @Override
        protected void fillData(Object target, int pos, int len) {
            if (!(target instanceof int[])) {
                throw new IllegalArgumentException("Expected target object of type int[], got " + target.getClass());
            }
            int[] array = (int[])target;
            assert (len <= this.data.length);
            System.arraycopy(this.data, 0, array, pos, len);
        }

        @Override
        public int getNumberOfData() {
            if (this.data != null) {
                return this.data.length;
            }
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return this.data == null || this.data.length == 0;
        }

        @Override
        public LeafType getLeafNodeType() {
            return LeafType.IntArrayLeafNode;
        }

        @Override
        public String toString() {
            if (this.data == null) {
                return String.valueOf(super.toString()) + "(int[null])";
            }
            return String.valueOf(super.toString()) + "(int[" + this.data.length + "])";
        }
    }

    public static enum LeafType {
        IntArrayLeafNode,
        FloatLeafNode,
        IntAndFloatArrayLeafNode,
        StringAndFloatLeafNode,
        FeatureVectorLeafNode,
        PdfLeafNode;

    }

    public static class PdfLeafNode
    extends LeafNode {
        private int vectorSize;
        private double[] mean;
        private double[] variance;
        private double voicedWeight;

        public PdfLeafNode(int idx, double[][] pdf) throws MaryConfigurationException {
            this.setUniqueLeafId(idx);
            if (pdf != null) {
                int nstream = pdf.length;
                if (nstream == 1) {
                    int vsize;
                    this.vectorSize = vsize = pdf[0].length / 2;
                    this.mean = new double[vsize];
                    int i = 0;
                    int j = 0;
                    while (j < vsize) {
                        this.mean[i] = pdf[0][j];
                        ++i;
                        ++j;
                    }
                    this.variance = new double[vsize];
                    i = 0;
                    j = vsize;
                    while (j < 2 * vsize) {
                        this.variance[i] = pdf[0][j];
                        ++i;
                        ++j;
                    }
                } else {
                    this.vectorSize = nstream;
                    this.mean = new double[nstream];
                    this.variance = new double[nstream];
                    int stream = 0;
                    while (stream < nstream) {
                        this.mean[stream] = pdf[stream][0];
                        this.variance[stream] = pdf[stream][1];
                        if (stream == 0) {
                            this.voicedWeight = pdf[stream][2];
                        }
                        ++stream;
                    }
                }
            } else {
                throw new MaryConfigurationException("PdfLeafNode: pdf vector is null for index=" + idx);
            }
        }

        public int getDataLength() {
            return this.mean.length;
        }

        public double[] getMean() {
            return this.mean;
        }

        public double[] getVariance() {
            return this.variance;
        }

        public double getVoicedWeight() {
            return this.voicedWeight;
        }

        public int getVectorSize() {
            return this.vectorSize;
        }

        @Override
        protected void fillData(Object target, int pos, int len) {
            throw new IllegalStateException("This method should not be called for PdfLeafNodes");
        }

        @Override
        public Object getAllData() {
            return null;
        }

        @Override
        public int getNumberOfData() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public LeafType getLeafNodeType() {
            return LeafType.PdfLeafNode;
        }

        @Override
        public String toString() {
            if (this.mean == null) {
                return String.valueOf(super.toString()) + "(mean=null, stddev=null)";
            }
            return String.valueOf(super.toString()) + "(mean=[" + this.vectorSize + "], stddev=[" + this.vectorSize + "])";
        }
    }

    public static class StringAndFloatLeafNode
    extends IntAndFloatArrayLeafNode {
        public StringAndFloatLeafNode(int[] data, float[] floats) {
            super(data, floats);
        }

        public String mostProbableString(FeatureDefinition featureDefinition, int featureIndex) {
            int bestInd = this.mostProbableInt();
            return featureDefinition.getFeatureValueAsString(featureIndex, bestInd);
        }

        @Override
        public String toString() {
            if (this.data == null) {
                return String.valueOf(super.toString()) + "(string and floats[null])";
            }
            return String.valueOf(super.toString()) + "(string and floats[" + this.data.length + "])";
        }

        @Override
        public LeafType getLeafNodeType() {
            return LeafType.StringAndFloatLeafNode;
        }
    }
}

