/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import emotionml.Checker;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.InternalModule;
import marytts.util.MaryUtils;
import marytts.util.dom.LoggingErrorHandler;
import org.w3c.dom.Document;

public class EmotionmlParser
extends InternalModule {
    private static Templates stylesheet = null;
    private DocumentBuilderFactory dbFactory = null;
    private DocumentBuilder docBuilder = null;
    private boolean doWarnClient = false;

    public EmotionmlParser() {
        super("EmotionmlParser", MaryDataType.EMOTIONML, MaryDataType.RAWMARYXML, null);
    }

    public boolean getWarnClient() {
        return this.doWarnClient;
    }

    public void setWarnClient(boolean doWarnClient) {
        this.doWarnClient = doWarnClient;
    }

    @Override
    public void startup() throws Exception {
        this.setWarnClient(true);
        if (stylesheet == null) {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesheetStream = new StreamSource(this.getClass().getResourceAsStream("emotionml-to-maryxml.xsl"));
            stylesheet = tFactory.newTemplates(stylesheetStream);
        }
        if (this.dbFactory == null) {
            this.dbFactory = DocumentBuilderFactory.newInstance();
        }
        if (this.docBuilder == null) {
            this.docBuilder = this.dbFactory.newDocumentBuilder();
        }
        super.startup();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document emotionml = d.getDocument();
        Checker emotionmlChecker = new Checker();
        emotionmlChecker.validate(emotionml);
        DOMSource domSource = new DOMSource(emotionml);
        Transformer transformer = stylesheet.newTransformer();
        if (this.doWarnClient) {
            transformer.setErrorListener((ErrorListener)new LoggingErrorHandler(String.valueOf(Thread.currentThread().getName()) + " client.EmotionML transformer"));
        }
        transformer.setParameter("voice", d.getDefaultVoice().getName());
        Document maryxmlDocument = this.docBuilder.newDocument();
        DOMResult domResult = new DOMResult(maryxmlDocument);
        transformer.transform(domSource, domResult);
        maryxmlDocument.getDocumentElement().setAttribute("xml:lang", MaryUtils.locale2xmllang((Locale)d.getLocale()));
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setDocument(maryxmlDocument);
        return result;
    }
}

