/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.StringReader;
import java.util.Locale;
import javax.sound.sampled.AudioFileFormat;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.MaryModule;
import marytts.modules.synthesis.Voice;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class InternalModule
implements MaryModule {
    private String name = null;
    private MaryDataType inputType = null;
    private MaryDataType outputType = null;
    private Locale locale = null;
    protected int state;
    protected Logger logger;

    protected InternalModule(String name, MaryDataType inputType, MaryDataType outputType, Locale locale) {
        this.name = name;
        this.inputType = inputType;
        this.outputType = outputType;
        this.locale = locale;
        this.logger = MaryUtils.getLogger((String)this.name());
        this.state = 0;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Deprecated
    public MaryDataType inputType() {
        return this.getInputType();
    }

    @Override
    public MaryDataType getInputType() {
        return this.inputType;
    }

    @Override
    @Deprecated
    public MaryDataType outputType() {
        return this.getOutputType();
    }

    @Override
    public MaryDataType getOutputType() {
        return this.outputType;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void startup() throws Exception {
        assert (this.state == 0);
        this.logger.info((Object)("Module started (" + this.inputType() + "->" + this.outputType() + ", locale " + this.getLocale() + ")."));
        this.state = 1;
    }

    @Override
    public void powerOnSelfTest() throws Error {
        assert (this.state == 1);
        this.logger.info((Object)"Starting power-on self test.");
        try {
            MaryData in = new MaryData(this.inputType, this.getLocale());
            String example = this.inputType.exampleText(this.getLocale());
            if (example != null) {
                in.readFrom(new StringReader(example));
                if (this.outputType.equals(MaryDataType.get("AUDIO"))) {
                    in.setAudioFileFormat(new AudioFileFormat(AudioFileFormat.Type.WAVE, Voice.AF22050, -1));
                }
                this.process(in);
            } else {
                this.logger.debug((Object)"No example text -- no power-on self test!");
            }
        }
        catch (Throwable t) {
            throw new Error("Module " + this.name + ": Power-on self test failed.", t);
        }
        this.logger.info((Object)"Power-on self test complete.");
    }

    @Override
    public void shutdown() {
        this.logger = MaryUtils.getLogger((String)this.name());
        this.logger.info((Object)"Module shut down.");
        this.state = 0;
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        return d;
    }
}

