/*
 * Decompiled with CFR 0.152.
 */
package marytts.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.xml.transform.TransformerException;
import marytts.datatypes.MaryDataType;
import marytts.server.Request;
import marytts.server.http.MaryHttpServerUtils;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.io.LoggingReader;
import org.apache.http.HttpResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.xml.sax.SAXParseException;

public class RequestHandler
extends Thread {
    private Request request;
    private Socket infoSocket;
    private Socket dataSocket;
    private LoggingReader inputReader;
    private Logger logger;
    private Logger clientLogger;

    public RequestHandler(Request request, Socket infoSocket, Socket dataSocket, Reader inputReader) {
        if (request == null) {
            throw new NullPointerException("Cannot handle null request");
        }
        this.request = request;
        if (infoSocket == null) {
            throw new NullPointerException("Received null infoSocket");
        }
        this.infoSocket = infoSocket;
        if (dataSocket == null) {
            throw new NullPointerException("Received null dataSocket");
        }
        this.dataSocket = dataSocket;
        this.setName("RH " + request.getId());
        this.logger = MaryUtils.getLogger((String)this.getName());
        this.inputReader = new LoggingReader(inputReader, this.logger);
        this.clientLogger = MaryUtils.getLogger((String)(String.valueOf(this.getName()) + " client"));
        try {
            this.clientLogger.addAppender((Appender)new WriterAppender((Layout)new SimpleLayout(), (Writer)new PrintWriter(infoSocket.getOutputStream(), true)));
            this.clientLogger.setLevel(Level.WARN);
            this.clientLogger.setAdditivity(false);
        }
        catch (IOException e) {
            this.logger.warn((Object)"Cannot write warnings to client", (Throwable)e);
        }
    }

    private void clientLogWarning(String message, Exception e) {
        if (this.clientLogger != null && !(e instanceof TransformerException) && !(e instanceof SAXParseException)) {
            this.clientLogger.warn((Object)(String.valueOf(message) + "\n" + e.toString()));
        }
    }

    private void clientLogError(String message, Throwable e) {
        if (this.clientLogger != null && !(e instanceof TransformerException) && !(e instanceof SAXParseException)) {
            this.clientLogger.error((Object)(String.valueOf(message) + "\n" + MaryUtils.getThrowableAndCausesAsString((Throwable)e)));
        }
    }

    @Override
    public void run() {
        String message;
        boolean ok = true;
        try {
            this.request.readInputData((Reader)this.inputReader);
        }
        catch (Exception e) {
            String message2 = "Problem reading input";
            this.logger.warn((Object)message2, (Throwable)e);
            this.clientLogWarning(message2, e);
            ok = false;
        }
        boolean streamingOutput = false;
        Thread rw = null;
        if (ok) {
            try {
                if (this.request.getOutputType().equals(MaryDataType.get("AUDIO")) && this.request.getStreamAudio()) {
                    streamingOutput = true;
                    rw = new StreamingOutputWriter(this.request, this.dataSocket.getOutputStream());
                    rw.start();
                }
                this.request.process();
            }
            catch (Throwable e) {
                message = "Processing failed.";
                this.logger.error((Object)message, e);
                this.clientLogError(message, e);
                ok = false;
            }
        }
        try {
            if (this.clientLogger != null) {
                this.clientLogger.removeAllAppenders();
                this.clientLogger = null;
            }
            this.infoSocket.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)"Couldn't close info socket properly.", (Throwable)e);
            ok = false;
        }
        if (ok) {
            if (!streamingOutput) {
                try {
                    this.request.writeOutputData(this.dataSocket.getOutputStream());
                }
                catch (Exception e) {
                    message = "Cannot write output, client seems to have disconnected.";
                    this.logger.warn((Object)message, (Throwable)e);
                    ok = false;
                }
            } else {
                try {
                    rw.join();
                }
                catch (InterruptedException ie) {
                    this.logger.warn((Object)ie);
                }
            }
        }
        try {
            this.dataSocket.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)"Couldn't close data socket properly.", (Throwable)e);
            ok = false;
        }
        if (ok) {
            this.logger.info((Object)"Request handled successfully.");
        } else {
            this.logger.info((Object)"Request couldn't be handled successfully.");
        }
        if (MaryRuntimeUtils.lowMemoryCondition()) {
            this.logger.info((Object)("Low memory condition detected (only " + MaryUtils.availableMemory() + " bytes left). Triggering garbage collection."));
            Runtime.getRuntime().gc();
            this.logger.info((Object)("After garbage collection: " + MaryUtils.availableMemory() + " bytes available."));
        }
    }

    public static class StreamingOutputPiper
    extends Thread {
        private InputStream input;
        private Logger logger = null;
        private BufferedWriter textWriter = null;
        private FileOutputStream binaryWriter = null;
        private HttpResponse response = null;
        private String contentType = null;

        public StreamingOutputPiper(InputStream input) throws Exception {
            this.input = input;
            this.logger = MaryUtils.getLogger((String)this.getName());
            this.textWriter = null;
            this.binaryWriter = null;
            this.response = null;
            this.contentType = null;
        }

        public StreamingOutputPiper(InputStream input, String outTextFile) throws Exception {
            this.input = input;
            this.logger = null;
            this.textWriter = new BufferedWriter(new FileWriter(outTextFile));
            this.binaryWriter = null;
            this.response = null;
            this.contentType = null;
        }

        public StreamingOutputPiper(InputStream input, File outFile) throws Exception {
            this.input = input;
            this.logger = null;
            this.textWriter = null;
            this.binaryWriter = new FileOutputStream(outFile);
            this.response = null;
            this.contentType = null;
        }

        public StreamingOutputPiper(InputStream input, HttpResponse response, String contentType) throws Exception {
            this.input = input;
            this.logger = null;
            this.textWriter = null;
            this.binaryWriter = null;
            this.response = response;
            this.contentType = contentType;
        }

        @Override
        public void run() {
            block21: {
                try {
                    if (this.logger != null) {
                        int val;
                        while ((val = this.input.read()) != -1) {
                            this.logger.debug((Object)(String.valueOf(val) + System.getProperty("line.separator")));
                        }
                        this.input.close();
                    } else if (this.textWriter != null) {
                        int val;
                        while ((val = this.input.read()) != -1) {
                            this.textWriter.write(val);
                            this.textWriter.newLine();
                        }
                        this.input.close();
                    } else if (this.binaryWriter != null) {
                        int val;
                        while ((val = this.input.read()) != -1) {
                            this.binaryWriter.write((byte)val);
                        }
                        this.input.close();
                    } else if (this.response != null) {
                        MaryHttpServerUtils.toHttpResponse(this.input, this.response, this.contentType);
                    } else {
                        System.out.println("Error: No writers initialised!");
                        this.input.close();
                        return;
                    }
                    String message = "Finished reading output";
                    if (this.logger != null) {
                        this.logger.info((Object)message);
                    } else if (this.textWriter != null) {
                        this.textWriter.write(message);
                        this.textWriter.newLine();
                        this.textWriter.close();
                    } else if (this.binaryWriter != null) {
                        this.binaryWriter.close();
                    }
                }
                catch (IOException ioe) {
                    String message = "Cannot read output, client seems to have disconnected. ";
                    if (this.logger != null) {
                        this.logger.info((Object)message, (Throwable)ioe);
                    }
                    if (this.textWriter == null) break block21;
                    try {
                        this.textWriter.write(message);
                        this.textWriter.newLine();
                    }
                    catch (IOException iOException) {
                        System.out.println("Error: Cannot write to text writer!");
                    }
                }
            }
        }
    }

    public static class StreamingOutputWriter
    extends Thread {
        private Request request;
        private OutputStream output;
        private Logger logger;

        public StreamingOutputWriter(Request request, OutputStream output) throws Exception {
            this.request = request;
            this.output = output;
            this.setName("RW " + request.getId());
            this.logger = MaryUtils.getLogger((String)this.getName());
        }

        @Override
        public void run() {
            try {
                AudioSystem.write((AudioInputStream)this.request.getAudio(), this.request.getAudioFileFormat().getType(), this.output);
                this.output.flush();
                this.output.close();
                this.logger.info((Object)"Finished writing output");
            }
            catch (IOException ioe) {
                this.logger.info((Object)"Cannot write output, client seems to have disconnected. ", (Throwable)ioe);
                this.request.abort();
            }
        }
    }
}

