/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import marytts.util.data.Datagram;

public class MCepDatagram
extends Datagram {
    protected float[] coeffs;

    public MCepDatagram(long setDuration, float[] coeffs) {
        super(setDuration);
        this.coeffs = coeffs;
    }

    public MCepDatagram(RandomAccessFile raf, int order) throws IOException, EOFException {
        super(raf.readLong());
        int len = raf.readInt();
        if (len < 0) {
            throw new IOException("Can't create a datagram with a negative data size [" + len + "].");
        }
        if (len < 4 * order) {
            throw new IOException("Mel-Cepstrum datagram too short (len=" + len + "): cannot be shorter than the space needed for Mel-Cepstrum coefficients (4*" + order + ")");
        }
        byte[] buf = new byte[len];
        raf.readFully(buf);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
        this.coeffs = new float[order];
        int i = 0;
        while (i < order) {
            this.coeffs[i] = dis.readFloat();
            ++i;
        }
    }

    public MCepDatagram(ByteBuffer bb, int order) throws IOException, EOFException {
        super(bb.getLong());
        int len = bb.getInt();
        if (len < 0) {
            throw new IOException("Can't create a datagram with a negative data size [" + len + "].");
        }
        if (len < 4 * order) {
            throw new IOException("Mel-Cepstrum datagram too short (len=" + len + "): cannot be shorter than the space needed for Mel-Cepstrum coefficients (4*" + order + ")");
        }
        this.coeffs = new float[order];
        int i = 0;
        while (i < order) {
            this.coeffs[i] = bb.getFloat();
            ++i;
        }
    }

    public int getLength() {
        return 4 * this.coeffs.length;
    }

    public int order() {
        return this.coeffs.length;
    }

    public float[] getCoeffs() {
        return this.coeffs;
    }

    public double[] getCoeffsAsDouble() {
        double[] ret = new double[this.coeffs.length];
        int i = 0;
        while (i < this.coeffs.length) {
            ret[i] = this.coeffs[i];
            ++i;
        }
        return ret;
    }

    public float getCoeff(int i) {
        return this.coeffs[i];
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.duration);
        out.writeInt(this.getLength());
        int i = 0;
        while (i < this.coeffs.length) {
            out.writeFloat(this.coeffs[i]);
            ++i;
        }
    }

    public boolean equals(Datagram other) {
        if (!(other instanceof MCepDatagram)) {
            return false;
        }
        MCepDatagram otherMCep = (MCepDatagram)other;
        if (this.duration != otherMCep.duration) {
            return false;
        }
        if (this.coeffs.length != otherMCep.coeffs.length) {
            return false;
        }
        int i = 0;
        while (i < this.coeffs.length) {
            if (this.coeffs[i] != otherMCep.coeffs[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

