/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureVector;
import marytts.features.TargetFeatureComputer;
import marytts.server.MaryProperties;
import marytts.signalproc.display.Histogram;
import marytts.unitselection.data.FeatureFileReader;
import marytts.unitselection.data.HalfPhoneFeatureFileReader;
import marytts.unitselection.data.Unit;
import marytts.unitselection.select.FFRTargetCostFunction;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.Target;
import marytts.unitselection.weightingfunctions.WeightFunc;
import marytts.unitselection.weightingfunctions.WeightFunctionManager;
import marytts.util.MaryUtils;

public class HalfPhoneFFRTargetCostFunction
extends FFRTargetCostFunction {
    protected FeatureDefinition leftWeights;
    protected FeatureDefinition rightWeights;
    protected WeightFunc[] leftWeightFunction;
    protected WeightFunc[] rightWeightFunction;

    @Override
    public double cost(Target target, Unit unit) {
        if (!(target instanceof HalfPhoneTarget)) {
            throw new IllegalArgumentException("This target cost function can only be called for half-phone targets!");
        }
        HalfPhoneTarget hpTarget = (HalfPhoneTarget)target;
        boolean isLeftHalf = hpTarget.isLeftHalf();
        FeatureDefinition weights = isLeftHalf ? this.leftWeights : this.rightWeights;
        WeightFunc[] weightFunctions = isLeftHalf ? this.leftWeightFunction : this.rightWeightFunction;
        return this.cost(target, unit, weights, weightFunctions);
    }

    public void load(String featureFileName, String weightsFile, FeatureProcessorManager featProc) throws IOException, MaryConfigurationException {
        HalfPhoneFeatureFileReader ffr = new HalfPhoneFeatureFileReader(featureFileName);
        this.load((FeatureFileReader)ffr, weightsFile, featProc);
    }

    public void load(FeatureFileReader featureFileReader, String weightsFile, FeatureProcessorManager featProc) throws IOException {
        if (!(featureFileReader instanceof HalfPhoneFeatureFileReader)) {
            throw new IllegalArgumentException("Featurefilereader must be a HalfPhoneFeatureFileReader");
        }
        HalfPhoneFeatureFileReader ffr = (HalfPhoneFeatureFileReader)featureFileReader;
        this.featureDefinition = this.leftWeights = ffr.getLeftWeights();
        this.rightWeights = ffr.getRightWeights();
        this.featureVectors = ffr.getFeatureVectors();
        if (weightsFile != null) {
            File rightF;
            MaryUtils.getLogger((String)"TargetCostFeatures").debug((Object)("Overwriting target cost weights from file " + weightsFile));
            String[] weightsFiles = weightsFile.split("\\|");
            if (weightsFiles.length != 2) {
                throw new IllegalArgumentException("Parameter weightsFile should contain exactly two fields separated by a '|' character -- instead, it is: '" + weightsFile + "'");
            }
            File leftF = new File(weightsFiles[0].trim());
            if (weightsFiles[1].indexOf("/") == -1 && weightsFiles[1].indexOf("\\") == -1) {
                File dir = leftF.getParentFile();
                rightF = new File(dir, weightsFiles[1].trim());
            } else {
                rightF = new File(weightsFiles[1].trim());
            }
            FeatureDefinition newLeftWeights = new FeatureDefinition(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(leftF), "UTF-8")), true);
            if (!newLeftWeights.featureEquals(this.leftWeights)) {
                throw new IOException("Weights file '" + leftF + "': feature definition incompatible with feature file");
            }
            this.leftWeights = newLeftWeights;
            FeatureDefinition newRightWeights = new FeatureDefinition(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rightF), "UTF-8")), true);
            if (!newRightWeights.featureEquals(this.rightWeights)) {
                throw new IOException("Weights file '" + rightF + "': feature definition incompatible with feature file");
            }
            this.rightWeights = newRightWeights;
        }
        WeightFunctionManager wfm = new WeightFunctionManager();
        WeightFunc linear2 = wfm.getWeightFunction("linear");
        int nDiscreteFeatures = this.leftWeights.getNumberOfByteFeatures() + this.leftWeights.getNumberOfShortFeatures();
        this.leftWeightFunction = new WeightFunc[this.leftWeights.getNumberOfContinuousFeatures()];
        this.rightWeightFunction = new WeightFunc[this.leftWeightFunction.length];
        int i = 0;
        while (i < this.leftWeightFunction.length) {
            String weightFunctionName = this.leftWeights.getWeightFunctionName(nDiscreteFeatures + i);
            this.leftWeightFunction[i] = "".equals(weightFunctionName) ? linear2 : wfm.getWeightFunction(weightFunctionName);
            weightFunctionName = this.rightWeights.getWeightFunctionName(nDiscreteFeatures + i);
            this.rightWeightFunction[i] = "".equals(weightFunctionName) ? linear2 : wfm.getWeightFunction(weightFunctionName);
            ++i;
        }
        this.targetFeatureComputer = new TargetFeatureComputer(featProc, this.leftWeights.getFeatureNames());
        this.rememberWhichWeightsAreNonZero();
        if (MaryProperties.getBoolean("debug.show.cost.graph")) {
            this.debugShowCostGraph = true;
            this.cumulWeightedCosts = new double[this.featureDefinition.getNumberOfFeatures()];
            TargetCostReporter tcr2 = new TargetCostReporter(this.cumulWeightedCosts);
            tcr2.showInJFrame("Average weighted target costs", false, false);
            tcr2.start();
        }
    }

    @Override
    public void computeTargetFeatures(Target target) {
        FeatureVector fv = this.targetFeatureComputer.computeFeatureVector(target);
        target.setFeatureVector(fv);
    }

    public FeatureVector getUnitFeatures(Unit unit) {
        return this.featureVectors[unit.index];
    }

    @Override
    public String getFeature(Unit unit, String featureName) {
        int featureIndex = this.featureDefinition.getFeatureIndex(featureName);
        if (this.featureDefinition.isByteFeature(featureIndex)) {
            byte value = this.featureVectors[unit.index].getByteFeature(featureIndex);
            return this.featureDefinition.getFeatureValueAsString(featureIndex, value);
        }
        if (this.featureDefinition.isShortFeature(featureIndex)) {
            short value = this.featureVectors[unit.index].getShortFeature(featureIndex);
            return this.featureDefinition.getFeatureValueAsString(featureIndex, value);
        }
        float value = this.featureVectors[unit.index].getContinuousFeature(featureIndex);
        return String.valueOf(value);
    }

    public class TargetCostReporter
    extends Histogram {
        private double[] data;
        private int lastN;

        public TargetCostReporter(double[] data) {
            super(0.0, 1.0, data);
            this.lastN = 0;
            this.data = data;
        }

        public void start() {
            new Thread(){

                @Override
                public void run() {
                    while (TargetCostReporter.this.isVisible()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        TargetCostReporter.this.updateGraph();
                    }
                }
            }.start();
        }

        protected void updateGraph() {
            if (HalfPhoneFFRTargetCostFunction.this.nCostComputations == this.lastN) {
                return;
            }
            this.lastN = HalfPhoneFFRTargetCostFunction.this.nCostComputations;
            double[] newCosts = new double[this.data.length];
            int i = 0;
            while (i < newCosts.length) {
                newCosts[i] = this.data[i] / (double)HalfPhoneFFRTargetCostFunction.this.nCostComputations;
                ++i;
            }
            this.updateData(0.0, 1.0, newCosts);
            this.repaint();
        }
    }
}

