/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import java.util.ArrayList;
import java.util.List;
import marytts.machinelearning.Discretizer;
import marytts.machinelearning.GMM;
import marytts.machinelearning.GMMTrainer;
import marytts.machinelearning.GMMTrainerParams;

public class GmmDiscretizer
implements Discretizer {
    private GMM mixtureModel;
    private boolean extraZero;

    public static GmmDiscretizer trainDiscretizer(List<Integer> values, int nrClasses, boolean extraZero) {
        ArrayList<Integer> retained = new ArrayList<Integer>(values);
        Integer zero = new Integer(0);
        if (extraZero && retained.contains(zero)) {
            int i = 0;
            while (i < retained.size()) {
                if (((Integer)retained.get(i)).equals(zero)) {
                    retained.remove(i);
                    continue;
                }
                ++i;
            }
        }
        double[][] trainingData = new double[retained.size()][1];
        int i = 0;
        while (i < retained.size()) {
            trainingData[i][0] = ((Integer)retained.get(i)).intValue();
            ++i;
        }
        int trainClasses = extraZero ? nrClasses - 1 : nrClasses;
        GMMTrainerParams gmmParams = new GMMTrainerParams();
        gmmParams.totalComponents = trainClasses;
        gmmParams.emMinIterations = 1000;
        gmmParams.emMaxIterations = 2000;
        GMM model = new GMMTrainer().train(trainingData, gmmParams);
        return new GmmDiscretizer(model, extraZero);
    }

    public GmmDiscretizer(GMM model, boolean extraZeroClass) {
        System.out.println("set model with the following components:");
        int i = 0;
        while (i < model.totalComponents) {
            System.out.println("component " + i);
            System.out.println(" mean: " + model.components[i].meanVector[0]);
            System.out.println(" weight: " + model.weights[i]);
            System.out.println(" variance: " + model.components[i].covMatrix[0][0]);
            ++i;
        }
        this.mixtureModel = model;
        this.extraZero = extraZeroClass;
    }

    @Override
    public int discretize(int value) {
        double[] x = new double[]{value};
        double[] probs = this.mixtureModel.componentProbabilities(x);
        if (this.extraZero && value == 0) {
            return 0;
        }
        int maxClass = 0;
        double maxP = 0.0;
        int i = 0;
        while (i < this.mixtureModel.totalComponents) {
            if (probs[i] > maxP) {
                maxClass = i;
                maxP = probs[i];
            }
            ++i;
        }
        int maxClassMean = (int)this.mixtureModel.components[maxClass].meanVector[0];
        return maxClassMean;
    }

    @Override
    public int[] getPossibleValues() {
        if (this.extraZero) {
            int[] retArr = new int[this.mixtureModel.components.length + 1];
            retArr[0] = 0;
            int i = 0;
            while (i < this.mixtureModel.components.length) {
                retArr[i + 1] = (int)this.mixtureModel.components[i].meanVector[0];
                ++i;
            }
            return retArr;
        }
        int[] retArr = new int[this.mixtureModel.components.length];
        int i = 0;
        while (i < this.mixtureModel.components.length) {
            retArr[i] = (int)this.mixtureModel.components[i].meanVector[0];
            ++i;
        }
        return retArr;
    }
}

