/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import marytts.signalproc.analysis.AlignmentData;
import marytts.signalproc.analysis.Labels;
import marytts.util.io.FileUtils;

public class FestivalUtt
extends AlignmentData {
    public Labels[] labels;
    public String[] keys = new String[6];

    public FestivalUtt() {
        this("");
    }

    public FestivalUtt(String festivalUttFile) {
        this.keys[0] = "==Segment==";
        this.keys[1] = "==Target==";
        this.keys[2] = "==Syllable==";
        this.keys[3] = "==Word==";
        this.keys[4] = "==IntEvent==";
        this.keys[5] = "==Phrase==";
        this.labels = new Labels[this.keys.length];
        if (FileUtils.exists((String)festivalUttFile)) {
            this.read(festivalUttFile);
        }
    }

    public void read(String festivalUttFile) {
        String allText = null;
        try {
            allText = FileUtils.getFileAsString((File)new File(festivalUttFile), (String)"ASCII");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (allText != null) {
            int j;
            String[] lines = allText.split("\n");
            int[] boundInds = new int[this.keys.length];
            Arrays.fill(boundInds, -1);
            int i = 0;
            while (i < this.keys.length) {
                j = 0;
                while (j < lines.length) {
                    if (lines[j].compareTo(this.keys[i]) == 0) {
                        boundInds[i] = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.keys.length) {
                if (boundInds[i] > -1) {
                    int fromIndex = boundInds[i] + 1;
                    int toIndex = i < this.keys.length - 1 ? boundInds[i + 1] - 1 : lines.length - 1;
                    this.labels[i] = this.createLabels(lines, fromIndex, toIndex);
                    if (this.keys[i].compareTo("==Target==") == 0) {
                        j = 0;
                        while (j < this.labels[i].items.length) {
                            if (this.labels[i].items[j].valuesRest != null) {
                                double[] tmpValues = new double[this.labels[i].items[j].valuesRest.length];
                                System.arraycopy(this.labels[i].items[j].valuesRest, 0, tmpValues, 0, this.labels[i].items[j].valuesRest.length);
                                this.labels[i].items[j].valuesRest = new double[tmpValues.length + 1];
                                this.labels[i].items[j].valuesRest[0] = Double.valueOf(this.labels[i].items[j].phn);
                                System.arraycopy(this.labels[i].items[j].valuesRest, 0, tmpValues, 1, this.labels[i].items[j].valuesRest.length);
                            } else {
                                this.labels[i].items[j].valuesRest = new double[1];
                                this.labels[i].items[j].valuesRest[0] = Double.valueOf(this.labels[i].items[j].phn);
                            }
                            ++j;
                        }
                    }
                } else {
                    this.labels[i] = null;
                }
                ++i;
            }
        }
    }

    private Labels createLabels(String[] lines, int fromIndex, int toIndex) {
        String[] relevantLines = new String[toIndex - fromIndex + 1];
        System.arraycopy(lines, fromIndex, relevantLines, 0, relevantLines.length);
        Labels l = new Labels(relevantLines, 2);
        return l;
    }

    public static FestivalUtt readFestivalUttFile(String festivalUttFile) {
        FestivalUtt f = new FestivalUtt(festivalUttFile);
        return f;
    }

    public static void main(String[] args) {
        new FestivalUtt("d:/a.utt");
        System.out.println("Test completed...");
    }
}

