/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.EnergyAnalyser_dB;
import marytts.signalproc.display.Histogram;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;

public class EnergyHistogram
extends Histogram {
    public EnergyHistogram(AudioInputStream ais) {
        this(ais, 640, 480);
    }

    public EnergyHistogram(AudioInputStream ais, int width, int height) {
        if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
        }
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono audio signals");
        }
        int samplingRate = (int)ais.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
        this.initialise(signal, samplingRate, width, height);
    }

    public EnergyHistogram(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public EnergyHistogram(double[] signal, int samplingRate, int width, int height) {
        this.initialise(new BufferedDoubleDataSource(signal), samplingRate, width, height);
    }

    protected void initialise(DoubleDataSource signal, int samplingRate, int width, int height) {
        double silenceCutoff_dB;
        double frameDuration = 0.01;
        int frameLength = (int)((double)samplingRate * frameDuration);
        int frameShift = frameLength / 2;
        if (frameLength % 2 == 0) {
            ++frameLength;
        }
        EnergyAnalyser_dB energyAnalyser = new EnergyAnalyser_dB(signal, frameLength, frameShift, samplingRate);
        energyAnalyser.analyseAllFrames();
        double[] histogram = energyAnalyser.getEnergyHistogram();
        int nbins = histogram.length;
        double minEnergy = energyAnalyser.getMinFrameEnergy();
        double maxEnergy = energyAnalyser.getMaxFrameEnergy();
        double xStep = (maxEnergy - minEnergy) / (double)nbins;
        this.positionCursor.x = silenceCutoff_dB = energyAnalyser.getSilenceCutoff();
        super.initialise(width, height, minEnergy, xStep, histogram);
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            EnergyHistogram signalGraph = new EnergyHistogram(ais);
            signalGraph.showInJFrame(args[i], true, false);
            ++i;
        }
    }
}

