/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import marytts.signalproc.display.FunctionGraph;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.data.audio.MaryAudioUtils;

public class SignalGraph
extends FunctionGraph {
    public SignalGraph(AudioInputStream ais) {
        this(ais, 640, 480);
    }

    public SignalGraph(AudioInputStream ais, int width, int height) {
        if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
        }
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono audio signals");
        }
        int samplingRate = (int)ais.getFormat().getSampleRate();
        double[] audioData = MaryAudioUtils.getSamplesAsDoubleArray(ais);
        this.initialise(audioData, samplingRate, width, height);
    }

    public SignalGraph(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public SignalGraph(double[] signal, int samplingRate, int width, int height) {
        this.initialise(signal, samplingRate, width, height);
    }

    protected void initialise(double[] signal, int samplingRate, int width, int height) {
        super.initialise(width, height, 0.0, 1.0 / (double)samplingRate, signal);
        this.updateSound(signal, samplingRate);
    }

    protected void update(double[] signal, int samplingRate) {
        super.updateData(0.0, 1.0 / (double)samplingRate, signal);
        this.updateSound(signal, samplingRate);
    }

    protected void updateSound(double[] signal, int samplingRate) {
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, samplingRate, 16, 1, 2, samplingRate, false);
        DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
        final Timer timer = new Timer(true);
        try {
            final Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(new DDSAudioInputStream(new BufferedDoubleDataSource(signal), audioFormat));
            System.err.println("Created clip");
            this.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "startOrStopAudio");
            this.getInputMap(2).put(KeyStroke.getKeyStroke("SPACE"), "startOrStopAudio");
            this.getActionMap().put("startOrStopAudio", new AbstractAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Clip clip2 = clip;
                    synchronized (clip2) {
                        if (clip.isActive()) {
                            System.err.println("Stopping clip.");
                            clip.stop();
                        } else {
                            System.err.println("Rewinding clip.");
                            if (Double.isNaN(SignalGraph.this.positionCursor.x)) {
                                clip.setFramePosition(0);
                            } else {
                                clip.setFramePosition(SignalGraph.this.X2indexX(SignalGraph.this.positionCursor.x));
                            }
                            if (!Double.isNaN(SignalGraph.this.rangeCursor.x)) {
                                System.err.println("Setting timer task");
                                int endFrame = SignalGraph.this.X2indexX(SignalGraph.this.rangeCursor.x);
                                timer.schedule((TimerTask)new ClipObserver(clip, endFrame), 50L, 50L);
                            }
                            System.err.println("Starting clip.");
                            clip.start();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            SignalGraph signalGraph = new SignalGraph(ais);
            signalGraph.showInJFrame(args[i], true, false);
            ++i;
        }
    }

    public class ClipObserver
    extends TimerTask {
        protected Clip clip;
        protected int endFrame;

        public ClipObserver(Clip clip, int endFrame) {
            this.clip = clip;
            this.endFrame = endFrame;
        }

        @Override
        public void run() {
            System.err.println("Timer task running");
            if (!this.clip.isActive() || this.clip.getFramePosition() >= this.endFrame) {
                System.err.println("Timer task stopping clip.");
                this.clip.stop();
                this.cancel();
            }
        }
    }
}

