/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.MultiDisplay;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.filter.LowPassFilter;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;

public class HighPassFilter
extends FIRFilter {
    public static double DEFAULT_TRANSITIONBANDWIDTH = 0.01;
    public double normalisedCutoffFrequency;

    public HighPassFilter(double normalisedCutoffFrequencyIn) {
        this(normalisedCutoffFrequencyIn, DEFAULT_TRANSITIONBANDWIDTH);
    }

    public HighPassFilter(double normalisedCutoffFrequencyIn, double normalisedTransitionBandwidth) {
        this(normalisedCutoffFrequencyIn, HighPassFilter.bandwidth2kernelLength(normalisedTransitionBandwidth));
    }

    public HighPassFilter(double normalisedCutoffFrequencyIn, int kernelLength) {
        if (kernelLength <= 0 || kernelLength % 2 == 0) {
            throw new IllegalArgumentException("Kernel length must be an odd positive number, got " + kernelLength);
        }
        this.normalisedCutoffFrequency = normalisedCutoffFrequencyIn;
        if (this.normalisedCutoffFrequency <= 0.0 || this.normalisedCutoffFrequency >= 0.5) {
            throw new IllegalArgumentException("Normalised cutoff frequency must be between 0 and 0.5, got " + this.normalisedCutoffFrequency);
        }
        double[] kernel = HighPassFilter.getKernel(this.normalisedCutoffFrequency, kernelLength);
        this.sliceLength = MathUtils.closestPowerOfTwoAbove(2 * kernelLength) - kernelLength;
        this.initialise(kernel, this.sliceLength);
    }

    public double getTransitionBandWidth(int samplingRate) {
        return (double)samplingRate * HighPassFilter.kernelLength2bandwidth(this.impulseResponseLength);
    }

    protected static double[] getKernel(double normalisedCutoffFrequencyIn, int kernelLength) {
        double[] lowPassKernel = LowPassFilter.getKernel(normalisedCutoffFrequencyIn, kernelLength);
        double[] kernel = new double[kernelLength];
        int i = 0;
        while (i < kernelLength) {
            kernel[i] = -lowPassKernel[i];
            ++i;
        }
        int n = (kernelLength - 1) / 2;
        kernel[n] = kernel[n] + 1.0;
        return kernel;
    }

    protected static int bandwidth2kernelLength(double normalisedTransitionBandwidth) {
        int l = (int)(4.0 / normalisedTransitionBandwidth);
        if (l % 2 == 0) {
            ++l;
        }
        return l;
    }

    protected static double kernelLength2bandwidth(int kernelLength) {
        return 4.0 / (double)kernelLength;
    }

    public String toString() {
        return "Highpass filter";
    }

    public static void main(String[] args) throws Exception {
        int cutoffFreq = Integer.valueOf(args[0]);
        AudioDoubleDataSource source = new AudioDoubleDataSource(AudioSystem.getAudioInputStream(new File(args[1])));
        int samplingRate = source.getSamplingRate();
        double normalisedCutoffFrequency = (double)cutoffFreq / (double)samplingRate;
        HighPassFilter filter = new HighPassFilter(normalisedCutoffFrequency);
        System.err.println("Created " + filter.toString() + " with cutoff frequency " + cutoffFreq + " Hz and transition band width " + (int)filter.getTransitionBandWidth(samplingRate) + " Hz");
        double[] fftSignal = new double[filter.transformedIR.length];
        System.arraycopy(filter.transformedIR, 0, fftSignal, 0, filter.transformedIR.length);
        FFT.realTransform(fftSignal, true);
        double[] kernel = new double[filter.impulseResponseLength];
        System.arraycopy(fftSignal, 0, kernel, 0, kernel.length);
        FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0, kernel);
        timeGraph.showInJFrame(String.valueOf(filter.toString()) + " in time domain", true, false);
        double[] powerSpectrum = FFT.computePowerSpectrum_FD(filter.transformedIR);
        int i = 0;
        while (i < powerSpectrum.length) {
            powerSpectrum[i] = MathUtils.db(powerSpectrum[i]);
            ++i;
        }
        FunctionGraph freqGraph = new FunctionGraph(0.0, (double)samplingRate / (double)filter.transformedIR.length, powerSpectrum);
        freqGraph.showInJFrame(String.valueOf(filter.toString()) + " log frequency response", true, false);
        DoubleDataSource filteredSignal = filter.apply(source);
        new MultiDisplay(filteredSignal.getAllData(), samplingRate, String.valueOf(filter.toString()) + " at " + cutoffFreq + " Hz applied to " + args[1], 800, 600);
    }
}

