/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.SignalGraph;
import marytts.signalproc.process.FrameProvider;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.signalproc.window.Window;
import marytts.util.data.BlockwiseDoubleDataSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.SequenceDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;

public class FrameOverlapAddSource
extends BlockwiseDoubleDataSource {
    public static final int DEFAULT_WINDOWTYPE = 3;
    protected FrameProvider frameProvider;
    protected Window outputWindow;
    protected double[] memory;
    protected InlineDataProcessor processor;

    protected FrameOverlapAddSource() {
        super(null, 0);
    }

    public FrameOverlapAddSource(DoubleDataSource inputSource, int frameLength, int samplingRate, InlineDataProcessor processor) {
        this(inputSource, 3, false, frameLength, samplingRate, processor);
    }

    public FrameOverlapAddSource(DoubleDataSource inputSource, int windowType, boolean applySynthesisWindow, int frameLength, int samplingRate, InlineDataProcessor processor) {
        super(null, 0);
        this.initialise(inputSource, windowType, applySynthesisWindow, frameLength, samplingRate, processor);
    }

    protected void initialise(DoubleDataSource inputSource, int windowType, boolean applySynthesisWindow, int frameLength, int samplingRate, InlineDataProcessor processor) {
        double overlapFraction;
        double prescale = 1.0;
        switch (windowType) {
            case 3: {
                overlapFraction = 0.75;
                double onceOrTwice = 0.25 / (1.0 - overlapFraction);
                prescale = applySynthesisWindow ? Math.sqrt(0.6666666666666666 / onceOrTwice) : 0.5 / onceOrTwice;
                break;
            }
            case 1: 
            case 2: {
                overlapFraction = 0.875;
                break;
            }
            default: {
                throw new IllegalArgumentException("Window type not supported");
            }
        }
        this.blockSize = (int)((double)frameLength * (1.0 - overlapFraction));
        int inputFrameshift = this.getInputFrameshift(this.blockSize);
        Window window = Window.get(windowType, frameLength + 1, prescale);
        this.outputWindow = applySynthesisWindow ? window : null;
        this.memory = new double[frameLength];
        this.processor = processor;
        int nBlocks = (int)(1.0 / (1.0 - overlapFraction)) - 1;
        int m = frameLength / inputFrameshift;
        int nZeroes = nBlocks * inputFrameshift < frameLength ? nBlocks : m - 1;
        BufferedDoubleDataSource padding1 = new BufferedDoubleDataSource(new double[nZeroes * inputFrameshift]);
        BufferedDoubleDataSource padding2 = new BufferedDoubleDataSource(new double[nZeroes * inputFrameshift]);
        SequenceDoubleDataSource paddedSource = new SequenceDoubleDataSource(new DoubleDataSource[]{padding1, inputSource, padding2});
        this.frameProvider = new FrameProvider(paddedSource, window, frameLength, inputFrameshift, samplingRate, true);
        double[] dummy = new double[this.blockSize];
        int i = 0;
        while (i < nBlocks) {
            this.getData(dummy, 0, this.blockSize);
            ++i;
        }
        this.frameProvider.resetInternalTimer();
    }

    protected double[] getNextFrame() {
        return this.frameProvider.getNextFrame();
    }

    @Override
    protected void prepareBlock() {
        double[] frame = this.getNextFrame();
        if (frame == null) {
            return;
        }
        int frameLength = this.frameProvider.getFrameLengthSamples();
        if (this.processor != null) {
            this.processor.applyInline(frame, 0, frameLength);
        }
        if (this.outputWindow != null) {
            this.outputWindow.applyInline(frame, 0, frameLength);
        }
        if (this.memory.length < frameLength) {
            double[] oldMemory = this.memory;
            this.memory = new double[frameLength];
            System.arraycopy(oldMemory, 0, this.memory, 0, oldMemory.length);
        }
        int i = 0;
        while (i < frameLength) {
            int n = i;
            this.memory[n] = this.memory[n] + frame[i];
            ++i;
        }
    }

    @Override
    protected int getBlockSize() {
        return this.blockSize;
    }

    @Override
    protected int readBlock(double[] target, int targetPos) {
        int frameLength;
        int blockSize = this.getBlockSize();
        int validSamplesInFrame = this.frameProvider.validSamplesInFrame();
        if (validSamplesInFrame < (frameLength = this.frameProvider.getFrameLengthSamples())) {
            assert (!this.frameProvider.hasMoreData());
            int nCopied = blockSize < frameLength - validSamplesInFrame ? blockSize : blockSize - (frameLength - validSamplesInFrame);
            assert (nCopied > 0);
            System.arraycopy(this.memory, 0, target, targetPos, nCopied);
            return nCopied;
        }
        System.arraycopy(this.memory, 0, target, targetPos, blockSize);
        System.arraycopy(this.memory, blockSize, this.memory, 0, this.memory.length - blockSize);
        Arrays.fill(this.memory, this.memory.length - blockSize, this.memory.length, 0.0);
        return blockSize;
    }

    protected int getInputFrameshift(int outputFrameshift) {
        return outputFrameshift;
    }

    @Override
    public boolean hasMoreData() {
        return this.frameProvider.hasMoreData();
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            double[] signal = new AudioDoubleDataSource(inputAudio).getAllData();
            SignalGraph signalGraph = new SignalGraph(signal, samplingRate);
            signalGraph.showInJFrame("signal", true, true);
            FrameOverlapAddSource ola = new FrameOverlapAddSource(new BufferedDoubleDataSource(signal), 2048, samplingRate, null);
            double[] result = ola.getAllData();
            SignalGraph resultGraph = new SignalGraph(result, samplingRate);
            resultGraph.showInJFrame("result", true, true);
            System.err.println("Signal has length " + signal.length + ", result " + result.length);
            double err = MathUtils.sumSquaredError(signal, result);
            System.err.println("Sum squared error: " + err);
            double[] difference = MathUtils.subtract(signal, result);
            SignalGraph diffGraph = new SignalGraph(difference, samplingRate);
            diffGraph.showInJFrame("difference", true, true);
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(ola), inputAudio.getFormat());
            String outFileName = String.valueOf(args[i].substring(0, args[i].length() - 4)) + "_copy.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
    }
}

