/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.io.FileReader;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.process.FramewiseMerger;
import marytts.signalproc.process.InlineFrameMerger;
import marytts.signalproc.process.LPCAnalysisResynthesis;
import marytts.util.data.BaseDoubleDataSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.data.text.LabelfileDoubleDataSource;
import marytts.util.io.FileUtils;

public class LSFInterpolator
extends LPCAnalysisResynthesis
implements InlineFrameMerger {
    protected double[] otherFrame1;
    protected double[] otherFrame2;
    protected double relativeWeightOther1;
    protected double r;

    public LSFInterpolator(int p, double r) {
        super(p);
        if (r < 0.0 || r > 1.0) {
            throw new IllegalArgumentException("Mixing ratio r must be between 0 and 1");
        }
        this.r = r;
    }

    @Override
    public void setFrameToMerge(double[] frameToMerge) {
        this.otherFrame1 = frameToMerge;
        this.otherFrame2 = null;
        this.relativeWeightOther1 = 1.0;
    }

    @Override
    public void setFrameToMerge(double[] frame1, double[] frame2, double relativeWeightFrame1) {
        this.otherFrame1 = frame1;
        this.otherFrame2 = frame2;
        this.relativeWeightOther1 = relativeWeightFrame1;
    }

    @Override
    protected void processLPC(LpcAnalyser.LpCoeffs coeffs, double[] residual) {
        int i;
        if (this.otherFrame1 == null) {
            return;
        }
        LpcAnalyser.LpCoeffs otherCoeffs = LpcAnalyser.calcLPC(this.otherFrame1, this.p);
        double[] otherlsf = otherCoeffs.getLSF();
        double[] lsf = coeffs.getLSF();
        assert (lsf.length == otherlsf.length);
        if (this.otherFrame2 != null && this.relativeWeightOther1 < 1.0) {
            assert (0.0 <= this.relativeWeightOther1);
            LpcAnalyser.LpCoeffs other2Coeffs = LpcAnalyser.calcLPC(this.otherFrame2, this.p);
            double[] other2lsf = other2Coeffs.getLSF();
            i = 0;
            while (i < otherlsf.length) {
                otherlsf[i] = this.relativeWeightOther1 * otherlsf[i] + (1.0 - this.relativeWeightOther1) * other2lsf[i];
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < lsf.length) {
            lsf[i2] = (1.0 - this.r) * lsf[i2] + this.r * otherlsf[i2];
            ++i2;
        }
        coeffs.setLSF(lsf);
        double gainFactor = Math.sqrt((1.0 - this.r) * coeffs.getGain() * coeffs.getGain() + this.r * otherCoeffs.getGain() * otherCoeffs.getGain()) / coeffs.getGain();
        i = 0;
        while (i < residual.length) {
            int n = i++;
            residual[n] = residual[n] * gainFactor;
        }
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        double r = Double.parseDouble(System.getProperty("r", "0.5"));
        String file1 = null;
        String file2 = null;
        BaseDoubleDataSource label1 = null;
        BaseDoubleDataSource label2 = null;
        if (args.length == 2) {
            file1 = args[0];
            file2 = args[1];
        } else if (args.length == 4) {
            double[] labelData2;
            file1 = args[0];
            label1 = new LabelfileDoubleDataSource(new FileReader(args[1]));
            file2 = args[2];
            label2 = new LabelfileDoubleDataSource(new FileReader(args[3]));
            double[] labelData1 = label1.getAllData();
            if (labelData1.length != (labelData2 = label2.getAllData()).length) {
                System.err.println("Warning: Number of labels is different!");
                System.err.println(String.valueOf(args[1]) + ":");
                System.err.println(FileUtils.getFileAsString((File)new File(args[1]), (String)"ASCII"));
                System.err.println(String.valueOf(args[3]) + ":");
                System.err.println(FileUtils.getFileAsString((File)new File(args[3]), (String)"ASCII"));
            }
            label1 = new BufferedDoubleDataSource(labelData1);
            label2 = new BufferedDoubleDataSource(labelData2);
        } else {
            System.out.println("Usage: java [-Dr=<mixing ratio> marytts.signalproc.process.LSFInterpolator signal.wav [signal.lab] other.wav [other.lab]");
            System.out.println("where");
            System.out.println("    <mixing ratio> is a value between 0.0 and 1.0 indicating how much of \"other\" is supposed to be mixed into \"signal\"");
            System.exit(1);
        }
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(file1));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        AudioInputStream otherAudio = AudioSystem.getAudioInputStream(new File(file2));
        AudioDoubleDataSource otherSource = new AudioDoubleDataSource(otherAudio);
        int frameLength = Integer.getInteger("signalproc.lpcanalysisresynthesis.framelength", 512);
        int predictionOrder = Integer.getInteger("signalproc.lpcanalysisresynthesis.predictionorder", 20);
        FramewiseMerger foas = new FramewiseMerger(signal, frameLength, samplingRate, label1, otherSource, samplingRate, label2, new LSFInterpolator(predictionOrder, r));
        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
        String outFileName = String.valueOf(file1.substring(0, file1.length() - 4)) + "_" + file2.substring(file2.lastIndexOf("\\") + 1, file2.length() - 4) + "_" + r + ".wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        long endTime = System.currentTimeMillis();
        int audioDuration = (int)((double)AudioSystem.getAudioFileFormat(new File(file1)).getFrameLength() / (double)samplingRate * 1000.0);
        System.out.println("LSF-based interpolatin took " + (endTime - startTime) + " ms for " + audioDuration + " ms of audio");
    }
}

