/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.SignalGraph;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.MathUtils;

public class NaiveVocoder
extends FrameOverlapAddSource {
    public static final int DEFAULT_FRAMELENGTH = 2048;
    protected double rateChangeFactor;

    public NaiveVocoder(DoubleDataSource inputSource, int samplingRate, double rateChangeFactor) {
        this.rateChangeFactor = rateChangeFactor;
        this.initialise(inputSource, 3, true, 2048, samplingRate, null);
    }

    @Override
    protected int getInputFrameshift(int outputFrameshift) {
        int inputFrameshift = (int)((double)outputFrameshift * this.rateChangeFactor);
        double actualFactor = (double)inputFrameshift / (double)outputFrameshift;
        if (this.rateChangeFactor != actualFactor) {
            System.err.println("With output frameshift " + outputFrameshift + ", need to adjust rate change factor to " + actualFactor);
            this.rateChangeFactor = actualFactor;
        }
        return inputFrameshift;
    }

    public int computeOutputLength(int inputLengthInSamples) {
        int f = this.frameProvider.getFrameLengthSamples();
        int so = this.blockSize;
        int si = this.frameProvider.getFrameShiftSamples();
        assert (si == this.getInputFrameshift(so));
        int n = (int)Math.ceil(((double)inputLengthInSamples - (double)f) / (double)si);
        int delta = f + n * si - inputLengthInSamples;
        assert (delta < si);
        int lo = f + n * so - delta;
        return lo;
    }

    public static void main(String[] args) throws Exception {
        int i = 1;
        while (i < args.length) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            double[] signal = new AudioDoubleDataSource(inputAudio).getAllData();
            SignalGraph signalGraph = new SignalGraph(signal, samplingRate);
            signalGraph.showInJFrame("signal", true, true);
            double rateFactor = Double.parseDouble(args[0]);
            NaiveVocoder pv = new NaiveVocoder(new BufferedDoubleDataSource(signal), samplingRate, rateFactor);
            double[] result = pv.getAllData();
            SignalGraph resultGraph = new SignalGraph(result, samplingRate);
            resultGraph.showInJFrame("result", true, true);
            System.err.println("Signal has length " + signal.length + ", result " + result.length);
            if (signal.length == result.length) {
                double err = MathUtils.sumSquaredError(signal, result);
                System.err.println("Sum squared error: " + err);
            }
            System.err.println("Expected result length: " + pv.computeOutputLength(signal.length) + ", found: " + result.length);
            double meanSignalEnergy = MathUtils.mean(MathUtils.multiply(signal, signal));
            double meanResultEnergy = MathUtils.mean(MathUtils.multiply(result, result));
            System.err.println("Mean result energy: " + meanResultEnergy / meanSignalEnergy * 100.0 + "% of mean signal energy");
            ++i;
        }
    }
}

