/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import marytts.signalproc.sinusoidal.BaseSinusoidalSpeechFrame;
import marytts.signalproc.sinusoidal.Sinusoid;
import marytts.util.math.ComplexArray;

public class NonharmonicSinusoidalSpeechFrame
extends BaseSinusoidalSpeechFrame {
    public Sinusoid[] sinusoids;
    public double[] systemAmps;
    public double[] systemPhases;
    public float[] systemCeps;
    public ComplexArray frameDfts;
    public float time;
    public float voicing;
    public float maxFreqOfVoicing;

    public NonharmonicSinusoidalSpeechFrame(int numSins) {
        this.sinusoids = numSins > 0 ? new Sinusoid[numSins] : null;
        this.systemAmps = null;
        this.systemPhases = null;
        this.systemCeps = null;
        this.frameDfts = null;
        this.time = -1.0f;
        this.voicing = -1.0f;
        this.maxFreqOfVoicing = -1.0f;
    }

    public NonharmonicSinusoidalSpeechFrame(NonharmonicSinusoidalSpeechFrame existing) {
        this(existing.sinusoids.length);
        int i = 0;
        while (i < existing.sinusoids.length) {
            this.sinusoids[i] = new Sinusoid(existing.sinusoids[i]);
            ++i;
        }
        this.setSystemAmps(existing.systemAmps);
        this.setSystemPhases(existing.systemPhases);
        this.setSystemCeps(existing.systemCeps);
        this.setFrameDfts(existing.frameDfts);
        this.time = existing.time;
        this.voicing = existing.voicing;
        this.maxFreqOfVoicing = existing.maxFreqOfVoicing;
    }

    public void setSystemAmps(double[] newAmps) {
        if (newAmps != null && newAmps.length > 0) {
            this.systemAmps = new double[newAmps.length];
            System.arraycopy(newAmps, 0, this.systemAmps, 0, newAmps.length);
        } else {
            this.systemAmps = null;
        }
    }

    public void setSystemPhases(double[] newPhases) {
        if (newPhases != null && newPhases.length > 0) {
            this.systemPhases = new double[newPhases.length];
            System.arraycopy(newPhases, 0, this.systemPhases, 0, newPhases.length);
        } else {
            this.systemPhases = null;
        }
    }

    public void setSystemCeps(float[] newCeps) {
        if (newCeps != null && newCeps.length > 0) {
            this.systemCeps = new float[newCeps.length];
            System.arraycopy(newCeps, 0, this.systemCeps, 0, newCeps.length);
        } else {
            this.systemCeps = null;
        }
    }

    public void setFrameDfts(ComplexArray newDfts) {
        this.frameDfts = newDfts != null ? new ComplexArray(newDfts) : null;
    }
}

