/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import marytts.signalproc.sinusoidal.Sinusoid;
import marytts.signalproc.sinusoidal.TrackGenerator;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class SinusoidalTrack {
    public float[] amps;
    public float[] freqs;
    public float[] phases;
    public int[] frameIndices;
    public float[] times;
    public float[] maxFreqOfVoicings;
    public int[] states;
    public static int ACTIVE = 0;
    public static int TURNED_ON = 1;
    public static int TURNED_OFF = 2;
    public int currentIndex;
    public int totalSins;
    public Sinusoid newCandidate;
    public int newCandidateInd;
    public float avgFreqInHz;
    public float minFreqInHz;
    public float maxFreqInHz;
    public float avgAmpLinear;
    public float minAmpLinear;
    public float maxAmpLinear;
    public float avgPhaseInDegrees;
    public float minPhaseInDegrees;
    public float maxPhaseInDegrees;
    public float minTimeInSeconds;
    public float maxTimeInSeconds;

    public void getStatistics(boolean isFreqRadian, boolean isPhaseRadian, int fs, int trackIndex) {
        this.avgFreqInHz = 0.0f;
        this.minFreqInHz = -1.0f;
        this.maxFreqInHz = -1.0f;
        this.avgAmpLinear = 0.0f;
        this.minAmpLinear = -1.0f;
        this.maxAmpLinear = -1.0f;
        this.avgPhaseInDegrees = 0.0f;
        this.minPhaseInDegrees = -1.0f;
        this.maxPhaseInDegrees = -1.0f;
        this.minTimeInSeconds = -1.0f;
        this.maxTimeInSeconds = -1.0f;
        if (this.totalSins > 0) {
            int i = 0;
            while (i < this.totalSins) {
                this.avgFreqInHz += this.freqs[i];
                this.avgAmpLinear += this.amps[i];
                this.avgPhaseInDegrees += this.phases[i];
                ++i;
            }
            this.avgFreqInHz /= (float)this.totalSins;
            this.avgAmpLinear /= (float)this.totalSins;
            this.avgPhaseInDegrees /= (float)this.totalSins;
            if (isFreqRadian) {
                this.avgFreqInHz = SignalProcUtils.radian2hz(this.avgFreqInHz, fs);
            }
            if (isPhaseRadian) {
                this.avgPhaseInDegrees = MathUtils.radian2degrees(this.avgPhaseInDegrees);
            }
            this.minFreqInHz = MathUtils.getMin(this.freqs);
            if (isFreqRadian) {
                this.minFreqInHz = SignalProcUtils.radian2hz(this.minFreqInHz, fs);
            }
            this.maxFreqInHz = MathUtils.getMax(this.freqs);
            if (isFreqRadian) {
                this.maxFreqInHz = SignalProcUtils.radian2hz(this.maxFreqInHz, fs);
            }
            this.minAmpLinear = MathUtils.getMin(this.amps);
            this.maxAmpLinear = MathUtils.getMax(this.amps);
            this.minPhaseInDegrees = MathUtils.getMin(this.phases);
            if (isPhaseRadian) {
                this.minPhaseInDegrees = MathUtils.radian2degrees(this.minPhaseInDegrees);
            }
            this.maxPhaseInDegrees = MathUtils.getMax(this.phases);
            if (isPhaseRadian) {
                this.maxPhaseInDegrees = MathUtils.radian2degrees(this.maxPhaseInDegrees);
            }
            this.minTimeInSeconds = MathUtils.getMin(this.times);
            this.maxTimeInSeconds = MathUtils.getMax(this.times);
            char chTab = '\t';
            String str = "ind=" + String.valueOf(trackIndex) + " avgFreq=" + String.valueOf(this.avgFreqInHz) + " Hz." + chTab;
            str = String.valueOf(str) + "minFreq=" + String.valueOf(this.minFreqInHz) + " Hz." + chTab;
            str = String.valueOf(str) + "maxFreq=" + String.valueOf(this.maxFreqInHz) + " Hz." + chTab;
            str = String.valueOf(str) + "avgAmpl=" + String.valueOf(this.avgAmpLinear) + chTab;
            str = String.valueOf(str) + "minAmpl=" + String.valueOf(this.minAmpLinear) + chTab;
            str = String.valueOf(str) + "maxAmpl=" + String.valueOf(this.maxAmpLinear) + chTab;
            str = String.valueOf(str) + "avgPhas=" + String.valueOf(this.avgPhaseInDegrees) + "\u00b0" + chTab;
            str = String.valueOf(str) + "minPhas=" + String.valueOf(this.minPhaseInDegrees) + "\u00b0" + chTab;
            str = String.valueOf(str) + "maxPhas=" + String.valueOf(this.maxPhaseInDegrees) + "\u00b0" + chTab;
            str = String.valueOf(str) + "minTime=" + String.valueOf(this.minTimeInSeconds) + "s." + chTab;
            str = String.valueOf(str) + "maxTime=" + String.valueOf(this.maxTimeInSeconds) + "s.";
            System.out.println(str);
        }
    }

    public SinusoidalTrack(int len) {
        this.initialize(len);
    }

    public SinusoidalTrack(float time, Sinusoid sin, float maxFreqOfVoicing, int state) {
        this.add(time, sin.amp, sin.freq, sin.phase, sin.frameIndex, maxFreqOfVoicing, state);
    }

    public SinusoidalTrack(SinusoidalTrack trk) {
        this.initialize(trk.totalSins);
        this.copy(trk);
    }

    public void initialize(int len) {
        if (len > 0) {
            this.totalSins = len;
            this.times = new float[this.totalSins];
            this.amps = new float[this.totalSins];
            this.freqs = new float[this.totalSins];
            this.phases = new float[this.totalSins];
            this.frameIndices = new int[this.totalSins];
            this.maxFreqOfVoicings = new float[this.totalSins];
            this.states = new int[this.totalSins];
        } else {
            this.totalSins = 0;
            this.times = null;
            this.amps = null;
            this.freqs = null;
            this.phases = null;
            this.frameIndices = null;
            this.maxFreqOfVoicings = null;
            this.states = null;
        }
        this.currentIndex = -1;
        this.newCandidate = null;
        this.newCandidateInd = -1;
    }

    public void copy(SinusoidalTrack srcTrack, int startSinIndex, int endSinIndex) {
        if (startSinIndex < 0) {
            startSinIndex = 0;
        }
        if (endSinIndex < 0) {
            endSinIndex = 0;
        }
        if (endSinIndex > srcTrack.totalSins - 1) {
            endSinIndex = srcTrack.totalSins - 1;
        }
        if (startSinIndex > endSinIndex) {
            startSinIndex = endSinIndex;
        }
        if (this.totalSins < endSinIndex - startSinIndex + 1) {
            this.initialize(endSinIndex - startSinIndex + 1);
        }
        if (this.totalSins > 0) {
            System.arraycopy(srcTrack.times, startSinIndex, this.times, 0, endSinIndex - startSinIndex + 1);
            System.arraycopy(srcTrack.amps, startSinIndex, this.amps, 0, endSinIndex - startSinIndex + 1);
            System.arraycopy(srcTrack.freqs, startSinIndex, this.freqs, 0, endSinIndex - startSinIndex + 1);
            System.arraycopy(srcTrack.phases, startSinIndex, this.phases, 0, endSinIndex - startSinIndex + 1);
            System.arraycopy(srcTrack.frameIndices, startSinIndex, this.frameIndices, 0, endSinIndex - startSinIndex + 1);
            System.arraycopy(srcTrack.maxFreqOfVoicings, startSinIndex, this.maxFreqOfVoicings, 0, endSinIndex - startSinIndex + 1);
            System.arraycopy(srcTrack.states, startSinIndex, this.states, 0, endSinIndex - startSinIndex + 1);
            this.currentIndex = endSinIndex - startSinIndex;
        }
    }

    public void copy(SinusoidalTrack srcTrack) {
        this.copy(srcTrack, 0, srcTrack.totalSins - 1);
    }

    public void add(float time, Sinusoid newSin, float pVoicing, int state) {
        this.add(time, newSin.amp, newSin.freq, newSin.phase, newSin.frameIndex, pVoicing, state);
    }

    public void add(float time, float amp, float freq, float phase, int frameIndex, float maxFreqOfVoicing, int state) {
        if (this.currentIndex + 1 >= this.totalSins) {
            SinusoidalTrack tmpTrack = new SinusoidalTrack(this.totalSins);
            if (this.totalSins > 0) {
                tmpTrack.copy(this);
                this.initialize(tmpTrack.totalSins + 1);
                this.copy(tmpTrack);
            } else {
                this.initialize(1);
            }
        }
        ++this.currentIndex;
        this.times[this.currentIndex] = time;
        this.amps[this.currentIndex] = amp;
        this.freqs[this.currentIndex] = freq;
        this.phases[this.currentIndex] = phase;
        this.frameIndices[this.currentIndex] = frameIndex;
        this.maxFreqOfVoicings[this.currentIndex] = maxFreqOfVoicing;
        this.states[this.currentIndex] = state;
    }

    public void update(int index, int time, float amp, float freq, float phase, int frameIndex, float sysAmp, float maxFreqOfVoicing, int state) {
        if (index < this.totalSins) {
            this.times[index] = time;
            this.amps[index] = amp;
            this.freqs[index] = freq;
            this.phases[index] = phase;
            this.frameIndices[index] = frameIndex;
            this.maxFreqOfVoicings[index] = maxFreqOfVoicing;
            this.states[index] = state;
        }
    }

    public void resetCandidate() {
        this.newCandidate = null;
        this.newCandidateInd = -1;
    }

    public void correctTrack() {
        int i = 0;
        while (i < this.totalSins) {
            if (this.states[i] == TURNED_OFF && i > 0 && this.times[i] - this.times[i - 1] > 0.04f) {
                this.times[i] = this.times[i - 1] + TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS;
            }
            if (this.states[i] == TURNED_ON && i < this.totalSins - 1 && this.times[i + 1] - this.times[i] > 0.04f) {
                this.times[i] = this.times[i + 1] - TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS;
            }
            ++i;
        }
    }
}

