/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.sinusoidal.SinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalTrack;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.signalproc.sinusoidal.TrackGenerator;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class TrackModifier {
    public static float DEFAULT_MODIFICATION_SKIP_SIZE = 0.005f;
    public static final int FROM_ORIGINAL = 1;
    public static final int FROM_RESAMPLED = 2;
    public static final int FROM_CEPSTRUM = 3;
    public static final int FROM_INTERPOLATED = 4;

    public static SinusoidalTracks modifyTimeScale(SinusoidalTracks trIn, double[] f0s, float f0_ss, float f0_ws, int[] pitchMarks, float[] voicings, float numPeriods, boolean isVoicingAdaptiveTimeScaling, float timeScalingVoicingThreshold, boolean isVoicingAdaptivePitchScaling, float tScale, int offset, int sysAmpModMethod, int sysPhaseModMethod) {
        float[] tScales = new float[1];
        float[] tScalesTimes = new float[1];
        tScales[0] = tScale;
        tScalesTimes[0] = 0.02f;
        return TrackModifier.modify(trIn, f0s, f0_ss, f0_ws, pitchMarks, voicings, numPeriods, isVoicingAdaptiveTimeScaling, timeScalingVoicingThreshold, isVoicingAdaptivePitchScaling, tScales, tScalesTimes, null, null, offset, sysAmpModMethod, sysPhaseModMethod);
    }

    public static SinusoidalTracks modify(SinusoidalTracks trIn, double[] f0s, float f0_ss, float f0_ws, int[] pitchMarks, float[] voicings, float numPeriods, boolean isVoicingAdaptiveTimeScaling, float timeScalingVoicingThreshold, boolean isVoicingAdaptivePitchScaling, float[] tScales, float[] tScalesTimes, float[] pScales, float[] pScalesTimes, int offset, int sysAmpModMethod, int sysPhaseModMethod) {
        int trackEn;
        int trackSt;
        int i;
        if (tScalesTimes == null) {
            tScalesTimes = new float[tScales.length];
            i = 0;
            while (i < tScales.length) {
                tScalesTimes[i] = (float)(((double)i + 0.5) / (double)tScales.length * (double)trIn.origDur);
                ++i;
            }
        }
        if (pScalesTimes == null) {
            pScalesTimes = new float[pScales.length];
            i = 0;
            while (i < pScales.length) {
                pScalesTimes[i] = (float)(((double)i + 0.5) / (double)pScales.length * (double)trIn.origDur);
                ++i;
            }
        }
        double[] f0sMod = SignalProcUtils.pitchScalePitchContour(f0s, f0_ws, f0_ss, pScales, pScalesTimes);
        f0sMod = SignalProcUtils.timeScalePitchContour(f0sMod, f0_ws, f0_ss, tScales, tScalesTimes);
        float maxDur = SignalProcUtils.timeScaledTime(trIn.origDur, tScales, tScalesTimes);
        PitchMarks pmMod = SignalProcUtils.pitchContour2pitchMarks(f0sMod, trIn.fs, (int)Math.floor((double)(maxDur * (float)trIn.fs) + 0.5), f0_ws, f0_ss, false, offset);
        SinusoidalTracks trMod = null;
        boolean bSingleTrackTest = false;
        if (bSingleTrackTest) {
            trackSt = 7;
            trackEn = 7;
            trMod = new SinusoidalTracks(1, trIn.fs);
        } else {
            trackSt = 0;
            trackEn = trIn.totalTracks - 1;
            trMod = new SinusoidalTracks(trIn);
        }
        float prevExcPhase = 0.0f;
        float prevExcPhaseMod = 0.0f;
        int prevMiddleAnalysisSample = 0;
        int prevMiddleSynthesisSample = 0;
        i = trackSt;
        while (i <= trackEn) {
            if (bSingleTrackTest) {
                trMod.add(trIn.tracks[i]);
            }
            float trackMeanFreqInRadians = MathUtils.mean(trIn.tracks[i].freqs);
            float trackMeanFreqInHz = SignalProcUtils.radian2hz(trackMeanFreqInRadians, trIn.fs);
            int j = 0;
            while (j < trIn.tracks[i].totalSins) {
                float middleSynthesisTime;
                int currentInd = !bSingleTrackTest ? i : 0;
                if (trIn.tracks[i].states[j] == SinusoidalTrack.ACTIVE || trIn.tracks[i].states[j] == SinusoidalTrack.TURNED_OFF) {
                    float pVoicing;
                    int middleAnalysisSample = SignalProcUtils.time2sample(trIn.tracks[i].times[j], trIn.fs);
                    int closestInd = MathUtils.findClosest(pitchMarks, middleAnalysisSample);
                    int sysTimeInd = MathUtils.findClosest(trIn.times, trIn.tracks[i].times[j]);
                    float freqInHz = SignalProcUtils.radian2hz(trIn.tracks[i].freqs[j], trIn.fs);
                    int pScaleInd = MathUtils.findClosest(pScalesTimes, trIn.tracks[i].times[j]);
                    float pScaleCurrent = pScales[pScaleInd];
                    float maxFreqOfVoicingInHz = SignalProcUtils.radian2hz(trIn.tracks[i].maxFreqOfVoicings[j], trIn.fs);
                    float newGain = 1.0f;
                    if (pScaleCurrent > 1.0f) {
                        if (freqInHz < 10.0f) {
                            pScaleCurrent = 1.0f;
                        } else if ((double)freqInHz + ((double)pScaleCurrent - 1.0) * (double)trackMeanFreqInHz > (double)maxFreqOfVoicingInHz) {
                            pScaleCurrent = 1.0f;
                            newGain = 0.0f;
                        } else if (freqInHz > maxFreqOfVoicingInHz) {
                            pScaleCurrent = 1.0f;
                            newGain = 0.0f;
                        }
                    }
                    if (voicings != null && isVoicingAdaptivePitchScaling) {
                        pVoicing = voicings[Math.min(closestInd, voicings.length - 1)];
                        float pitchScalingFreqThreshold = (float)((double)(0.5f * pVoicing) * (Math.PI * 2));
                        pScaleCurrent = trIn.tracks[i].freqs[j] > pitchScalingFreqThreshold ? 1.0f : pScales[pScaleInd];
                    }
                    int tScaleInd = MathUtils.findClosest(tScalesTimes, trIn.tracks[i].times[j]);
                    float cfr_ignored_0 = tScales[tScaleInd];
                    if (voicings != null && isVoicingAdaptiveTimeScaling && !((pVoicing = voicings[Math.min(closestInd, voicings.length - 1)]) < timeScalingVoicingThreshold)) {
                        float cfr_ignored_1 = 1.0f - pVoicing + pVoicing * tScales[tScaleInd];
                    }
                    int sysFreqInd = SignalProcUtils.freq2index(freqInHz, (double)trIn.fs, trIn.sysAmps.get(sysTimeInd).length - 1);
                    double sysFreqIndDouble = SignalProcUtils.freq2indexDouble(freqInHz, (double)trIn.fs, trIn.sysAmps.get(sysTimeInd).length - 1);
                    float sysAmp = (float)trIn.sysAmps.get(sysTimeInd)[sysFreqInd];
                    float excPhase = prevExcPhase + trIn.tracks[i].freqs[j] * (float)(middleAnalysisSample - prevMiddleAnalysisSample);
                    float sysPhase = trIn.tracks[i].phases[j] - excPhase;
                    float excAmp = trIn.tracks[i].amps[j] / sysAmp;
                    float freq = trIn.tracks[i].freqs[j];
                    middleSynthesisTime = trIn.tracks[i].states[j] != SinusoidalTrack.TURNED_OFF ? SignalProcUtils.timeScaledTime(trIn.tracks[i].times[j], tScales, tScalesTimes) : trMod.tracks[currentInd].times[j - 1] + TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS;
                    int middleSynthesisSample = SignalProcUtils.time2sample(middleSynthesisTime, trIn.fs);
                    MathUtils.findClosest(pmMod.pitchMarks, middleSynthesisSample);
                    float excPhaseMod = prevExcPhaseMod + (freq + (pScaleCurrent - 1.0f) * trackMeanFreqInRadians) * (float)(middleSynthesisSample - prevMiddleSynthesisSample);
                    float excAmpMod = excAmp;
                    float freqMod = (float)((double)freq + ((double)pScaleCurrent - 1.0) * (double)trackMeanFreqInRadians);
                    if ((double)freqMod > Math.PI) {
                        excAmpMod = 0.0f;
                    }
                    while ((double)freqMod > Math.PI * 2) {
                        freqMod = (float)((double)freqMod - Math.PI * 2);
                    }
                    int sysFreqIndMod = sysFreqInd;
                    float sysPhaseMod = sysPhase;
                    float sysAmpMod = sysAmp;
                    if (pScaleCurrent != 1.0f) {
                        sysFreqIndMod = SignalProcUtils.freq2index((double)freqInHz + ((double)pScaleCurrent - 1.0) * (double)trackMeanFreqInHz, (double)trIn.fs, trIn.sysAmps.get(sysTimeInd).length - 1);
                        sysFreqIndMod = Math.min(sysFreqIndMod, trIn.sysAmps.get(sysTimeInd).length - 1);
                        sysFreqIndMod = Math.max(sysFreqIndMod, 0);
                        if (sysPhaseModMethod == 1) {
                            sysPhaseMod = sysPhase;
                        } else if (sysPhaseModMethod == 2) {
                            sysPhaseMod = (float)trIn.sysPhases.get(sysTimeInd)[sysFreqIndMod];
                        } else if (sysPhaseModMethod == 4) {
                            if ((double)freqInHz < 0.5 * (double)trIn.fs - ((double)pScaleCurrent - 1.0) * (double)trackMeanFreqInHz - 50.0) {
                                float sysPhaseModImag;
                                float sysPhaseModReal;
                                int tempIndex = (int)Math.floor(sysFreqIndDouble + (double)SignalProcUtils.freq2index(((double)pScaleCurrent - 1.0) * (double)trackMeanFreqInHz, (double)trIn.fs, trIn.sysAmps.get(sysTimeInd).length - 1));
                                if (sysFreqInd < trIn.frameDfts.get((int)sysTimeInd).real.length - 1) {
                                    sysPhaseModReal = (float)MathUtils.interpolatedSample(tempIndex, sysFreqIndDouble, tempIndex + 1, trIn.frameDfts.get((int)sysTimeInd).real[tempIndex], trIn.frameDfts.get((int)sysTimeInd).real[tempIndex + 1]);
                                    sysPhaseModImag = (float)MathUtils.interpolatedSample(tempIndex, sysFreqIndDouble, tempIndex + 1, trIn.frameDfts.get((int)sysTimeInd).imag[tempIndex], trIn.frameDfts.get((int)sysTimeInd).imag[tempIndex + 1]);
                                } else {
                                    sysPhaseModReal = (float)MathUtils.interpolatedSample(tempIndex - 1, sysFreqIndDouble, tempIndex, trIn.frameDfts.get((int)sysTimeInd).real[tempIndex - 1], trIn.frameDfts.get((int)sysTimeInd).real[tempIndex]);
                                    sysPhaseModImag = (float)MathUtils.interpolatedSample(tempIndex - 1, sysFreqIndDouble, tempIndex, trIn.frameDfts.get((int)sysTimeInd).imag[tempIndex - 1], trIn.frameDfts.get((int)sysTimeInd).imag[tempIndex]);
                                }
                                sysPhaseMod = (float)Math.atan2(sysPhaseModImag, sysPhaseModReal);
                            } else {
                                sysPhaseMod = sysPhase;
                            }
                        } else if (sysPhaseModMethod == 3) {
                            sysPhaseMod = (float)SignalProcUtils.cepstrum2minimumPhase(trIn.sysCeps.get(sysTimeInd), trIn.tracks[i].freqs[j] + (pScaleCurrent - 1.0f) * trackMeanFreqInRadians);
                        }
                        if (sysAmpModMethod == 1) {
                            sysAmpMod = sysAmp;
                        } else if (sysAmpModMethod == 2) {
                            sysAmpMod = (float)trIn.sysAmps.get(sysTimeInd)[sysFreqIndMod];
                        } else if (sysAmpModMethod == 3) {
                            sysAmpMod = (float)SignalProcUtils.cepstrum2linearSpecAmp(trIn.sysCeps.get(sysTimeInd), pScaleCurrent * trIn.tracks[i].freqs[j]);
                        }
                    }
                    trMod.tracks[currentInd].amps[j] = newGain * excAmpMod * sysAmpMod;
                    trMod.tracks[currentInd].freqs[j] = freqMod;
                    trMod.tracks[currentInd].phases[j] = sysPhaseMod + excPhaseMod;
                    trMod.tracks[currentInd].times[j] = middleSynthesisTime;
                    if (trMod.tracks[currentInd].times[j] > maxDur) {
                        maxDur = trMod.tracks[currentInd].times[j];
                    }
                    if (j > 0 && trIn.tracks[i].states[j - 1] == SinusoidalTrack.TURNED_ON) {
                        trMod.tracks[currentInd].times[j - 1] = Math.max(0.0f, trMod.tracks[currentInd].times[j] - TrackGenerator.ZERO_AMP_SHIFT_IN_SECONDS);
                    }
                    prevExcPhase = excPhase;
                    prevExcPhaseMod = excPhaseMod;
                    prevMiddleSynthesisSample = middleSynthesisSample;
                    prevMiddleAnalysisSample = middleAnalysisSample;
                } else if (trIn.tracks[i].states[j] == SinusoidalTrack.TURNED_ON) {
                    prevMiddleAnalysisSample = SignalProcUtils.time2sample(trIn.tracks[i].times[j], trIn.fs);
                    middleSynthesisTime = SignalProcUtils.timeScaledTime(trIn.tracks[i].times[j], tScales, tScalesTimes);
                    prevMiddleSynthesisSample = SignalProcUtils.time2sample(middleSynthesisTime, trIn.fs);
                    prevExcPhase = 0.0f;
                    prevExcPhaseMod = 0.0f;
                }
                ++j;
            }
            ++i;
        }
        trMod.origDur = maxDur;
        if (trMod != null) {
            System.out.println("--- Modified track statistics ---");
            trMod.getTrackStatistics();
            SinusoidalAnalyzer.getGrossStatistics(trMod);
        }
        return trMod;
    }
}

