/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import Jampack.H;
import Jampack.Inv;
import Jampack.JampackException;
import Jampack.Parameters;
import Jampack.Times;
import Jampack.Z;
import Jampack.Zdiagmat;
import Jampack.Zmat;
import java.io.IOException;
import java.util.Arrays;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.analysis.RegularizedCepstrumEstimator;
import marytts.signalproc.analysis.RegularizedPostWarpedCepstrumEstimator;
import marytts.signalproc.analysis.RegularizedPreWarpedCepstrumEstimator;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechFrame;
import marytts.signalproc.sinusoidal.PeakMatchedSinusoidalSynthesizer;
import marytts.signalproc.sinusoidal.SinusoidalAnalysisParams;
import marytts.signalproc.sinusoidal.SinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameHarmonicPart;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartLpc;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartPseudoHarmonic;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartWaveform;
import marytts.signalproc.sinusoidal.hntm.analysis.HarmonicAndTransientAnalysisOutput;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerNoisePartWaveformSynthesizer;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmPlusTransientsSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.analysis.TransientPart;
import marytts.signalproc.sinusoidal.hntm.analysis.TransientSegment;
import marytts.signalproc.sinusoidal.hntm.analysis.pitch.HnmPitchVoicingAnalyzer;
import marytts.signalproc.sinusoidal.hntm.synthesis.HarmonicPartLinearPhaseInterpolatorSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizedSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.signalproc.sinusoidal.hntm.synthesis.hybrid.HarmonicsToTrackConverter;
import marytts.signalproc.window.GaussWindow;
import marytts.signalproc.window.Window;
import marytts.util.math.ArrayUtils;
import marytts.util.math.ComplexNumber;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class HntmAnalyzer {
    public HntmSpeechSignal analyze(short[] x, int fs, PitchReaderWriter f0) {
        double[] xDouble = ArrayUtils.copyShort2Double(x);
        return this.analyze(xDouble, fs, f0);
    }

    public HntmSpeechSignal analyze(double[] x, int fs, PitchReaderWriter f0) {
        HntmAnalyzerParams analysisParams = new HntmAnalyzerParams();
        HntmSynthesizerParams synthesisParamsBeforeNoiseAnalysis = new HntmSynthesizerParams();
        return this.analyze(x, fs, f0, null, analysisParams, synthesisParamsBeforeNoiseAnalysis, null);
    }

    public HntmSpeechSignal analyze(short[] x, int fs, PitchReaderWriter f0, Labels labels, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParamsBeforeNoiseAnalysis) {
        return this.analyze(x, fs, f0, labels, analysisParams, synthesisParamsBeforeNoiseAnalysis, (String)null);
    }

    public HntmSpeechSignal analyze(short[] x, int fs, PitchReaderWriter f0, Labels labels, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParamsBeforeNoiseAnalysis, String analysisResultsFile) {
        int pitchMarkOffset = 0;
        PitchMarks pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, fs, x.length, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, false, pitchMarkOffset);
        return this.analyze(x, fs, pm, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, ArrayUtils.copyDouble2Float(f0.contour), labels, analysisParams, synthesisParamsBeforeNoiseAnalysis, analysisResultsFile);
    }

    public HntmSpeechSignal analyze(short[] x, int fs, PitchMarks pm, double f0WindowSizeInSeconds, double f0SkipSizeInSeconds, float[] f0Contour, Labels labels, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParamsBeforeNoiseAnalysis, String analysisResultsFile) {
        double[] xDouble = ArrayUtils.copyShort2Double(x);
        return this.analyze(xDouble, fs, pm, f0WindowSizeInSeconds, f0SkipSizeInSeconds, f0Contour, labels, analysisParams, synthesisParamsBeforeNoiseAnalysis, analysisResultsFile);
    }

    public HntmSpeechSignal analyze(double[] x, int fs, PitchReaderWriter f0, Labels labels, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParamsBeforeNoiseAnalysis, String analysisResultsFile) {
        int pitchMarkOffset = 0;
        PitchMarks pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, fs, x.length, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, false, pitchMarkOffset);
        return this.analyze(x, fs, pm, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, ArrayUtils.copyDouble2Float(f0.contour), labels, analysisParams, synthesisParamsBeforeNoiseAnalysis, analysisResultsFile);
    }

    public HntmSpeechSignal analyze(double[] x, int fs, PitchMarks pm, double f0WindowSizeInSeconds, double f0SkipSizeInSeconds, float[] f0Contour, Labels labels, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParamsBeforeNoiseAnalysis, String analysisResultsFile) {
        HarmonicAndTransientAnalysisOutput output = this.analyzeHarmonicAndTransientParts(x, fs, pm, f0WindowSizeInSeconds, f0SkipSizeInSeconds, f0Contour, labels, analysisParams);
        this.analyzeNoisePart(x, output.hnmSignal, analysisParams, synthesisParamsBeforeNoiseAnalysis, output.isInTransientSegments);
        if (analysisResultsFile != null) {
            try {
                output.hnmSignal.write(analysisResultsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return output.hnmSignal;
    }

    public HarmonicAndTransientAnalysisOutput analyzeHarmonicAndTransientParts(double[] x, int fs, PitchReaderWriter f0, Labels labels, HntmAnalyzerParams analysisParams) {
        int pitchMarkOffset = 0;
        PitchMarks pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, fs, x.length, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, false, pitchMarkOffset);
        return this.analyzeHarmonicAndTransientParts(x, fs, pm, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, ArrayUtils.copyDouble2Float(f0.contour), labels, analysisParams);
    }

    public HarmonicAndTransientAnalysisOutput analyzeHarmonicAndTransientParts(double[] x, int fs, PitchMarks pm, double f0WindowSizeInSeconds, double f0SkipSizeInSeconds, float[] f0Contour, Labels labels, HntmAnalyzerParams analysisParams) {
        int i;
        HarmonicAndTransientAnalysisOutput output = new HarmonicAndTransientAnalysisOutput();
        output.hnmSignal = null;
        float originalDurationInSeconds = SignalProcUtils.sample2time(x.length, fs);
        int lpOrder = SignalProcUtils.getLPOrder(fs);
        if (pm != null) {
            boolean isVoiced;
            float[] initialF0s = ArrayUtils.subarray(f0Contour, 0, f0Contour.length);
            analysisParams.hnmPitchVoicingAnalyzerParams.f0AnalysisWindowSizeInSeconds = (float)f0WindowSizeInSeconds;
            analysisParams.hnmPitchVoicingAnalyzerParams.f0AnalysisSkipSizeInSeconds = (float)f0SkipSizeInSeconds;
            float[] maxFrequencyOfVoicings = HnmPitchVoicingAnalyzer.analyzeVoicings(x, fs, initialF0s, analysisParams.hnmPitchVoicingAnalyzerParams, analysisParams.isSilentAnalysis);
            float[] f0s = ArrayUtils.subarray(f0Contour, 0, f0Contour.length);
            double numPeriods = analysisParams.numPeriodsHarmonicsExtraction;
            double f0InHz = f0s[0];
            double assumedF0ForUnvoicedInHz = 100.0;
            if (f0InHz > 10.0) {
                isVoiced = true;
            } else {
                isVoiced = false;
                f0InHz = assumedF0ForUnvoicedInHz;
            }
            int totalFrm = pm.pitchMarks.length - 1;
            if (totalFrm > pm.pitchMarks.length - 1) {
                totalFrm = pm.pitchMarks.length - 1;
            }
            double[] frm = null;
            double[] frmWindowed = null;
            String[] transientPhonemesList = new String[]{"p", "t", "k", "pf", "ts", "tS"};
            if (analysisParams.harmonicModel == 1) {
                output.hnmSignal = new HntmSpeechSignal(totalFrm, fs, originalDurationInSeconds);
            } else if (analysisParams.harmonicModel == 2 && labels != null) {
                output.hnmSignal = new HntmPlusTransientsSpeechSignal(totalFrm, fs, originalDurationInSeconds, labels.items.length);
            }
            int numHarmonics = 0;
            ComplexNumber[] harmonics = null;
            int currentLabInd = 0;
            boolean isInTransientSegment = false;
            int transientSegmentInd = 0;
            output.isInTransientSegments = new boolean[totalFrm];
            Arrays.fill(output.isInTransientSegments, false);
            i = 0;
            while (i < totalFrm) {
                int j;
                f0InHz = pm.f0s[i];
                double T0Double = f0InHz > 10.0 ? SignalProcUtils.time2sampleDouble(1.0 / f0InHz, fs) : SignalProcUtils.time2sampleDouble(1.0 / assumedF0ForUnvoicedInHz, fs);
                int ws = (int)Math.floor(numPeriods * T0Double + 0.5);
                output.hnmSignal.frames[i].tAnalysisInSeconds = (float)pm.pitchMarks[i + 1] / (float)fs;
                if (analysisParams.harmonicModel == 2 && labels != null) {
                    while (labels.items[currentLabInd].time < (double)output.hnmSignal.frames[i].tAnalysisInSeconds) {
                        if (++currentLabInd <= labels.items.length - 1) continue;
                        currentLabInd = labels.items.length - 1;
                        break;
                    }
                    if (!isInTransientSegment) {
                        j = 0;
                        while (j < transientPhonemesList.length) {
                            if (labels.items[currentLabInd].phn.compareTo(transientPhonemesList[j]) == 0) {
                                isInTransientSegment = true;
                                ((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments[transientSegmentInd] = new TransientSegment();
                                ((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments[transientSegmentInd].startTime = Math.max(0.0f, (float)pm.pitchMarks[i] / (float)fs - analysisParams.overlapBetweenTransientAndNontransientSectionsInSeconds);
                                break;
                            }
                            ++j;
                        }
                    } else {
                        boolean isTransientPhoneme = false;
                        j = 0;
                        while (j < transientPhonemesList.length) {
                            if (labels.items[currentLabInd].phn.compareTo(transientPhonemesList[j]) == 0) {
                                isTransientPhoneme = true;
                                break;
                            }
                            ++j;
                        }
                        if (!isTransientPhoneme) {
                            float endTime = Math.min(((float)pm.pitchMarks[i] + 0.5f * (float)ws) / (float)fs + analysisParams.overlapBetweenTransientAndNontransientSectionsInSeconds, output.hnmSignal.originalDurationInSeconds);
                            int waveformStartInd = Math.max(0, SignalProcUtils.time2sample(((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments[transientSegmentInd].startTime, fs));
                            int waveformEndInd = Math.min(x.length - 1, SignalProcUtils.time2sample(endTime, fs));
                            if (waveformEndInd - waveformStartInd + 1 > 0) {
                                ((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments[transientSegmentInd].waveform = new int[waveformEndInd - waveformStartInd + 1];
                                j = waveformStartInd;
                                while (j <= waveformEndInd) {
                                    ((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments[transientSegmentInd].waveform[j - waveformStartInd] = (int)x[j];
                                    ++j;
                                }
                            }
                            ++transientSegmentInd;
                            isInTransientSegment = false;
                        }
                    }
                }
                int maxVoicingIndex = SignalProcUtils.time2frameIndex(output.hnmSignal.frames[i].tAnalysisInSeconds, analysisParams.hnmPitchVoicingAnalyzerParams.mvfAnalysisWindowSizeInSeconds, analysisParams.hnmPitchVoicingAnalyzerParams.mvfAnalysisSkipSizeInSeconds);
                maxVoicingIndex = Math.min(maxVoicingIndex, maxFrequencyOfVoicings.length - 1);
                float maxFreqOfVoicingInHz = maxFrequencyOfVoicings[maxVoicingIndex];
                output.hnmSignal.frames[i].maximumFrequencyOfVoicingInHz = f0InHz > 10.0 ? maxFreqOfVoicingInHz : 0.0f;
                numHarmonics = (int)Math.floor((double)output.hnmSignal.frames[i].maximumFrequencyOfVoicingInHz / f0InHz + 0.5);
                isVoiced = numHarmonics > 0;
                boolean bl = (double)output.hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5 * (double)fs;
                if (isInTransientSegment) {
                    output.hnmSignal.frames[i].h = null;
                    output.hnmSignal.frames[i].n = null;
                } else {
                    if (!isVoiced) {
                        f0InHz = assumedF0ForUnvoicedInHz;
                        T0Double = SignalProcUtils.time2sampleDouble(1.0 / f0InHz, fs);
                        ws = (int)Math.floor(numPeriods * T0Double + 0.5);
                    }
                    frm = new double[ws];
                    Arrays.fill(frm, 0.0);
                    int frmStartIndex = i == 0 ? 0 : SignalProcUtils.time2sample((double)output.hnmSignal.frames[i].tAnalysisInSeconds - 0.5 * numPeriods / f0InHz, fs);
                    int frmEndIndex = frmStartIndex + ws - 1;
                    int count = 0;
                    j = Math.max(0, frmStartIndex);
                    while (j < Math.min(frmEndIndex, x.length - 1)) {
                        frm[count++] = x[j];
                        ++j;
                    }
                    Window win = Window.get(analysisParams.harmonicAnalysisWindowType, ws);
                    win.normalizePeakValue(1.0f);
                    double[] wgt = win.getCoeffs();
                    if (isVoiced) {
                        if (!analysisParams.useJampackInAnalysis) {
                            harmonics = this.estimateComplexAmplitudes(frm, wgt, f0InHz, numHarmonics, fs, analysisParams.hnmPitchVoicingAnalyzerParams.lastCorrelatedHarmonicNeighbour);
                        } else {
                            try {
                                harmonics = this.estimateComplexAmplitudesJampack(frm, wgt, f0InHz, numHarmonics, fs, analysisParams.hnmPitchVoicingAnalyzerParams.lastCorrelatedHarmonicNeighbour);
                            }
                            catch (JampackException e) {
                                e.printStackTrace();
                            }
                        }
                        numHarmonics = harmonics.length;
                        output.hnmSignal.frames[i].f0InHz = (float)f0InHz;
                        output.hnmSignal.frames[i].h = new FrameHarmonicPart();
                    } else {
                        output.hnmSignal.frames[i].f0InHz = 0.0f;
                        numHarmonics = 0;
                    }
                    output.hnmSignal.frames[i].n = null;
                    if (numHarmonics > 0 && isVoiced) {
                        frmWindowed = win.apply(frm, 0);
                        LpcAnalyser.LpCoeffs lpcs = LpcAnalyser.calcLPC(frmWindowed, lpOrder, 0.0f);
                        output.hnmSignal.frames[i].n = new FrameNoisePartLpc();
                        ((FrameNoisePartLpc)output.hnmSignal.frames[i].n).setLpCoeffs(lpcs.getA(), (float)lpcs.getGain());
                        output.hnmSignal.frames[i].h.complexAmps = ArrayUtils.copy(harmonics);
                        if (i == 10) {
                            int fftSize = SignalProcUtils.getDFTSize(fs);
                            MathUtils.amp2db(SignalProcUtils.getFrameHalfMagnitudeSpectrum(frm, fftSize));
                            output.hnmSignal.frames[i].h.getDBAmps();
                            RegularizedPreWarpedCepstrumEstimator.cepstrum2dbSpectrumValues(output.hnmSignal.frames[i].h.getCeps(output.hnmSignal.frames[i].f0InHz, fs, analysisParams), SignalProcUtils.halfSpectrumSize(fftSize) - 1, fs);
                        }
                    }
                }
                if (!isVoiced || !isInTransientSegment) {
                    // empty if block
                }
                output.isInTransientSegments[i] = isInTransientSegment;
                if (!analysisParams.isSilentAnalysis) {
                    if (analysisParams.harmonicModel == 1) {
                        System.out.println("Harmonic analysis completed at " + String.valueOf(output.hnmSignal.frames[i].tAnalysisInSeconds) + "s. for frame " + String.valueOf(i + 1) + " of " + String.valueOf(totalFrm));
                    } else if (analysisParams.harmonicModel == 2) {
                        System.out.println("Harmonic and transient analysis completed at " + String.valueOf(output.hnmSignal.frames[i].tAnalysisInSeconds) + "s. for frame " + String.valueOf(i + 1) + " of " + String.valueOf(totalFrm));
                    }
                }
                ++i;
            }
            i = 0;
            while (i < output.hnmSignal.frames.length) {
                output.hnmSignal.frames[i].deltaAnalysisTimeInSeconds = i == 0 ? output.hnmSignal.frames[i].tAnalysisInSeconds : (i == output.hnmSignal.frames.length - 1 ? output.hnmSignal.originalDurationInSeconds - output.hnmSignal.frames[i].tAnalysisInSeconds : output.hnmSignal.frames[i + 1].tAnalysisInSeconds - output.hnmSignal.frames[i].tAnalysisInSeconds);
                ++i;
            }
        }
        if (output.hnmSignal instanceof HntmPlusTransientsSpeechSignal) {
            int numTransientSegments = 0;
            i = 0;
            while (i < ((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments.length) {
                if (((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments[i] != null) {
                    ++numTransientSegments;
                }
                ++i;
            }
            if (numTransientSegments > 0) {
                TransientPart tempPart = new TransientPart(numTransientSegments);
                int count = 0;
                i = 0;
                while (i < ((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments.length) {
                    if (((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments[i] != null) {
                        tempPart.segments[count++] = new TransientSegment(((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients.segments[i]);
                        if (count >= numTransientSegments) break;
                    }
                    ++i;
                }
                ((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients = new TransientPart(tempPart);
            } else {
                ((HntmPlusTransientsSpeechSignal)output.hnmSignal).transients = null;
            }
        }
        if (HntmAnalyzerParams.UNWRAP_PHASES_ALONG_HARMONICS_AFTER_ANALYSIS) {
            HntmAnalyzer.unwrapPhasesAlongHarmonics(output.hnmSignal);
        }
        return output;
    }

    public void analyzeNoisePart(double[] originalSignal, HntmSpeechSignal hnmSignal, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParamsForNoiseAnalysis, boolean[] isInTransientSegments) {
        HntmSynthesizedSignal s = new HntmSynthesizedSignal();
        boolean useHarmonicAmplitudesDirectlyTemp = analysisParams.useHarmonicAmplitudesDirectly;
        if (!analysisParams.useHarmonicAmplitudesDirectly) {
            analysisParams.useHarmonicAmplitudesDirectly = true;
        }
        if (analysisParams.harmonicSynthesisMethodBeforeNoiseAnalysis == 1) {
            HarmonicPartLinearPhaseInterpolatorSynthesizer hs = new HarmonicPartLinearPhaseInterpolatorSynthesizer(hnmSignal, analysisParams, synthesisParamsForNoiseAnalysis);
            s.harmonicPart = hs.synthesizeAll();
        } else if (analysisParams.harmonicSynthesisMethodBeforeNoiseAnalysis == 2) {
            SinusoidalTracks st = HarmonicsToTrackConverter.convert(hnmSignal, analysisParams);
            PeakMatchedSinusoidalSynthesizer ss = new PeakMatchedSinusoidalSynthesizer(hnmSignal.samplingRateInHz);
            s.harmonicPart = ss.synthesize(st, true);
        }
        analysisParams.useHarmonicAmplitudesDirectly = useHarmonicAmplitudesDirectlyTemp;
        double[] xHarmTransResynth = SignalProcUtils.addSignals(s.harmonicPart, s.transientPart);
        double[] xDiff = SignalProcUtils.addSignals(originalSignal, 1.0, xHarmTransResynth, -1.0);
        SignalProcUtils.sample2time(xDiff.length, hnmSignal.samplingRateInHz);
        int lpOrder = analysisParams.computeNoisePartLpOrderFromSamplingRate ? SignalProcUtils.getLPOrder(hnmSignal.samplingRateInHz) : analysisParams.noisePartLpOrder;
        double[] xPreemphasized = null;
        xPreemphasized = (double)analysisParams.preemphasisCoefNoise > 0.0 ? SignalProcUtils.applyPreemphasis(xDiff, analysisParams.preemphasisCoefNoise) : ArrayUtils.copy(xDiff);
        if (hnmSignal != null) {
            int i;
            boolean isVoiced;
            float cfr_ignored_0 = analysisParams.numPeriodsHarmonicsExtraction;
            double f0InHz = hnmSignal.frames[0].f0InHz;
            double assumedF0ForUnvoicedInHz = 100.0;
            if (f0InHz > 10.0) {
                isVoiced = true;
            } else {
                isVoiced = false;
                f0InHz = assumedF0ForUnvoicedInHz;
            }
            int wsNoise = SignalProcUtils.time2sample(analysisParams.noiseAnalysisWindowDurationInSeconds, hnmSignal.samplingRateInHz);
            if (wsNoise % 2 == 0) {
                ++wsNoise;
            }
            Window winNoise = Window.get(analysisParams.noiseAnalysisWindowType, wsNoise);
            winNoise.normalizePeakValue(1.0f);
            double[] wgtNoise = winNoise.getCoeffs();
            double[] wgtSquaredNoise = new double[wgtNoise.length];
            int j = 0;
            while (j < wgtNoise.length) {
                wgtSquaredNoise[j] = wgtNoise[j] * wgtNoise[j];
                ++j;
            }
            int fftSizeNoise = SignalProcUtils.getDFTSize(hnmSignal.samplingRateInHz);
            int totalFrm = hnmSignal.frames.length;
            double[] frmNoise = new double[wsNoise];
            int numHarmonics = 0;
            int prevNumHarmonics = 0;
            ComplexNumber[] noiseHarmonics = null;
            int numNoiseHarmonics = (int)Math.floor(0.5 * (double)hnmSignal.samplingRateInHz / (double)analysisParams.noiseF0InHz + 0.5);
            double[] freqsInHzNoise = new double[numNoiseHarmonics];
            j = 0;
            while (j < numNoiseHarmonics) {
                freqsInHzNoise[j] = analysisParams.noiseF0InHz * (float)(j + 1);
                ++j;
            }
            double[][] M = null;
            double[][] MTransW = null;
            double[][] MTransWM = null;
            double[][] lambdaR = null;
            double[][] inverted = null;
            if (analysisParams.noiseModel == 3) {
                if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                    M = RegularizedPreWarpedCepstrumEstimator.precomputeM(freqsInHzNoise, hnmSignal.samplingRateInHz, analysisParams.noisePartCepstrumOrder);
                } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                    M = RegularizedPostWarpedCepstrumEstimator.precomputeM(freqsInHzNoise, hnmSignal.samplingRateInHz, analysisParams.noisePartCepstrumOrder);
                }
                if (M != null) {
                    MTransW = RegularizedCepstrumEstimator.precomputeMTransW(M, null);
                    MTransWM = RegularizedCepstrumEstimator.precomputeMTransWM(MTransW, M);
                    lambdaR = RegularizedCepstrumEstimator.precomputeLambdaR(analysisParams.regularizedCepstrumEstimationLambdaNoise, analysisParams.noisePartCepstrumOrder);
                    inverted = RegularizedCepstrumEstimator.precomputeInverted(MTransWM, lambdaR);
                }
            }
            int waveformNoiseStartInd = 0;
            int waveformNoiseEndInd = 0;
            double[][] frameWaveforms = null;
            if (analysisParams.noiseModel == 1 || analysisParams.noiseModel == 4 || analysisParams.noiseModel == 5) {
                frameWaveforms = new double[totalFrm][];
                i = 0;
                while (i < totalFrm) {
                    frameWaveforms[i] = null;
                    ++i;
                }
            }
            i = 0;
            while (i < totalFrm) {
                boolean isNoised;
                f0InHz = hnmSignal.frames[i].f0InHz;
                if (f0InHz > 10.0) {
                    SignalProcUtils.time2sampleDouble(1.0 / f0InHz, hnmSignal.samplingRateInHz);
                    numHarmonics = (int)Math.floor((double)hnmSignal.frames[i].maximumFrequencyOfVoicingInHz / f0InHz + 0.5);
                } else {
                    SignalProcUtils.time2sampleDouble(1.0 / assumedF0ForUnvoicedInHz, hnmSignal.samplingRateInHz);
                    numHarmonics = 0;
                }
                isVoiced = numHarmonics > 0;
                boolean bl = isNoised = (double)hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5 * (double)hnmSignal.samplingRateInHz;
                if (i > 0) {
                    prevNumHarmonics = (int)Math.floor((double)hnmSignal.frames[i - 1].maximumFrequencyOfVoicingInHz / f0InHz + 0.5);
                    boolean bl2 = prevNumHarmonics > 0;
                }
                if (!isInTransientSegments[i]) {
                    int noiseFrmStartInd;
                    if (!isVoiced) {
                        f0InHz = assumedF0ForUnvoicedInHz;
                    }
                    SignalProcUtils.time2sampleDouble(1.0 / f0InHz, hnmSignal.samplingRateInHz);
                    Arrays.fill(frmNoise, 0.0);
                    j = noiseFrmStartInd = Math.max(0, SignalProcUtils.time2sample(hnmSignal.frames[i].tAnalysisInSeconds - 0.5f * analysisParams.noiseAnalysisWindowDurationInSeconds, hnmSignal.samplingRateInHz));
                    while (j < Math.min(noiseFrmStartInd + wsNoise, xDiff.length)) {
                        frmNoise[j - noiseFrmStartInd] = xPreemphasized[j];
                        ++j;
                    }
                    if (isNoised) {
                        double[] y = null;
                        if (hnmSignal.frames[i].maximumFrequencyOfVoicingInHz - analysisParams.overlapBetweenHarmonicAndNoiseRegionsInHz > 0.0f) {
                            y = SignalProcUtils.fdFilter(frmNoise, hnmSignal.frames[i].maximumFrequencyOfVoicingInHz - analysisParams.overlapBetweenHarmonicAndNoiseRegionsInHz, 0.5f * (float)hnmSignal.samplingRateInHz, hnmSignal.samplingRateInHz, fftSizeNoise);
                        }
                        if (analysisParams.hpfBeforeNoiseAnalysis && y != null) {
                            frmNoise = ArrayUtils.copy(y);
                        }
                        frmNoise = SignalProcUtils.replaceNaNsWith(frmNoise, 0.0);
                        frmNoise = MathUtils.add(frmNoise, MathUtils.random(frmNoise.length, -1.0E-20, 1.0E-20));
                        float origAverageSampleEnergy = (float)SignalProcUtils.getAverageSampleEnergy(frmNoise);
                        float origNoiseStd = (float)MathUtils.standardDeviation(frmNoise);
                        if (analysisParams.noiseModel == 2 || analysisParams.noiseModel == 4 && isVoiced || analysisParams.noiseModel == 5 && !isVoiced) {
                            frmNoise = winNoise.apply(frmNoise, 0);
                            LpcAnalyser.LpCoeffs lpcs = LpcAnalyser.calcLPC(frmNoise, lpOrder, 0.0f);
                            hnmSignal.frames[i].n = new FrameNoisePartLpc();
                            ((FrameNoisePartLpc)hnmSignal.frames[i].n).setLpCoeffs(lpcs.getA(), (float)lpcs.getGain());
                            ((FrameNoisePartLpc)hnmSignal.frames[i].n).origAverageSampleEnergy = origAverageSampleEnergy;
                            ((FrameNoisePartLpc)hnmSignal.frames[i].n).origNoiseStd = origNoiseStd;
                        } else if (analysisParams.noiseModel == 3) {
                            noiseHarmonics = this.estimateComplexAmplitudes(frmNoise, wgtNoise, analysisParams.noiseF0InHz, numNoiseHarmonics, hnmSignal.samplingRateInHz, analysisParams.hnmPitchVoicingAnalyzerParams.lastCorrelatedHarmonicNeighbour);
                            double[] linearAmpsNoise = new double[numNoiseHarmonics];
                            j = 0;
                            while (j < numNoiseHarmonics) {
                                linearAmpsNoise[j] = MathUtils.magnitudeComplex(noiseHarmonics[j]);
                                ++j;
                            }
                            hnmSignal.frames[i].n = new FrameNoisePartPseudoHarmonic();
                            if (!analysisParams.useNoiseAmplitudesDirectly) {
                                double[] noiseWeights = null;
                                if (analysisParams.useWeightingInRegularizedCesptrumEstimationNoise) {
                                    GaussWindow g = new GaussWindow(2 * linearAmpsNoise.length);
                                    g.normalizeRange(0.1f, 1.0f);
                                    noiseWeights = g.getCoeffsRightHalf();
                                    if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                                        ((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i].n).ceps = RegularizedPreWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmpsNoise, freqsInHzNoise, hnmSignal.samplingRateInHz, analysisParams.noisePartCepstrumOrder, noiseWeights, analysisParams.regularizedCepstrumEstimationLambdaNoise);
                                    } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                                        ((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i].n).ceps = RegularizedPostWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmpsNoise, freqsInHzNoise, hnmSignal.samplingRateInHz, analysisParams.noisePartCepstrumOrder, noiseWeights, analysisParams.regularizedCepstrumEstimationLambdaNoise);
                                    }
                                } else {
                                    ((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i].n).ceps = RegularizedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmpsNoise, MTransW, inverted);
                                }
                            } else {
                                ((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i].n).ceps = ArrayUtils.subarrayDouble2Float(linearAmpsNoise, 0, linearAmpsNoise.length);
                            }
                        } else if (analysisParams.noiseModel == 1 || analysisParams.noiseModel == 4 && !isVoiced || analysisParams.noiseModel == 5 && isVoiced) {
                            waveformNoiseEndInd = i < totalFrm - 1 ? Math.max(0, SignalProcUtils.time2sample(hnmSignal.frames[i + 1].tAnalysisInSeconds, hnmSignal.samplingRateInHz)) : SignalProcUtils.time2sample(hnmSignal.originalDurationInSeconds, hnmSignal.samplingRateInHz);
                            frameWaveforms[i] = ArrayUtils.copy(frmNoise);
                            if (!analysisParams.overlapNoiseWaveformModel) {
                                frameWaveforms[i] = ArrayUtils.subarray(frameWaveforms[i], 0, waveformNoiseEndInd - waveformNoiseStartInd + 1);
                            }
                            if (isVoiced && analysisParams.hpfBeforeNoiseAnalysis && analysisParams.decimateNoiseWaveform) {
                                frameWaveforms[i] = SignalProcUtils.decimate(frameWaveforms[i], 0.5 * (double)hnmSignal.samplingRateInHz / (0.5 * (double)hnmSignal.samplingRateInHz - (double)hnmSignal.frames[i].maximumFrequencyOfVoicingInHz));
                            }
                            waveformNoiseStartInd = waveformNoiseEndInd + 1;
                        }
                    } else {
                        hnmSignal.frames[i].n = null;
                    }
                }
                if (!analysisParams.isSilentAnalysis) {
                    System.out.println("Noise analysis completed at " + String.valueOf(hnmSignal.frames[i].tAnalysisInSeconds) + "s. for frame " + String.valueOf(i + 1) + " of " + String.valueOf(totalFrm));
                }
                ++i;
            }
            if (analysisParams.noiseModel == 1 || analysisParams.noiseModel == 4 || analysisParams.noiseModel == 5) {
                double[] noisePartWaveform = HntmAnalyzerNoisePartWaveformSynthesizer.synthesize(hnmSignal, frameWaveforms, analysisParams, synthesisParamsForNoiseAnalysis);
                HntmAnalyzer.packNoisePartWaveforms(hnmSignal, noisePartWaveform);
            }
        }
    }

    public static void packNoisePartWaveforms(HntmSpeechSignal hnmSignal, double[] noisePartWaveform) {
        int frameStartInd = 0;
        double[] frameWaveform = null;
        int i = 0;
        while (i < hnmSignal.frames.length) {
            int frameEndInd = i < hnmSignal.frames.length - 1 ? SignalProcUtils.time2sample(hnmSignal.frames[i].tAnalysisInSeconds, hnmSignal.samplingRateInHz) : noisePartWaveform.length - 1;
            frameWaveform = ArrayUtils.subarray(noisePartWaveform, frameStartInd, frameEndInd - frameStartInd + 1);
            hnmSignal.frames[i].n = new FrameNoisePartWaveform(frameWaveform);
            frameStartInd = frameEndInd + 1;
            ++i;
        }
    }

    public ComplexNumber[] estimateComplexAmplitudes(double[] s, double[] wgt, double f0InHz, int L, double samplingRateInHz, int lastCorrelatedHarmonicNeighbour) {
        int i;
        double tShift;
        ComplexNumber[] xpart = null;
        int M = s.length;
        if (M % 2 == 1) {
            int cfr_ignored_0 = (M - 1) / 2;
            tShift = 0.0;
        } else {
            int cfr_ignored_1 = M / 2;
            tShift = 0.5 / samplingRateInHz;
        }
        ComplexNumber[][] B = new ComplexNumber[M][2 * L + 1];
        ComplexNumber[][] W = MathUtils.diagonalComplexMatrix(wgt);
        int k = -L;
        while (k <= L) {
            int t = 0;
            while (t < M) {
                double omega = Math.PI * 2 * (double)k * f0InHz * (((double)t + tShift) / samplingRateInHz);
                B[t][k + L] = new ComplexNumber((float)Math.cos(omega), (float)Math.sin(omega));
                ++t;
            }
            ++k;
        }
        ComplexNumber[][] BTWTW = MathUtils.matrixProduct(MathUtils.hermitianTranspoze(B), MathUtils.transpoze(W));
        BTWTW = MathUtils.matrixProduct(BTWTW, W);
        ComplexNumber[] b = MathUtils.matrixProduct(BTWTW, s);
        ComplexNumber[][] R = MathUtils.matrixProduct(BTWTW, B);
        if (lastCorrelatedHarmonicNeighbour > -1 && lastCorrelatedHarmonicNeighbour < L) {
            i = 0;
            while (i < 2 * L + 1) {
                k = 0;
                while (k < 2 * L + 1) {
                    if (i > k + lastCorrelatedHarmonicNeighbour || k > i + lastCorrelatedHarmonicNeighbour) {
                        R[i][k] = new ComplexNumber(0.0f, 0.0f);
                    }
                    ++k;
                }
                ++i;
            }
        }
        ComplexNumber[] r = new ComplexNumber[R.length];
        i = 0;
        while (i < R.length) {
            r[i] = new ComplexNumber(R[i][0]);
            ++i;
        }
        ComplexNumber[] x = MathUtils.levinson(r, MathUtils.multiplyComplex(b, 1.0));
        xpart = new ComplexNumber[L];
        k = L + 1;
        while (k <= 2 * L) {
            xpart[k - (L + 1)] = new ComplexNumber(2.0f * x[k].real, 2.0f * x[k].imag);
            ++k;
        }
        return xpart;
    }

    public ComplexNumber[] estimateComplexAmplitudesJampack(double[] frm, double[] wgt, double f0InHz, int L, double samplingRateInHz, int lastCorrelatedHarmonicNeighbour) throws JampackException {
        double tShift;
        if (Parameters.getBaseIndex() != 0) {
            Parameters.setBaseIndex((int)0);
        }
        ComplexNumber[] xpart = null;
        int M = frm.length;
        if (M % 2 == 1) {
            int cfr_ignored_0 = (M - 1) / 2;
            tShift = 0.0;
        } else {
            int cfr_ignored_1 = M / 2;
            tShift = 0.5 / samplingRateInHz;
        }
        Zmat B = new Zmat(M, 2 * L + 1);
        Zdiagmat W = new Zdiagmat(wgt.length);
        int i = 0;
        while (i < wgt.length) {
            W.put(i, new Z(wgt[i], 0.0));
            ++i;
        }
        int k = -L;
        while (k <= L) {
            int t = 0;
            while (t < M) {
                double omega = Math.PI * 2 * (double)k * f0InHz * (((double)t + tShift) / samplingRateInHz);
                B.put(t, k + L, new Z(Math.cos(omega), Math.sin(omega)));
                ++t;
            }
            ++k;
        }
        Zmat s = new Zmat(frm.length, 1);
        i = 0;
        while (i < frm.length) {
            s.put(i, 0, new Z(frm[i], 0.0));
            ++i;
        }
        Zmat BT = H.o((Zmat)B);
        Zmat BTWTW = Times.o((Zmat)BT, (Zdiagmat)W);
        BTWTW = Times.o((Zmat)BTWTW, (Zdiagmat)W);
        Zmat b = Times.o((Zmat)BTWTW, (Zmat)s);
        Zmat R = Times.o((Zmat)BTWTW, (Zmat)B);
        if (lastCorrelatedHarmonicNeighbour > -1 && lastCorrelatedHarmonicNeighbour < L) {
            i = 0;
            while (i < 2 * L + 1) {
                k = 0;
                while (k < 2 * L + 1) {
                    if (i > k + lastCorrelatedHarmonicNeighbour || k > i + lastCorrelatedHarmonicNeighbour) {
                        R.put(i, k, new Z(0.0, 0.0));
                    }
                    ++k;
                }
                ++i;
            }
        }
        Zmat invR = Inv.o((Zmat)R);
        Zmat x = Times.o((Zmat)invR, (Zmat)b);
        xpart = new ComplexNumber[L];
        k = L + 1;
        while (k <= 2 * L) {
            xpart[k - (L + 1)] = new ComplexNumber(2.0 * x.get((int)k, (int)0).re, 2.0 * x.get((int)k, (int)0).im);
            ++k;
        }
        return xpart;
    }

    public ComplexNumber[] estimateComplexAmplitudesTD(double[] x, double f0InHz, int L, double samplingRateInHz) {
        int N = x.length;
        double[][] Q = new double[N][2 * L];
        double w0InRadians = SignalProcUtils.hz2radian(f0InHz, (int)samplingRateInHz);
        int i = 0;
        while (i < N) {
            int j = 1;
            while (j <= L) {
                Q[i][j - 1] = Math.cos((double)(i * j) * w0InRadians);
                ++j;
            }
            j = L + 1;
            while (j <= 2 * L) {
                Q[i][j - 1] = Math.sin((double)(i * (j - L)) * w0InRadians);
                ++j;
            }
            ++i;
        }
        double[][] QT = MathUtils.transpoze(Q);
        double[][] QTQInv = MathUtils.inverse(MathUtils.matrixProduct(QT, Q));
        double[] hopt = MathUtils.matrixProduct(MathUtils.matrixProduct(QTQInv, QT), x);
        ComplexNumber[] xpart = new ComplexNumber[L];
        i = 0;
        while (i < L) {
            xpart[i] = new ComplexNumber((float)hopt[i], (float)hopt[i + L]);
            ++i;
        }
        return xpart;
    }

    public ComplexNumber[] estimateComplexAmplitudesUncorrelated(double[] frm, double[] wgtSquared, int L, double f0InHz, double samplingRateInHz) {
        double tShift;
        int M = frm.length;
        if (M % 2 == 1) {
            int cfr_ignored_0 = (M - 1) / 2;
            tShift = 0.0;
        } else {
            int cfr_ignored_1 = M / 2;
            tShift = 0.5 / samplingRateInHz;
        }
        double denum = 0.0;
        int t = 0;
        while (t < M) {
            denum += wgtSquared[t];
            ++t;
        }
        ComplexNumber[] Ak = new ComplexNumber[L];
        int k = 1;
        while (k <= L) {
            Ak[k - 1] = new ComplexNumber(0.0f, 0.0f);
            t = 0;
            while (t < M) {
                double omega = Math.PI * -2 * (double)k * f0InHz * (((double)t + tShift) / samplingRateInHz);
                ComplexNumber tmp = new ComplexNumber((float)(wgtSquared[t] * frm[t] * Math.cos(omega)), (float)(wgtSquared[t] * frm[t] * Math.sin(omega)));
                Ak[k - 1] = MathUtils.addComplex(Ak[k - 1], tmp);
                ++t;
            }
            Ak[k - 1] = MathUtils.divide(Ak[k - 1], denum);
            ++k;
        }
        return Ak;
    }

    public ComplexNumber[] estimateComplexAmplitudesPeakPicking(double[] windowedFrm, int spectralEnvelopeType, boolean isVoiced, float f0, float maximumFreqOfVoicingInHz, boolean bEstimateHNMVoicing, SinusoidalAnalysisParams params) {
        ComplexNumber[] x = null;
        int numHarmonics = (int)Math.floor((double)(maximumFreqOfVoicingInHz / f0) + 0.5);
        if (numHarmonics > 0) {
            float[] initialPeakLocationsInHz = new float[numHarmonics];
            int i = 0;
            while (i < numHarmonics) {
                initialPeakLocationsInHz[i] = (float)(i + 1) * f0;
                ++i;
            }
            NonharmonicSinusoidalSpeechFrame nhs = SinusoidalAnalyzer.analyze_frame(windowedFrm, false, spectralEnvelopeType, isVoiced, f0, maximumFreqOfVoicingInHz, bEstimateHNMVoicing, params, initialPeakLocationsInHz);
            x = new ComplexNumber[nhs.sinusoids.length];
            int i2 = 0;
            while (i2 < nhs.sinusoids.length) {
                x[i2] = MathUtils.ampPhase2ComplexNumber(nhs.sinusoids[i2].amp, nhs.sinusoids[i2].phase);
                ++i2;
            }
        }
        return x;
    }

    public ComplexNumber[] estimateComplexAmplitudesSplitOptimization(double[] x, double[] w, double f0InHz, int L, double samplingRateInHz) {
        int j;
        int M = x.length;
        if (M % 2 != 1) {
            System.out.println("Error! Frame length should be odd...");
            return null;
        }
        int N = (M - 1) / 2;
        double w0InRadians = SignalProcUtils.hz2radian(f0InHz, (int)samplingRateInHz);
        double[][] W = MathUtils.diagonalMatrix(w);
        double[][] B = new double[M][2 * L + 1];
        int i = 1;
        while (i <= L) {
            j = -N;
            while (j <= N) {
                B[j + N][2 * (i - 1)] = Math.cos((double)(i * j) * w0InRadians);
                B[j + N][2 * (i - 1) + 1] = Math.sin((double)(i * j) * w0InRadians);
                ++j;
            }
            ++i;
        }
        j = -N;
        while (j <= N) {
            B[j + N][2 * L] = 1.0;
            ++j;
        }
        double[][] BTWT = MathUtils.matrixProduct(MathUtils.transpoze(B), MathUtils.transpoze(W));
        double[] Ws = MathUtils.matrixProduct(W, x);
        double[] b = MathUtils.matrixProduct(BTWT, Ws);
        double[][] Aodd = new double[L + 1][L + 1];
        double[][] Aeven = new double[L][L];
        double[] r = new double[2 * L + 1];
        i = 0;
        while (i <= 2 * L) {
            r[i] = 0.0;
            int n = 1;
            while (n <= N) {
                int n2 = i;
                r[n2] = r[n2] + w[n + N] * w[n + N] * Math.cos((double)(i * n) * w0InRadians);
                ++n;
            }
            ++i;
        }
        i = 1;
        while (i <= L) {
            j = 1;
            while (j <= L) {
                Aeven[i - 1][j - 1] = r[Math.abs(i - j)] - r[i + j];
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= L) {
            j = 1;
            while (j <= L) {
                Aodd[i - 1][j - 1] = r[Math.abs(i - j)] - r[i + j];
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= L) {
            Aodd[i - 1][L] = 2.0 * r[i] + w[N] * w[N];
            ++i;
        }
        Aodd[L][L] = 2.0 * r[0] + w[N] * w[N];
        double[] bodd = new double[L + 1];
        double[] beven = new double[L];
        i = 0;
        while (i < L + 1) {
            bodd[i] = b[2 * i];
            ++i;
        }
        i = 0;
        while (i < L) {
            beven[i] = b[2 * i + 1];
            ++i;
        }
        double[] cSol = MathUtils.matrixProduct(MathUtils.inverse(Aodd), bodd);
        double[] sSol = MathUtils.matrixProduct(MathUtils.inverse(Aeven), beven);
        ComplexNumber[] xpart = null;
        xpart = new ComplexNumber[L];
        int k = 1;
        while (k <= L) {
            xpart[k - 1] = new ComplexNumber((float)cSol[k - 1], (float)(-1.0 * sSol[k - 1]));
            ++k;
        }
        return xpart;
    }

    public static double[][] unwrapPhasesAlongHarmonics(HntmSpeechSignal hntmSignal) {
        double[] maximumFrequencyOfVoicingsInHz = hntmSignal.getMaximumFrequencyOfVoicings();
        double[][] phases = hntmSignal.getPhasesInRadians();
        double[][] newPhases = null;
        if (phases != null) {
            int maxNumHarmonics = 0;
            int totalFrames = maximumFrequencyOfVoicingsInHz.length;
            assert (phases.length == totalFrames);
            int i = 0;
            while (i < totalFrames) {
                int numHarmonicsCurrentFrame;
                if (maximumFrequencyOfVoicingsInHz[i] > 0.0 && phases[i] != null && (numHarmonicsCurrentFrame = phases.length) > maxNumHarmonics) {
                    maxNumHarmonics = numHarmonicsCurrentFrame;
                }
                ++i;
            }
            double[] dphaseks = new double[maxNumHarmonics];
            Arrays.fill(dphaseks, 0.0);
            newPhases = new double[phases.length][];
            i = 0;
            while (i < phases.length) {
                if (phases[i] != null) {
                    newPhases[i] = new double[phases[i].length];
                }
                ++i;
            }
            i = 0;
            while (i < totalFrames) {
                if (maximumFrequencyOfVoicingsInHz[i] > 0.0 && phases[i] != null) {
                    System.arraycopy(phases[i], 0, newPhases[i], 0, phases[i].length);
                    int k = 1;
                    while (k < phases[i].length - 1) {
                        boolean isPrevTrackVoiced = false;
                        if (i > 0 && phases[i - 1] != null && phases[i - 1].length > k) {
                            isPrevTrackVoiced = true;
                        }
                        if (!isPrevTrackVoiced) {
                            dphaseks[k - 1] = phases[i][k] - phases[i][k - 1];
                        }
                        int Mk = (int)Math.floor((dphaseks[k - 1] + phases[i][k] - phases[i][k + 1]) / (Math.PI * 2) + 0.5);
                        double[] dArray = newPhases[i];
                        int n = k + 1;
                        dArray[n] = dArray[n] + (double)Mk * (Math.PI * 2);
                        dphaseks[k] = newPhases[i][k + 1] - phases[i][k];
                        ++k;
                    }
                }
                ++i;
            }
        }
        return newPhases;
    }
}

