/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import java.util.Arrays;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartWaveform;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.signalproc.window.Window;
import marytts.util.math.ArrayUtils;
import marytts.util.signal.SignalProcUtils;

public class HntmAnalyzerNoisePartWaveformSynthesizer {
    public static double[] synthesize(HntmSpeechSignal hnmSignal, double[][] frameWaveforms, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParams) {
        double[] noisePart = null;
        float tsi = 0.0f;
        int startIndex = 0;
        int outputLen = SignalProcUtils.time2sample(hnmSignal.originalDurationInSeconds, hnmSignal.samplingRateInHz);
        boolean isNoised = false;
        int i = 0;
        while (i < hnmSignal.frames.length) {
            if (hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz && frameWaveforms[i] != null) {
                isNoised = true;
                break;
            }
            ++i;
        }
        if (isNoised) {
            noisePart = new double[outputLen];
            Arrays.fill(noisePart, 0.0);
            double[] winWgtSum = new double[outputLen];
            Arrays.fill(winWgtSum, 0.0);
            int windowType = 1;
            int fftSizeNoise = SignalProcUtils.getDFTSize(hnmSignal.samplingRateInHz);
            SignalProcUtils.time2sample(synthesisParams.noiseSynthesisTransitionOverlapInSeconds, hnmSignal.samplingRateInHz);
            int wsNoise = SignalProcUtils.time2sample(analysisParams.noiseAnalysisWindowDurationInSeconds, hnmSignal.samplingRateInHz);
            if (wsNoise % 2 == 1) {
                ++wsNoise;
            }
            int halfWsNoise = wsNoise / 2;
            double[] y = new double[wsNoise];
            Window winNoise = Window.get(windowType, wsNoise);
            winNoise.normalizePeakValue(1.0f);
            double[] wgt = winNoise.getCoeffs();
            i = 0;
            while (i < hnmSignal.frames.length) {
                boolean isVoiced = hnmSignal.frames[i].h != null && hnmSignal.frames[i].maximumFrequencyOfVoicingInHz > 0.0f;
                if (i >= hnmSignal.frames.length - 1 || hnmSignal.frames[i + 1].h == null || hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz > 0.0f) {
                    // empty if block
                }
                if (i <= 0 || !(hnmSignal.frames[i - 1].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz) || frameWaveforms[i - 1] != null) {
                    // empty if block
                }
                isNoised = frameWaveforms[i] != null && hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                if (i >= hnmSignal.frames.length - 1 || !(hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz) || frameWaveforms[i + 1] != null) {
                    // empty if block
                }
                tsi = i == 0 ? 0.0f : Math.max(0.0f, hnmSignal.frames[i].tAnalysisInSeconds - 0.5f * analysisParams.noiseAnalysisWindowDurationInSeconds);
                startIndex = SignalProcUtils.time2sample(tsi, hnmSignal.samplingRateInHz);
                if (isNoised && frameWaveforms[i] != null) {
                    if (analysisParams.overlapNoiseWaveformModel) {
                        y = ArrayUtils.copy(frameWaveforms[i]);
                        if (isVoiced && analysisParams.hpfBeforeNoiseAnalysis && analysisParams.decimateNoiseWaveform) {
                            y = SignalProcUtils.interpolate(y, 0.5 * (double)hnmSignal.samplingRateInHz / (0.5 * (double)hnmSignal.samplingRateInHz - (double)hnmSignal.frames[i].maximumFrequencyOfVoicingInHz));
                        }
                    } else {
                        boolean isTmpVoiced;
                        int currentFrameInd = i;
                        int count = 0;
                        Arrays.fill(y, 0.0);
                        double[] temp = ArrayUtils.copy(frameWaveforms[currentFrameInd]);
                        if (isVoiced && analysisParams.hpfBeforeNoiseAnalysis && analysisParams.decimateNoiseWaveform) {
                            temp = SignalProcUtils.interpolate(temp, 0.5 * (double)hnmSignal.samplingRateInHz / (0.5 * (double)hnmSignal.samplingRateInHz - (double)hnmSignal.frames[currentFrameInd].maximumFrequencyOfVoicingInHz));
                        }
                        int count2 = temp.length - 1;
                        while (count < halfWsNoise) {
                            if (count2 < 0) {
                                if (--currentFrameInd < 0 || hnmSignal.frames[currentFrameInd].n == null) break;
                                temp = ArrayUtils.copy(frameWaveforms[currentFrameInd]);
                                isTmpVoiced = false;
                                if (hnmSignal.frames[currentFrameInd].h != null && hnmSignal.frames[currentFrameInd].maximumFrequencyOfVoicingInHz > 0.0f) {
                                    isTmpVoiced = true;
                                }
                                if (isTmpVoiced && analysisParams.hpfBeforeNoiseAnalysis && analysisParams.decimateNoiseWaveform) {
                                    temp = SignalProcUtils.interpolate(temp, 0.5 * (double)hnmSignal.samplingRateInHz / (0.5 * (double)hnmSignal.samplingRateInHz - (double)hnmSignal.frames[currentFrameInd].maximumFrequencyOfVoicingInHz));
                                }
                                count2 = temp.length - 1;
                            }
                            y[halfWsNoise - count - 1] = temp[count2];
                            ++count;
                            --count2;
                        }
                        currentFrameInd = i + 1;
                        count = halfWsNoise;
                        if (currentFrameInd < hnmSignal.frames.length && hnmSignal.frames[currentFrameInd].n != null) {
                            temp = ((FrameNoisePartWaveform)hnmSignal.frames[currentFrameInd].n).waveform2Doubles();
                            isTmpVoiced = false;
                            if (hnmSignal.frames[currentFrameInd].h != null && hnmSignal.frames[currentFrameInd].maximumFrequencyOfVoicingInHz > 0.0f) {
                                isTmpVoiced = true;
                            }
                            if (isTmpVoiced && analysisParams.hpfBeforeNoiseAnalysis && analysisParams.decimateNoiseWaveform) {
                                temp = SignalProcUtils.interpolate(temp, 0.5 * (double)hnmSignal.samplingRateInHz / (0.5 * (double)hnmSignal.samplingRateInHz - (double)hnmSignal.frames[currentFrameInd].maximumFrequencyOfVoicingInHz));
                            }
                            count2 = 0;
                            while (count < wsNoise) {
                                if (count2 >= temp.length) {
                                    if (++currentFrameInd > hnmSignal.frames.length - 1 || hnmSignal.frames[currentFrameInd].n == null) break;
                                    temp = ((FrameNoisePartWaveform)hnmSignal.frames[currentFrameInd].n).waveform2Doubles();
                                    isTmpVoiced = false;
                                    if (hnmSignal.frames[currentFrameInd].h != null && hnmSignal.frames[currentFrameInd].maximumFrequencyOfVoicingInHz > 0.0f) {
                                        isTmpVoiced = true;
                                    }
                                    if (isTmpVoiced && analysisParams.hpfBeforeNoiseAnalysis && analysisParams.decimateNoiseWaveform) {
                                        temp = SignalProcUtils.interpolate(temp, 0.5 * (double)hnmSignal.samplingRateInHz / (0.5 * (double)hnmSignal.samplingRateInHz - (double)hnmSignal.frames[currentFrameInd].maximumFrequencyOfVoicingInHz));
                                    }
                                    count2 = 0;
                                }
                                y[count] = temp[count2];
                                ++count;
                                ++count2;
                            }
                        }
                    }
                    if (!synthesisParams.hpfAfterNoiseSynthesis) {
                        y = SignalProcUtils.fdFilter(y, hnmSignal.frames[i].maximumFrequencyOfVoicingInHz, 0.5f * (float)hnmSignal.samplingRateInHz, hnmSignal.samplingRateInHz, fftSizeNoise);
                    }
                    winNoise = Window.get(windowType, y.length);
                    winNoise.normalizePeakValue(1.0f);
                    wgt = winNoise.getCoeffs();
                    int n = startIndex;
                    while (n < Math.min(startIndex + y.length, noisePart.length)) {
                        int n2 = n;
                        noisePart[n2] = noisePart[n2] + y[n - startIndex] * wgt[n - startIndex];
                        int n3 = n;
                        winWgtSum[n3] = winWgtSum[n3] + wgt[n - startIndex];
                        ++n;
                    }
                }
                if (!analysisParams.isSilentAnalysis) {
                    System.out.println("Waveform noise synthesis for analysis complete at " + String.valueOf(hnmSignal.frames[i].tAnalysisInSeconds) + "s. for frame " + String.valueOf(i + 1) + " of " + String.valueOf(hnmSignal.frames.length) + "...");
                }
                ++i;
            }
            i = 0;
            while (i < winWgtSum.length) {
                if (winWgtSum[i] > 0.0) {
                    int n = i;
                    noisePart[n] = noisePart[n] / winWgtSum[i];
                }
                ++i;
            }
        }
        if (analysisParams.preemphasisCoefNoise > 0.0f) {
            noisePart = SignalProcUtils.removePreemphasis(noisePart, analysisParams.preemphasisCoefNoise);
        }
        return noisePart;
    }
}

