/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartLpc;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.util.math.ArrayUtils;

public class HntmSpeechSignal {
    public HntmSpeechFrame[] frames;
    public int samplingRateInHz;
    public float originalDurationInSeconds;

    public HntmSpeechSignal(HntmSpeechSignal existing) {
        this.frames = null;
        if (existing != null) {
            if (existing.frames != null) {
                this.frames = new HntmSpeechFrame[existing.frames.length];
                int i = 0;
                while (i < existing.frames.length) {
                    this.frames[i] = new HntmSpeechFrame(existing.frames[i]);
                    ++i;
                }
            }
            this.samplingRateInHz = existing.samplingRateInHz;
            this.originalDurationInSeconds = existing.originalDurationInSeconds;
        }
    }

    public HntmSpeechSignal(int totalFrm, int samplingRateInHz, float originalDurationInSeconds) {
        if (totalFrm > 0) {
            this.frames = new HntmSpeechFrame[totalFrm];
            int i = 0;
            while (i < totalFrm) {
                this.frames[i] = new HntmSpeechFrame();
                ++i;
            }
        } else {
            this.frames = null;
        }
        this.samplingRateInHz = samplingRateInHz;
        this.originalDurationInSeconds = originalDurationInSeconds;
    }

    public HntmSpeechSignal(String binaryFile, int noiseModel) {
        try {
            this.read(binaryFile, noiseModel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(String binaryFile) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(binaryFile)));
        this.write(d);
    }

    public void write(DataOutputStream d) throws IOException {
        int totalFrm = 0;
        if (this.frames != null && this.frames.length > 0) {
            totalFrm = this.frames.length;
        }
        d.writeInt(totalFrm);
        if (totalFrm > 0) {
            int i = 0;
            while (i < totalFrm) {
                this.frames[i].write(d);
                ++i;
            }
        }
        d.writeInt(this.samplingRateInHz);
        d.writeFloat(this.originalDurationInSeconds);
    }

    public void read(String binaryFile, int noiseModel) throws IOException {
        DataInputStream d = new DataInputStream(new FileInputStream(new File(binaryFile)));
        this.read(d, noiseModel);
    }

    public void read(DataInputStream d, int noiseModel) throws IOException {
        int totalFrm = d.readInt();
        this.frames = null;
        if (totalFrm > 0) {
            this.frames = new HntmSpeechFrame[totalFrm];
            int i = 0;
            while (i < totalFrm) {
                this.frames[i] = new HntmSpeechFrame(d, noiseModel);
                ++i;
            }
        }
        this.samplingRateInHz = d.readInt();
        this.originalDurationInSeconds = d.readFloat();
    }

    public float[] getAnalysisTimes() {
        float[] times = null;
        if (this.frames != null) {
            times = new float[this.frames.length];
            int i = 0;
            while (i < this.frames.length) {
                times[i] = this.frames[i].tAnalysisInSeconds;
                ++i;
            }
        }
        return times;
    }

    public double[][] getPhasesInRadians() {
        double[][] phases = null;
        if (this.frames != null && this.frames.length > 0) {
            phases = new double[this.frames.length][];
            int i = 0;
            while (i < this.frames.length) {
                if (this.frames[i].h != null) {
                    phases[i] = this.frames[i].h.getPhasesInRadians();
                }
                ++i;
            }
        }
        return phases;
    }

    public float[][] getLpcsAll() {
        float[][] lpcsAll = null;
        if (this.frames != null && this.frames.length > 0) {
            lpcsAll = new float[this.frames.length][];
            int i = 0;
            while (i < this.frames.length) {
                if (this.frames[i].n instanceof FrameNoisePartLpc) {
                    lpcsAll[i] = ArrayUtils.copy(((FrameNoisePartLpc)this.frames[i].n).lpCoeffs);
                }
                ++i;
            }
        }
        return lpcsAll;
    }

    public float[] getLpcGainsAll() {
        float[] gainsAll = null;
        if (this.frames != null && this.frames.length > 0) {
            gainsAll = new float[this.frames.length];
            int i = 0;
            while (i < this.frames.length) {
                gainsAll[i] = this.frames[i].n instanceof FrameNoisePartLpc ? ((FrameNoisePartLpc)this.frames[i].n).lpGain : -1.0f;
                ++i;
            }
        }
        return gainsAll;
    }

    public float[] getOrigNoiseStds() {
        float[] origNoiseStdsAll = null;
        if (this.frames != null && this.frames.length > 0) {
            origNoiseStdsAll = new float[this.frames.length];
            int i = 0;
            while (i < this.frames.length) {
                if (this.frames[i].n != null && this.frames[i].n instanceof FrameNoisePartLpc) {
                    origNoiseStdsAll[i] = ((FrameNoisePartLpc)this.frames[i].n).origNoiseStd;
                }
                ++i;
            }
        }
        return origNoiseStdsAll;
    }

    public double[] getMaximumFrequencyOfVoicings() {
        double[] maximumFrequencyOfVoicings = null;
        if (this.frames != null && this.frames.length > 0) {
            maximumFrequencyOfVoicings = new double[this.frames.length];
            int i = 0;
            while (i < this.frames.length) {
                maximumFrequencyOfVoicings[i] = this.frames[i].maximumFrequencyOfVoicingInHz;
                ++i;
            }
        }
        return maximumFrequencyOfVoicings;
    }

    public int getTotalFrames() {
        if (this.frames != null && this.frames.length > 0) {
            return this.frames.length;
        }
        return 0;
    }
}

