/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.adaptation.prosody.BasicProsodyModifierParams;
import marytts.signalproc.analysis.F0TrackerAutocorrelationHeuristic;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.PitchFileHeader;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.sinusoidal.PeakMatchedSinusoidalSynthesizer;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzer;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmPlusTransientsSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignalWithContext;
import marytts.signalproc.sinusoidal.hntm.modification.HntmProsodyModifier;
import marytts.signalproc.sinusoidal.hntm.synthesis.HarmonicPartLinearPhaseInterpolatorSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizedSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.signalproc.sinusoidal.hntm.synthesis.NoisePartLpFilterPostHpfLpcSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.NoisePartPseudoHarmonicSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.NoisePartWaveformSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.NoisePartWindowedOverlapAddLpcSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.TransientPartSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.hybrid.HarmonicsToTrackConverter;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.MaryAudioUtils;
import marytts.util.io.FileUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class HntmSynthesizer {
    public HntmSynthesizedSignal synthesize(HntmSpeechSignal hntmSignal, HntmSpeechFrame[] leftContexts, HntmSpeechFrame[] rightContexts, BasicProsodyModifierParams pmodParams, String referenceFile, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParams) {
        new BasicProsodyModifierParams(pmodParams);
        HntmSpeechSignalWithContext prosodyModified = HntmProsodyModifier.modify(hntmSignal, leftContexts, rightContexts, pmodParams, analysisParams);
        HntmSynthesizedSignal s = new HntmSynthesizedSignal();
        if (synthesisParams.harmonicPartSynthesisMethod == 1) {
            HarmonicPartLinearPhaseInterpolatorSynthesizer hs = new HarmonicPartLinearPhaseInterpolatorSynthesizer(prosodyModified.hntmSignal, analysisParams, synthesisParams, referenceFile);
            s.harmonicPart = hs.synthesizeAll();
        } else if (synthesisParams.harmonicPartSynthesisMethod == 2) {
            SinusoidalTracks st = HarmonicsToTrackConverter.convert(prosodyModified.hntmSignal, analysisParams);
            PeakMatchedSinusoidalSynthesizer ss = new PeakMatchedSinusoidalSynthesizer(prosodyModified.hntmSignal.samplingRateInHz);
            s.harmonicPart = ss.synthesize(st, false);
        }
        if (analysisParams.noiseModel == 2) {
            if (synthesisParams.noisePartLpcSynthesisMethod == 1) {
                s.noisePart = NoisePartWindowedOverlapAddLpcSynthesizer.synthesize(prosodyModified.hntmSignal, analysisParams, synthesisParams);
            } else if (synthesisParams.noisePartLpcSynthesisMethod == 2) {
                s.noisePart = NoisePartLpFilterPostHpfLpcSynthesizer.synthesize(prosodyModified.hntmSignal, analysisParams, synthesisParams);
            }
        } else if (analysisParams.noiseModel == 3) {
            s.noisePart = NoisePartPseudoHarmonicSynthesizer.synthesize(prosodyModified.hntmSignal, analysisParams, synthesisParams, referenceFile);
        } else if (analysisParams.noiseModel == 1) {
            s.noisePart = NoisePartWaveformSynthesizer.synthesize(prosodyModified.hntmSignal, prosodyModified.leftContexts, prosodyModified.rightContexts, analysisParams);
        } else if (analysisParams.noiseModel == 4 || analysisParams.noiseModel == 5) {
            if (synthesisParams.noisePartLpcSynthesisMethod == 1) {
                s.noisePart = NoisePartWindowedOverlapAddLpcSynthesizer.synthesize(prosodyModified.hntmSignal, analysisParams, synthesisParams);
            } else if (synthesisParams.noisePartLpcSynthesisMethod == 2) {
                s.noisePart = NoisePartLpFilterPostHpfLpcSynthesizer.synthesize(prosodyModified.hntmSignal, analysisParams, synthesisParams);
            }
            double[] waveformNoisePart = NoisePartWaveformSynthesizer.synthesize(prosodyModified.hntmSignal, leftContexts, rightContexts, analysisParams);
            s.noisePart = SignalProcUtils.addSignals(s.noisePart, waveformNoisePart);
        }
        if (prosodyModified.hntmSignal instanceof HntmPlusTransientsSpeechSignal && ((HntmPlusTransientsSpeechSignal)prosodyModified.hntmSignal).transients != null) {
            s.transientPart = TransientPartSynthesizer.synthesize((HntmPlusTransientsSpeechSignal)prosodyModified.hntmSignal, analysisParams);
        }
        s.generateOutput();
        return s;
    }

    public static void mainSingleFile(String wavFile, HntmSynthesizerParams synthesisParams, float[][] pScalesArray, float[] pScalesTimes, float[][] tScalesArray, float[] tScalesTimes) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(wavFile));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        x = MathUtils.multiply(x, 32768.0);
        HntmAnalyzer ha = new HntmAnalyzer();
        String strComment = "autoMWF";
        HntmAnalyzerParams analysisParams = new HntmAnalyzerParams();
        analysisParams.harmonicModel = 1;
        analysisParams.noiseModel = 1;
        analysisParams.useHarmonicAmplitudesDirectly = true;
        analysisParams.harmonicSynthesisMethodBeforeNoiseAnalysis = 1;
        analysisParams.regularizedCepstrumWarpingMethod = 2;
        HntmSynthesizerParams synthesisParamsBeforeNoiseAnalysis = new HntmSynthesizerParams();
        synthesisParamsBeforeNoiseAnalysis.harmonicPartSynthesisMethod = 1;
        PitchReaderWriter f0 = null;
        String strPitchFile = StringUtils.modifyExtension((String)wavFile, (String)".ptc");
        if (FileUtils.exists((String)strPitchFile)) {
            f0 = new PitchReaderWriter(strPitchFile);
        } else {
            PitchFileHeader params = new PitchFileHeader();
            PitchFileHeader tmp = new PitchFileHeader();
            params.windowSizeInSeconds = tmp.windowSizeInSeconds;
            params.skipSizeInSeconds = tmp.skipSizeInSeconds;
            params.voicingThreshold = tmp.voicingThreshold;
            params.minimumF0 = tmp.minimumF0;
            params.maximumF0 = tmp.maximumF0;
            F0TrackerAutocorrelationHeuristic pitchDetector = new F0TrackerAutocorrelationHeuristic(params);
            try {
                f0 = pitchDetector.pitchAnalyzeWavFile(wavFile, strPitchFile);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                System.out.println("Error! Cannot perform pitch detection...");
            }
        }
        Labels labels = null;
        String strLabFile = StringUtils.modifyExtension((String)wavFile, (String)".lab");
        if (analysisParams.harmonicModel == 2) {
            if (!FileUtils.exists((String)strLabFile)) {
                System.out.println("Error! Labels required for transient analysis...");
                System.exit(1);
            }
            labels = new Labels(strLabFile);
        }
        String analysisResultsFile = StringUtils.modifyExtension((String)wavFile, (String)".ana");
        HntmSpeechSignal hnmSignal = null;
        if (FileUtils.exists((String)analysisResultsFile)) {
            System.out.println("  Warning! Analysis file found, skipping actual HNM analysis and reading from file.");
            System.out.println("  If analysis parameters have changed, delete this file and run the program again!");
            hnmSignal = new HntmSpeechSignal(analysisResultsFile, analysisParams.noiseModel);
        } else {
            hnmSignal = ha.analyze(x, samplingRate, f0, labels, analysisParams, synthesisParamsBeforeNoiseAnalysis, analysisResultsFile);
        }
        int n = 0;
        while (n < pScalesArray.length) {
            if (hnmSignal != null) {
                BasicProsodyModifierParams pmodParams = new BasicProsodyModifierParams(tScalesArray[n], tScalesTimes, pScalesArray[n], pScalesTimes);
                HntmSynthesizer hs = new HntmSynthesizer();
                HntmSynthesizedSignal xhat = hs.synthesize(hnmSignal, null, null, pmodParams, wavFile, analysisParams, synthesisParams);
                String outFileName = null;
                String strExt = "";
                String modelName = "";
                if (analysisParams.harmonicModel == 1) {
                    modelName = analysisParams.noiseModel == 1 ? "hwm" : "hnm";
                } else if (analysisParams.harmonicModel == 2) {
                    modelName = analysisParams.noiseModel == 1 ? "hwtm" : "hwtm";
                }
                if (strComment != null) {
                    modelName = String.valueOf(modelName) + "_" + strComment;
                }
                if (pScalesArray[n][0] != 1.0f) {
                    modelName = String.valueOf(modelName) + "_ps" + String.valueOf(pScalesArray[n][0]);
                }
                if (tScalesArray[n][0] != 1.0f) {
                    modelName = String.valueOf(modelName) + "_ts" + String.valueOf(tScalesArray[n][0]);
                }
                if (synthesisParams.normalizeOutputWav) {
                    xhat.output = MathUtils.multiply(xhat.output, MathUtils.absMax(x) / MathUtils.absMax(xhat.output));
                }
                outFileName = String.valueOf(wavFile.substring(0, wavFile.length() - 4)) + "_" + modelName + strExt + ".wav";
                MaryAudioUtils.writeWavFile(MathUtils.divide(xhat.output, 32768.0), outFileName, inputAudio.getFormat());
                System.out.println("Ouput file: " + outFileName);
                if (xhat.harmonicPart != null && synthesisParams.writeHarmonicPartToSeparateFile) {
                    outFileName = String.valueOf(wavFile.substring(0, wavFile.length() - 4)) + "_" + modelName + "Harmonic" + strExt + ".wav";
                    if (synthesisParams.normalizeHarmonicPartOutputWav) {
                        xhat.harmonicPart = MathUtils.multiply(xhat.harmonicPart, 32768.0 / MathUtils.getAbsMax(xhat.harmonicPart));
                    }
                    MaryAudioUtils.writeWavFile(MathUtils.divide(xhat.harmonicPart, 32768.0), outFileName, inputAudio.getFormat());
                }
                if (xhat.noisePart != null && synthesisParams.writeNoisePartToSeparateFile) {
                    outFileName = String.valueOf(wavFile.substring(0, wavFile.length() - 4)) + "_" + modelName + "Noise" + strExt + ".wav";
                    if (synthesisParams.normalizeNoisePartOutputWav) {
                        xhat.noisePart = MathUtils.multiply(xhat.noisePart, 32768.0 / MathUtils.getAbsMax(xhat.noisePart));
                    }
                    MaryAudioUtils.writeWavFile(MathUtils.divide(xhat.noisePart, 32768.0), outFileName, inputAudio.getFormat());
                }
                if (xhat.transientPart != null && synthesisParams.writeTransientPartToSeparateFile) {
                    outFileName = String.valueOf(wavFile.substring(0, wavFile.length() - 4)) + "_" + modelName + "Transient" + strExt + ".wav";
                    MaryAudioUtils.writeWavFile(MathUtils.divide(xhat.transientPart, 32768.0), outFileName, inputAudio.getFormat());
                }
                if (xhat.harmonicPart != null && synthesisParams.writeOriginalMinusHarmonicPartToSeparateFile) {
                    outFileName = String.valueOf(wavFile.substring(0, wavFile.length() - 4)) + "_" + modelName + "OrigMinusHarmonic" + strExt + ".wav";
                    MaryAudioUtils.writeWavFile(MathUtils.divide(SignalProcUtils.addSignals(x, 1.0, xhat.harmonicPart, -1.0), 32768.0), outFileName, inputAudio.getFormat());
                }
            }
            ++n;
        }
        System.out.println("Synthesis...done!");
    }

    public static void mainExamplesProsodyModification(String[] args) throws UnsupportedAudioFileException, IOException {
        HntmSynthesizerParams synthesisParams = new HntmSynthesizerParams();
        synthesisParams.harmonicPartSynthesisMethod = 1;
        synthesisParams.overlappingHarmonicPartSynthesis = false;
        synthesisParams.harmonicSynthesisOverlapInSeconds = 0.01f;
        synthesisParams.writeHarmonicPartToSeparateFile = false;
        synthesisParams.writeNoisePartToSeparateFile = false;
        synthesisParams.writeTransientPartToSeparateFile = false;
        synthesisParams.writeOriginalMinusHarmonicPartToSeparateFile = false;
        float[][] pScalesArray = new float[1][8];
        float[][] tScalesArray = new float[1][8];
        pScalesArray[0][0] = 1.0f;
        tScalesArray[0][0] = 0.1f;
        pScalesArray[0][1] = 1.0f;
        tScalesArray[0][1] = 0.2f;
        pScalesArray[0][2] = 1.0f;
        tScalesArray[0][2] = 0.3f;
        pScalesArray[0][3] = 1.0f;
        tScalesArray[0][3] = 0.4f;
        pScalesArray[0][4] = 1.0f;
        tScalesArray[0][4] = 1.6f;
        pScalesArray[0][5] = 1.0f;
        tScalesArray[0][5] = 1.8f;
        pScalesArray[0][6] = 1.0f;
        tScalesArray[0][6] = 2.0f;
        pScalesArray[0][7] = 1.0f;
        tScalesArray[0][7] = 2.2f;
        float[] pScalesTimes = new float[]{0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.3f};
        float[] tScalesTimes = new float[]{0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.3f};
        HntmSynthesizer.mainSingleFile(args[0], synthesisParams, pScalesArray, pScalesTimes, tScalesArray, tScalesTimes);
        pScalesArray = new float[1][8];
        tScalesArray = new float[1][8];
        pScalesArray[0][0] = 1.0f;
        tScalesArray[0][0] = 1.0f;
        pScalesArray[0][1] = 2.0f;
        tScalesArray[0][1] = 1.0f;
        pScalesArray[0][2] = 3.0f;
        tScalesArray[0][2] = 1.0f;
        pScalesArray[0][3] = 4.0f;
        tScalesArray[0][3] = 1.0f;
        pScalesArray[0][4] = 5.0f;
        tScalesArray[0][4] = 1.0f;
        pScalesArray[0][5] = 6.0f;
        tScalesArray[0][5] = 1.0f;
        pScalesArray[0][6] = 7.0f;
        tScalesArray[0][6] = 1.0f;
        pScalesArray[0][7] = 8.0f;
        tScalesArray[0][7] = 1.0f;
        HntmSynthesizer.mainSingleFile(args[0], synthesisParams, pScalesArray, pScalesTimes, tScalesArray, tScalesTimes);
        pScalesArray[0][0] = 0.3f;
        tScalesArray[0][0] = 1.0f;
        pScalesArray[0][1] = 0.4f;
        tScalesArray[0][1] = 1.0f;
        pScalesArray[0][2] = 0.5f;
        tScalesArray[0][2] = 1.0f;
        pScalesArray[0][3] = 0.6f;
        tScalesArray[0][3] = 1.0f;
        pScalesArray[0][4] = 0.7f;
        tScalesArray[0][4] = 1.0f;
        pScalesArray[0][5] = 0.8f;
        tScalesArray[0][5] = 1.0f;
        pScalesArray[0][6] = 0.9f;
        tScalesArray[0][6] = 1.0f;
        pScalesArray[0][7] = 1.0f;
        tScalesArray[0][7] = 1.0f;
        HntmSynthesizer.mainSingleFile(args[0], synthesisParams, pScalesArray, pScalesTimes, tScalesArray, tScalesTimes);
        float[][] pScalesArray1 = new float[1][4];
        float[][] tScalesArray1 = new float[1][2];
        pScalesArray1[0][0] = 1.0f;
        tScalesArray1[0][0] = 0.5f;
        pScalesArray1[0][1] = 2.0f;
        tScalesArray1[0][1] = 3.5f;
        pScalesArray1[0][2] = 3.0f;
        pScalesArray1[0][3] = 4.0f;
        float[] pScalesTimes1 = new float[]{0.3f, 0.5f, 0.9f, 1.3f};
        float[] tScalesTimes1 = new float[]{0.7f, 1.3f};
        HntmSynthesizer.mainSingleFile(args[0], synthesisParams, pScalesArray1, pScalesTimes1, tScalesArray1, tScalesTimes1);
        float[][] pScalesArray2 = new float[1][1];
        float[][] tScalesArray2 = new float[1][1];
        pScalesArray2[0][0] = 0.5f;
        tScalesArray2[0][0] = 1.5f;
        float[] pScalesTimes2 = new float[]{0.7f};
        float[] tScalesTimes2 = new float[]{1.3f};
        HntmSynthesizer.mainSingleFile(args[0], synthesisParams, pScalesArray2, pScalesTimes2, tScalesArray2, tScalesTimes2);
        float[][] pScalesArray3 = new float[1][1];
        float[][] tScalesArray3 = new float[1][1];
        pScalesArray3[0][0] = 1.0f;
        tScalesArray3[0][0] = 1.0f;
        float[] pScalesTimes3 = null;
        float[] tScalesTimes3 = null;
        HntmSynthesizer.mainSingleFile(args[0], synthesisParams, pScalesArray3, pScalesTimes3, tScalesArray3, tScalesTimes3);
    }

    public static void mainProcessDirOrFile(String[] args) throws UnsupportedAudioFileException, IOException {
        HntmSynthesizerParams synthesisParams = new HntmSynthesizerParams();
        synthesisParams.harmonicPartSynthesisMethod = 1;
        synthesisParams.overlappingHarmonicPartSynthesis = false;
        synthesisParams.harmonicSynthesisOverlapInSeconds = 0.01f;
        float[][] pScalesArray = new float[1][8];
        float[][] tScalesArray = new float[1][8];
        pScalesArray[0][0] = 1.0f;
        tScalesArray[0][0] = 1.0f;
        pScalesArray[0][1] = 0.8f;
        tScalesArray[0][1] = 1.0f;
        pScalesArray[0][2] = 1.6f;
        tScalesArray[0][2] = 1.0f;
        pScalesArray[0][3] = 1.0f;
        tScalesArray[0][3] = 0.7f;
        pScalesArray[0][4] = 1.0f;
        tScalesArray[0][4] = 1.6f;
        pScalesArray[0][5] = 1.0f;
        tScalesArray[0][5] = 2.3f;
        pScalesArray[0][6] = 2.3f;
        tScalesArray[0][6] = 1.0f;
        pScalesArray[0][7] = 0.6f;
        tScalesArray[0][7] = 1.0f;
        float[] pScalesTimes = new float[]{0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.3f};
        float[] tScalesTimes = new float[]{0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.3f};
        if (FileUtils.isDirectory((String)args[0])) {
            String[] fileList = FileUtils.getFileList((String)args[0], (String)"wav");
            if (fileList != null) {
                int i = 0;
                while (i < fileList.length) {
                    HntmSynthesizer.mainSingleFile(fileList[i], synthesisParams, pScalesArray, pScalesTimes, tScalesArray, tScalesTimes);
                    System.out.println("HNM processing completed for file " + String.valueOf(i + 1) + " of " + String.valueOf(fileList.length));
                    ++i;
                }
            } else {
                System.out.println("No wav files found!");
            }
        } else {
            HntmSynthesizer.mainSingleFile(args[0], synthesisParams, pScalesArray, pScalesTimes, tScalesArray, tScalesTimes);
        }
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        HntmSynthesizer.mainExamplesProsodyModification(args);
    }
}

