/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis;

import java.util.Arrays;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartWaveform;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.window.HammingWindow;
import marytts.util.math.ArrayUtils;
import marytts.util.signal.SignalProcUtils;

public class NoisePartWaveformSynthesizer {
    public static double[] synthesize(HntmSpeechSignal hnmSignal, HntmSpeechFrame[] leftContexts, HntmSpeechFrame[] rightContexts, HntmAnalyzerParams analysisParams) {
        double[] noisePartWaveform = null;
        if (hnmSignal != null && hnmSignal.frames != null) {
            int outputLen = SignalProcUtils.time2sample(hnmSignal.originalDurationInSeconds, hnmSignal.samplingRateInHz);
            noisePartWaveform = new double[outputLen];
            double[] wgts = new double[outputLen];
            Arrays.fill(noisePartWaveform, 0.0);
            Arrays.fill(wgts, 0.0);
            int i = 0;
            while (i < hnmSignal.frames.length) {
                HntmSpeechFrame prevFrame = i > 0 ? hnmSignal.frames[i - 1] : null;
                HntmSpeechFrame nextFrame = i < hnmSignal.frames.length - 1 ? hnmSignal.frames[i + 1] : null;
                boolean isFirstSynthesisFrame = false;
                if (i == 0) {
                    isFirstSynthesisFrame = true;
                }
                boolean isLastSynthesisFrame = false;
                if (i == hnmSignal.frames.length - 1) {
                    isLastSynthesisFrame = true;
                }
                boolean existsLeftContexts = true;
                if (leftContexts == null) {
                    existsLeftContexts = false;
                }
                boolean existsRightContexts = true;
                if (rightContexts == null) {
                    existsRightContexts = false;
                }
                HntmSpeechFrame currentLeftContext = null;
                if (leftContexts != null) {
                    currentLeftContext = leftContexts[i];
                }
                HntmSpeechFrame currentRightContext = null;
                if (rightContexts != null) {
                    currentRightContext = rightContexts[i];
                }
                NoisePartWaveformSynthesizer.processFrame(prevFrame, hnmSignal.frames[i], nextFrame, hnmSignal.samplingRateInHz, isFirstSynthesisFrame, isLastSynthesisFrame, noisePartWaveform, wgts, existsLeftContexts, currentLeftContext, existsRightContexts, currentRightContext);
                ++i;
            }
            i = 0;
            while (i < outputLen) {
                if (wgts[i] > 1.0E-10) {
                    int n = i;
                    noisePartWaveform[n] = noisePartWaveform[n] / wgts[i];
                }
                ++i;
            }
        }
        return noisePartWaveform;
    }

    public static void processFrame(HntmSpeechFrame prevFrame, HntmSpeechFrame currentFrame, HntmSpeechFrame nextFrame, int samplingRateInHz, boolean isFirstSynthesisFrame, boolean isLastSynthesisFrame, double[] noisePartWaveform, double[] wgts, boolean existsLeftContexts, HntmSpeechFrame currentLeftContext, boolean existsRightContexts, HntmSpeechFrame currentRightContext) {
        double[] frameWaveform = null;
        double[] leftContextWaveform = null;
        double[] rightContextWaveform = null;
        if (currentFrame.n != null && currentFrame.n instanceof FrameNoisePartWaveform) {
            frameWaveform = ((FrameNoisePartWaveform)currentFrame.n).waveform2Doubles();
            if (!existsLeftContexts) {
                if (!isFirstSynthesisFrame) {
                    leftContextWaveform = ((FrameNoisePartWaveform)prevFrame.n).waveform2Doubles();
                } else {
                    leftContextWaveform = new double[frameWaveform.length];
                    Arrays.fill(leftContextWaveform, 0.0);
                }
            } else if (currentLeftContext != null && currentLeftContext.n != null) {
                leftContextWaveform = ArrayUtils.copy(((FrameNoisePartWaveform)currentLeftContext.n).waveform2Doubles());
            } else {
                leftContextWaveform = new double[frameWaveform.length];
                Arrays.fill(leftContextWaveform, 0.0);
            }
            int waveformNoiseStartInd = SignalProcUtils.time2sample(currentFrame.tAnalysisInSeconds, samplingRateInHz);
            waveformNoiseStartInd -= leftContextWaveform.length;
            if (!existsRightContexts) {
                if (!isLastSynthesisFrame) {
                    rightContextWaveform = ((FrameNoisePartWaveform)nextFrame.n).waveform2Doubles();
                } else {
                    rightContextWaveform = new double[frameWaveform.length];
                    Arrays.fill(rightContextWaveform, 0.0);
                }
            } else if (currentRightContext != null && currentRightContext.n != null) {
                rightContextWaveform = ArrayUtils.copy(((FrameNoisePartWaveform)currentRightContext.n).waveform2Doubles());
            } else {
                rightContextWaveform = new double[frameWaveform.length];
                Arrays.fill(rightContextWaveform, 0.0);
            }
            frameWaveform = ArrayUtils.combine(leftContextWaveform, frameWaveform);
            frameWaveform = ArrayUtils.combine(frameWaveform, rightContextWaveform);
            if (frameWaveform != null) {
                HammingWindow w = new HammingWindow(frameWaveform.length);
                double[] wgt = w.getCoeffs();
                int j = waveformNoiseStartInd;
                while (j < Math.min(waveformNoiseStartInd + frameWaveform.length, noisePartWaveform.length)) {
                    if (waveformNoiseStartInd + j >= 0) {
                        int n = j;
                        noisePartWaveform[n] = noisePartWaveform[n] + frameWaveform[j - waveformNoiseStartInd] * wgt[j - waveformNoiseStartInd];
                        int n2 = j;
                        wgts[n2] = wgts[n2] + wgt[j - waveformNoiseStartInd];
                    }
                    ++j;
                }
            }
        }
    }
}

