/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.test;

import java.io.IOException;
import marytts.signalproc.sinusoidal.Sinusoid;
import marytts.signalproc.sinusoidal.test.SinusoidsTester;

public class HarmonicsTester
extends SinusoidsTester {
    public HarmonicsTester(float freqInHz, int numHarmonics) {
        this(freqInHz, numHarmonics, DEFAULT_DUR, DEFAULT_FS);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float durationInSeconds) {
        this(freqInHz, numHarmonics, durationInSeconds, DEFAULT_FS);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float durationInSeconds, int samplingRateInHz) {
        this(freqInHz, numHarmonics, durationInSeconds, samplingRateInHz, null, null);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float[] amps) {
        this(freqInHz, numHarmonics, amps, null);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float[] amps, float[] phases) {
        this(freqInHz, numHarmonics, DEFAULT_DUR, DEFAULT_FS, amps, phases);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float durationInSeconds, float[] amps) {
        this(freqInHz, numHarmonics, durationInSeconds, DEFAULT_FS, amps, null);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float durationInSeconds, int samplingRateInHz, float[] amps) {
        this(freqInHz, numHarmonics, durationInSeconds, samplingRateInHz, amps, null);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float durationInSeconds, int samplingRateInHz, float[] amps, float[] phases) {
        if (numHarmonics > 0) {
            Sinusoid[] sins = new Sinusoid[numHarmonics];
            int i = 0;
            while (i < numHarmonics) {
                float currentAmp = amps != null && amps.length > i ? amps[i] : DEFAULT_AMP;
                float currentPhase = phases != null && phases.length > i ? phases[i] : DEFAULT_PHASE;
                sins[i] = new Sinusoid(currentAmp, freqInHz * (float)(i + 1), currentPhase);
                ++i;
            }
            this.init(sins, durationInSeconds, samplingRateInHz);
        }
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float startTimeInSeconds, float endTimeInSeconds) {
        this(freqInHz, numHarmonics, startTimeInSeconds, endTimeInSeconds, DEFAULT_FS);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float startTimeInSeconds, float endTimeInSeconds, int samplingRateInHz) {
        this(freqInHz, numHarmonics, startTimeInSeconds, endTimeInSeconds, samplingRateInHz, null);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float startTimeInSeconds, float endTimeInSeconds, int samplingRateInHz, float[] amps) {
        this(freqInHz, numHarmonics, startTimeInSeconds, endTimeInSeconds, samplingRateInHz, amps, null);
    }

    public HarmonicsTester(float freqInHz, int numHarmonics, float startTimeInSeconds, float endTimeInSeconds, int samplingRateInHz, float[] amps, float[] phases) {
        if (numHarmonics > 0) {
            Sinusoid[] sins = new Sinusoid[numHarmonics];
            int i = 0;
            while (i < numHarmonics) {
                float currentAmp = amps != null && amps.length > i ? amps[i] : DEFAULT_AMP;
                float currentPhase = phases != null && phases.length > i ? phases[i] : DEFAULT_PHASE;
                sins[i] = new Sinusoid(currentAmp, freqInHz * (float)(i + 1), currentPhase);
                ++i;
            }
            this.init(sins, startTimeInSeconds, endTimeInSeconds, samplingRateInHz);
        }
    }

    public static void main(String[] args) throws IOException {
        HarmonicsTester s = null;
        float f1 = 115.0f;
        int numHarmonics = 8;
        double defaultAbsMaxVal = 13000.0;
        float[] amps = new float[numHarmonics];
        int i = 0;
        while (i < numHarmonics) {
            amps[i] = 0.5f / (float)numHarmonics;
            ++i;
        }
        s = new HarmonicsTester(f1, numHarmonics, amps);
        if (args.length > 1) {
            s.write(args[0], args[1], defaultAbsMaxVal);
        } else if (args.length == 1) {
            s.write(args[0], defaultAbsMaxVal);
        } else {
            String outWavFile = "d:\\h" + String.valueOf(numHarmonics) + "_" + String.valueOf(f1) + "_" + String.valueOf(defaultAbsMaxVal) + ".wav";
            s.write(outWavFile, defaultAbsMaxVal);
        }
    }
}

