/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;

public class BlockwiseDoubleDataSource
extends BufferedDoubleDataSource {
    protected int blockSize;

    public BlockwiseDoubleDataSource(DoubleDataSource inputSource, int blockSize) {
        super(inputSource);
        this.blockSize = blockSize;
    }

    @Override
    protected boolean readIntoBuffer(int minLength) {
        if (this.bufferSpaceLeft() < minLength) {
            this.increaseBufferSize(minLength + this.currentlyInBuffer());
        } else if (this.buf.length - this.writePos < minLength) {
            this.compact();
        }
        int readSum = 0;
        while (readSum < minLength && this.hasMoreData()) {
            int read;
            this.prepareBlock();
            int blockSize = this.getBlockSize();
            if (this.buf.length < this.writePos + blockSize) {
                this.increaseBufferSize(this.writePos + blockSize);
            }
            if ((read = this.readBlock(this.buf, this.writePos)) == 0) break;
            this.writePos += read;
            readSum += read;
        }
        if (this.dataProcessor != null) {
            this.dataProcessor.applyInline(this.buf, this.writePos - readSum, readSum);
        }
        return readSum >= minLength;
    }

    protected int getBlockSize() {
        return this.blockSize;
    }

    protected void prepareBlock() {
    }

    protected int readBlock(double[] target, int pos) {
        return this.inputSource.getData(target, pos, this.getBlockSize());
    }
}

